/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.service.AbstractService;

public class NodesListManager
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(NodesListManager.class);
    private HostsFileReader hostsReader;
    private Configuration conf;

    public NodesListManager() {
        super(NodesListManager.class.getName());
    }

    public void init(Configuration conf) {
        this.conf = conf;
        try {
            this.hostsReader = new HostsFileReader(conf.get("yarn.resourcemanager.nodes.include-path", ""), conf.get("yarn.resourcemanager.nodes.exclude-path", ""));
            this.printConfiguredHosts();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Failed to init hostsReader, disabling", (Throwable)ioe);
            try {
                this.hostsReader = new HostsFileReader("", "");
            }
            catch (IOException ioe2) {
                this.hostsReader = null;
                throw new YarnException((Throwable)ioe2);
            }
        }
        super.init(conf);
    }

    private void printConfiguredHosts() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug((Object)("hostsReader: in=" + this.conf.get("yarn.resourcemanager.nodes.include-path", "") + " out=" + this.conf.get("yarn.resourcemanager.nodes.exclude-path", "")));
        for (String include : this.hostsReader.getHosts()) {
            LOG.debug((Object)("include: " + include));
        }
        for (String exclude : this.hostsReader.getExcludedHosts()) {
            LOG.debug((Object)("exclude: " + exclude));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNodes() throws IOException {
        HostsFileReader hostsFileReader = this.hostsReader;
        synchronized (hostsFileReader) {
            this.hostsReader.refresh();
            this.printConfiguredHosts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidNode(String hostName) {
        HostsFileReader hostsFileReader = this.hostsReader;
        synchronized (hostsFileReader) {
            Set hostsList = this.hostsReader.getHosts();
            Set excludeList = this.hostsReader.getExcludedHosts();
            return (hostsList.isEmpty() || hostsList.contains(hostName)) && !excludeList.contains(hostName);
        }
    }
}

