/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationMaster;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationMasterPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeReportPBImpl;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.ApplicationsStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Store;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZKStore
implements Store {
    private final Configuration conf;
    private final ZooKeeper zkClient;
    private static final Log LOG = LogFactory.getLog(ZKStore.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static final String NODES = "nodes/";
    private static final String APPS = "apps/";
    private static final String ZK_PATH_SEPARATOR = "/";
    private static final String NODE_ID = "nodeid";
    private static final String APP_MASTER = "master";
    private static final String APP_MASTER_CONTAINER = "mastercontainer";
    private final String ZK_ADDRESS;
    private final int ZK_TIMEOUT;
    private boolean doneWithRecovery = false;
    private NodeIdPBImpl nodeId = new NodeIdPBImpl();

    public ZKStore(Configuration conf) throws IOException {
        this.conf = conf;
        this.ZK_ADDRESS = conf.get("yarn.resourcemanager.zookeeper-store.address");
        this.ZK_TIMEOUT = conf.getInt("yarn.resourcemanager.zookeeper-store.session.timeout-ms", 60000);
        this.zkClient = new ZooKeeper(this.ZK_ADDRESS, this.ZK_TIMEOUT, this.createZKWatcher());
    }

    protected Watcher createZKWatcher() {
        return new ZKWatcher();
    }

    private NodeReportPBImpl createNodeManagerInfo(RMNode rmNode) {
        NodeReport node = (NodeReport)this.recordFactory.newRecordInstance(NodeReport.class);
        node.setNodeId(rmNode.getNodeID());
        node.setRackName(rmNode.getRackName());
        node.setCapability(rmNode.getTotalCapability());
        return (NodeReportPBImpl)node;
    }

    @Override
    public synchronized void storeNode(RMNode node) throws IOException {
        if (!this.doneWithRecovery) {
            return;
        }
    }

    @Override
    public synchronized void removeNode(RMNode node) throws IOException {
        if (!this.doneWithRecovery) {
            return;
        }
    }

    private static IOException convertToIOException(KeeperException ke) {
        IOException io = new IOException();
        io.setStackTrace(ke.getStackTrace());
        return io;
    }

    @Override
    public synchronized NodeId getNextNodeId() throws IOException {
        return this.nodeId;
    }

    private String containerPathFromContainerId(ContainerId containerId) {
        String appString = ConverterUtils.toString((ApplicationId)containerId.getApplicationAttemptId().getApplicationId());
        return appString + ZK_PATH_SEPARATOR + containerId.getId();
    }

    @Override
    public synchronized ApplicationsStore.ApplicationStore createApplicationStore(ApplicationId application, ApplicationSubmissionContext context) throws IOException {
        if (!this.doneWithRecovery) {
            return new ZKApplicationStore(application);
        }
        ApplicationSubmissionContextPBImpl contextPBImpl = (ApplicationSubmissionContextPBImpl)context;
        String appString = APPS + ConverterUtils.toString((ApplicationId)application);
        ApplicationMasterPBImpl masterPBImpl = new ApplicationMasterPBImpl();
        ContainerPBImpl container = new ContainerPBImpl();
        try {
            this.zkClient.create(appString, contextPBImpl.getProto().toByteArray(), null, CreateMode.PERSISTENT);
            this.zkClient.create(appString + ZK_PATH_SEPARATOR + APP_MASTER, masterPBImpl.getProto().toByteArray(), null, CreateMode.PERSISTENT);
            this.zkClient.create(appString + ZK_PATH_SEPARATOR + APP_MASTER_CONTAINER, container.getProto().toByteArray(), null, CreateMode.PERSISTENT);
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted", (Throwable)ie);
            throw new InterruptedIOException(ie.getMessage());
        }
        catch (KeeperException ke) {
            LOG.info((Object)"Keeper exception", (Throwable)ke);
            throw ZKStore.convertToIOException(ke);
        }
        return new ZKApplicationStore(application);
    }

    @Override
    public synchronized void removeApplication(ApplicationId application) throws IOException {
        if (!this.doneWithRecovery) {
            return;
        }
        try {
            this.zkClient.delete(APPS + ConverterUtils.toString((ApplicationId)application), -1);
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted", (Throwable)ie);
            throw new InterruptedIOException(ie.getMessage());
        }
        catch (KeeperException ke) {
            LOG.info((Object)"Keeper Exception", (Throwable)ke);
            throw ZKStore.convertToIOException(ke);
        }
    }

    @Override
    public boolean isLoggable() {
        return this.doneWithRecovery;
    }

    @Override
    public void doneWithRecovery() {
        this.doneWithRecovery = true;
    }

    @Override
    public synchronized Store.RMState restore() throws IOException {
        ZKRMState rmState = new ZKRMState();
        rmState.load();
        return rmState;
    }

    private class ZKRMState
    implements Store.RMState {
        private List<RMNode> nodeManagers = new ArrayList<RMNode>();
        private Map<ApplicationId, Store.ApplicationInfo> applications = new HashMap<ApplicationId, Store.ApplicationInfo>();

        public ZKRMState() {
            LOG.info((Object)"Restoring RM state from ZK");
        }

        private synchronized List<NodeReport> listStoredNodes() throws IOException {
            ArrayList<NodeReport> nodes = new ArrayList<NodeReport>();
            Stat stat = new Stat();
            try {
                List children = ZKStore.this.zkClient.getChildren(ZKStore.NODES, false);
                for (String child : children) {
                    byte[] data = ZKStore.this.zkClient.getData(ZKStore.NODES + child, false, stat);
                    NodeReportPBImpl nmImpl = new NodeReportPBImpl(YarnProtos.NodeReportProto.parseFrom((byte[])data));
                    nodes.add((NodeReport)nmImpl);
                }
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted", (Throwable)ie);
                throw new InterruptedIOException("Interrupted");
            }
            catch (KeeperException ke) {
                LOG.error((Object)"Failed to list nodes", (Throwable)ke);
                throw ZKStore.convertToIOException(ke);
            }
            return nodes;
        }

        @Override
        public List<RMNode> getStoredNodeManagers() {
            return this.nodeManagers;
        }

        @Override
        public NodeId getLastLoggedNodeId() {
            return ZKStore.this.nodeId;
        }

        private void readLastNodeId() throws IOException {
            Stat stat = new Stat();
            try {
                byte[] data = ZKStore.this.zkClient.getData("nodes/nodeid", false, stat);
                ZKStore.this.nodeId = new NodeIdPBImpl(YarnProtos.NodeIdProto.parseFrom((byte[])data));
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted", (Throwable)ie);
                throw new InterruptedIOException(ie.getMessage());
            }
            catch (KeeperException ke) {
                LOG.info((Object)"Keeper Exception", (Throwable)ke);
                throw ZKStore.convertToIOException(ke);
            }
        }

        private Store.ApplicationInfo getAppInfo(String app) throws IOException {
            ApplicationInfoImpl info = null;
            Stat stat = new Stat();
            try {
                ApplicationSubmissionContextPBImpl context = null;
                byte[] data = ZKStore.this.zkClient.getData(ZKStore.APPS + app, false, stat);
                context = new ApplicationSubmissionContextPBImpl(YarnProtos.ApplicationSubmissionContextProto.parseFrom((byte[])data));
                info = new ApplicationInfoImpl((ApplicationSubmissionContext)context);
                List children = ZKStore.this.zkClient.getChildren(ZKStore.APPS + app, false, stat);
                ApplicationMasterPBImpl master = null;
                for (String child : children) {
                    byte[] childdata = ZKStore.this.zkClient.getData(ZKStore.APPS + app + ZKStore.ZK_PATH_SEPARATOR + child, false, stat);
                    if (ZKStore.APP_MASTER.equals(child)) {
                        master = new ApplicationMasterPBImpl(YarnProtos.ApplicationMasterProto.parseFrom((byte[])childdata));
                        info.setApplicationMaster((ApplicationMaster)master);
                        continue;
                    }
                    if (ZKStore.APP_MASTER_CONTAINER.equals(child)) {
                        ContainerPBImpl masterContainer = new ContainerPBImpl(YarnProtos.ContainerProto.parseFrom((byte[])data));
                        info.setMasterContainer((Container)masterContainer);
                        continue;
                    }
                    ContainerPBImpl container = new ContainerPBImpl(YarnProtos.ContainerProto.parseFrom((byte[])data));
                    info.addContainer((Container)container);
                }
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted", (Throwable)ie);
                throw new InterruptedIOException(ie.getMessage());
            }
            catch (KeeperException ke) {
                throw ZKStore.convertToIOException(ke);
            }
            return info;
        }

        private void load() throws IOException {
            List<NodeReport> nodeInfos = this.listStoredNodes();
            Pattern trackerPattern = Pattern.compile(".*:.*");
            Matcher m = trackerPattern.matcher("");
            for (NodeReport node : nodeInfos) {
                m.reset(node.getNodeId().getHost());
                if (!m.find()) {
                    LOG.info((Object)("Skipping node, bad node-address " + node.getNodeId().getHost()));
                    continue;
                }
                String hostName = m.group(0);
                int cmPort = Integer.valueOf(m.group(1));
                m.reset(node.getHttpAddress());
                if (!m.find()) {
                    LOG.info((Object)("Skipping node, bad http-address " + node.getHttpAddress()));
                    continue;
                }
                int httpPort = Integer.valueOf(m.group(1));
            }
            this.readLastNodeId();
            List apps = null;
            try {
                apps = ZKStore.this.zkClient.getChildren(ZKStore.APPS, false);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted", (Throwable)ie);
                throw new InterruptedIOException(ie.getMessage());
            }
            catch (KeeperException ke) {
                throw ZKStore.convertToIOException(ke);
            }
            for (String app : apps) {
                Store.ApplicationInfo info = this.getAppInfo(app);
                this.applications.put(info.getApplicationMaster().getApplicationId(), info);
            }
        }

        @Override
        public Map<ApplicationId, Store.ApplicationInfo> getStoredApplications() {
            return this.applications;
        }
    }

    private static class ApplicationInfoImpl
    implements Store.ApplicationInfo {
        private ApplicationMaster master;
        private Container masterContainer;
        private final ApplicationSubmissionContext context;
        private final List<Container> containers = new ArrayList<Container>();

        public ApplicationInfoImpl(ApplicationSubmissionContext context) {
            this.context = context;
        }

        public void setApplicationMaster(ApplicationMaster master) {
            this.master = master;
        }

        public void setMasterContainer(Container container) {
            this.masterContainer = container;
        }

        @Override
        public ApplicationMaster getApplicationMaster() {
            return this.master;
        }

        @Override
        public ApplicationSubmissionContext getApplicationSubmissionContext() {
            return this.context;
        }

        @Override
        public Container getMasterContainer() {
            return this.masterContainer;
        }

        @Override
        public List<Container> getContainers() {
            return this.containers;
        }

        public void addContainer(Container container) {
            this.containers.add(container);
        }
    }

    private class ZKApplicationStore
    implements ApplicationsStore.ApplicationStore {
        private final ApplicationId applicationId;

        public ZKApplicationStore(ApplicationId applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public void storeMasterContainer(Container container) throws IOException {
            if (!ZKStore.this.doneWithRecovery) {
                return;
            }
            ContainerPBImpl containerPBImpl = (ContainerPBImpl)container;
            try {
                ZKStore.this.zkClient.setData(ZKStore.APPS + ConverterUtils.toString((ApplicationId)container.getId().getApplicationAttemptId().getApplicationId()) + ZKStore.ZK_PATH_SEPARATOR + ZKStore.APP_MASTER_CONTAINER, containerPBImpl.getProto().toByteArray(), -1);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted", (Throwable)ie);
                throw new InterruptedIOException(ie.getMessage());
            }
            catch (KeeperException ke) {
                LOG.info((Object)"Keeper exception", (Throwable)ke);
                throw ZKStore.convertToIOException(ke);
            }
        }

        @Override
        public synchronized void storeContainer(Container container) throws IOException {
            if (!ZKStore.this.doneWithRecovery) {
                return;
            }
            ContainerPBImpl containerPBImpl = (ContainerPBImpl)container;
            try {
                ZKStore.this.zkClient.create(ZKStore.APPS + ZKStore.this.containerPathFromContainerId(container.getId()), containerPBImpl.getProto().toByteArray(), null, CreateMode.PERSISTENT);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted", (Throwable)ie);
                throw new InterruptedIOException(ie.getMessage());
            }
            catch (KeeperException ke) {
                LOG.info((Object)"Keeper exception", (Throwable)ke);
                throw ZKStore.convertToIOException(ke);
            }
        }

        @Override
        public synchronized void removeContainer(Container container) throws IOException {
            if (!ZKStore.this.doneWithRecovery) {
                return;
            }
            try {
                ZKStore.this.zkClient.delete(ZKStore.APPS + ZKStore.this.containerPathFromContainerId(container.getId()), -1);
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException(ie.getMessage());
            }
            catch (KeeperException ke) {
                LOG.info((Object)"Keeper exception", (Throwable)ke);
                throw ZKStore.convertToIOException(ke);
            }
        }

        @Override
        public void updateApplicationState(ApplicationMaster master) throws IOException {
            if (!ZKStore.this.doneWithRecovery) {
                return;
            }
            String appString = ZKStore.APPS + ConverterUtils.toString((ApplicationId)this.applicationId);
            ApplicationMasterPBImpl masterPBImpl = (ApplicationMasterPBImpl)master;
            try {
                ZKStore.this.zkClient.setData(appString, masterPBImpl.getProto().toByteArray(), -1);
            }
            catch (InterruptedException ie) {
                LOG.info((Object)"Interrupted", (Throwable)ie);
                throw new InterruptedIOException(ie.getMessage());
            }
            catch (KeeperException ke) {
                LOG.info((Object)"Keeper exception", (Throwable)ke);
                throw ZKStore.convertToIOException(ke);
            }
        }

        @Override
        public boolean isLoggable() {
            return ZKStore.this.doneWithRecovery;
        }
    }

    private static class ZKWatcher
    implements Watcher {
        private ZKWatcher() {
        }

        public void process(WatchedEvent arg0) {
        }
    }
}

