/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStatusupdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BuilderUtils;

public class RMAppAttemptImpl
implements RMAppAttempt {
    private static final Log LOG = LogFactory.getLog(RMAppAttemptImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final Priority AM_CONTAINER_PRIORITY = (Priority)recordFactory.newRecordInstance(Priority.class);
    private final StateMachine<RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachine;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ApplicationAttemptId applicationAttemptId;
    private final String clientToken;
    private final ApplicationSubmissionContext submissionContext;
    private final Set<NodeId> ranNodes = new HashSet<NodeId>();
    private final List<ContainerStatus> justFinishedContainers = new ArrayList<ContainerStatus>();
    private Container masterContainer;
    private float progress = 0.0f;
    private String host = "N/A";
    private int rpcPort;
    private String origTrackingUrl = "N/A";
    private String proxiedTrackingUrl = "N/A";
    private FinalApplicationStatus finalStatus = null;
    private final StringBuilder diagnostics = new StringBuilder();
    private final String proxy;
    private static final StateMachineFactory<RMAppAttemptImpl, RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachineFactory;
    private static final List<ContainerId> EMPTY_CONTAINER_RELEASE_LIST;
    private static final List<ResourceRequest> EMPTY_CONTAINER_REQUEST_LIST;

    public RMAppAttemptImpl(ApplicationAttemptId appAttemptId, String clientToken, RMContext rmContext, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationSubmissionContext submissionContext, String proxy) {
        this.proxy = proxy;
        this.applicationAttemptId = appAttemptId;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.clientToken = clientToken;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    @Override
    public ApplicationAttemptId getAppAttemptId() {
        return this.applicationAttemptId;
    }

    @Override
    public ApplicationSubmissionContext getSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            FinalApplicationStatus finalApplicationStatus = this.finalStatus;
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttemptState getAppAttemptState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHost() {
        this.readLock.lock();
        try {
            String string = this.host;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRpcPort() {
        this.readLock.lock();
        try {
            int n = this.rpcPort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.proxiedTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOriginalTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.origTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWebProxyBase() {
        this.readLock.lock();
        try {
            String string = ProxyUriUtils.getPath((ApplicationId)this.applicationAttemptId.getApplicationId());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProxyUriWithoutScheme(String trackingUriWithoutScheme) {
        this.readLock.lock();
        try {
            URI trackingUri = ProxyUriUtils.getUriFromAMUrl((String)trackingUriWithoutScheme);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)this.proxy);
            URI result = ProxyUriUtils.getProxyUri((URI)trackingUri, (URI)proxyUri, (ApplicationId)this.applicationAttemptId.getApplicationId());
            String string = result.toASCIIString().substring(7);
            return string;
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not proxify " + trackingUriWithoutScheme), (Throwable)e);
            String string = trackingUriWithoutScheme;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getClientToken() {
        return this.clientToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiagnostics() {
        this.readLock.lock();
        try {
            String string = this.diagnostics.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiagnostics(String message) {
        this.writeLock.lock();
        try {
            this.diagnostics.append(message);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerStatus> getJustFinishedContainers() {
        this.readLock.lock();
        try {
            List<ContainerStatus> list = this.justFinishedContainers;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerStatus> pullJustFinishedContainers() {
        this.writeLock.lock();
        try {
            ArrayList<ContainerStatus> returnList = new ArrayList<ContainerStatus>(this.justFinishedContainers.size());
            returnList.addAll(this.justFinishedContainers);
            this.justFinishedContainers.clear();
            ArrayList<ContainerStatus> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<NodeId> getRanNodes() {
        return this.ranNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container getMasterContainer() {
        this.readLock.lock();
        try {
            Container container = this.masterContainer;
            return container;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppAttemptEvent event) {
        this.writeLock.lock();
        try {
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            LOG.info((Object)("Processing event for " + appAttemptID + " of type " + event.getType()));
            RMAppAttemptState oldState = this.getAppAttemptState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getAppAttemptState()) {
                LOG.info((Object)(appAttemptID + " State change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getAppAttemptState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        this.readLock.lock();
        try {
            int numUsedContainers = 0;
            int numReservedContainers = 0;
            int reservedResources = 0;
            int currentConsumption = 0;
            SchedulerAppReport schedApp = this.scheduler.getSchedulerAppInfo(this.getAppAttemptId());
            if (schedApp != null) {
                Collection<RMContainer> liveContainers = schedApp.getLiveContainers();
                Collection<RMContainer> reservedContainers = schedApp.getReservedContainers();
                if (liveContainers != null) {
                    numUsedContainers = liveContainers.size();
                    for (RMContainer lc : liveContainers) {
                        currentConsumption += lc.getContainer().getResource().getMemory();
                    }
                }
                if (reservedContainers != null) {
                    numReservedContainers = reservedContainers.size();
                    for (RMContainer rc : reservedContainers) {
                        reservedResources += rc.getContainer().getResource().getMemory();
                    }
                }
            }
            ApplicationResourceUsageReport appResources = (ApplicationResourceUsageReport)recordFactory.newRecordInstance(ApplicationResourceUsageReport.class);
            appResources.setNumUsedContainers(numUsedContainers);
            appResources.setNumReservedContainers(numReservedContainers);
            appResources.setUsedResources(Resources.createResource(currentConsumption));
            appResources.setReservedResources(Resources.createResource(reservedResources));
            appResources.setNeededResources(Resources.createResource(currentConsumption + reservedResources));
            ApplicationResourceUsageReport applicationResourceUsageReport = appResources;
            return applicationResourceUsageReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    static {
        AM_CONTAINER_PRIORITY.setPriority(0);
        stateMachineFactory = new StateMachineFactory((Enum)RMAppAttemptState.NEW).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptEventType.START, (SingleArcTransition)new AttemptStartedTransition()).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptEventType.APP_ACCEPTED, (SingleArcTransition)new ScheduleTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new AMContainerAllocatedTransition()).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.LAUNCHED, (SingleArcTransition)new AMLaunchedTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.LAUNCH_FAILED, (SingleArcTransition)new LaunchFailedTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new KillAllocatedAMTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new AMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new AMContainerCrashedTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptEventType.UNREGISTERED, (SingleArcTransition)new AMUnregisteredTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.STATUS_UPDATE, (SingleArcTransition)new StatusUpdateTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.RUNNING, RMAppAttemptState.FAILED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, EnumSet.of(RMAppAttemptEventType.EXPIRE, new RMAppAttemptEventType[]{RMAppAttemptEventType.KILL, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED})).addTransition((Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptState.FINISHED, EnumSet.of(RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptState.KILLED, EnumSet.of(RMAppAttemptEventType.APP_ACCEPTED, new RMAppAttemptEventType[]{RMAppAttemptEventType.APP_REJECTED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.STATUS_UPDATE})).installTopology();
        EMPTY_CONTAINER_RELEASE_LIST = new ArrayList<ContainerId>();
        EMPTY_CONTAINER_REQUEST_LIST = new ArrayList<ResourceRequest>();
    }

    private static final class ContainerFinishedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private ContainerFinishedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                appAttempt.diagnostics.append("AM Container for " + appAttempt.getAppAttemptId() + " exited with " + " exitCode: " + containerStatus.getExitStatus() + " due to: " + containerStatus.getDiagnostics() + "." + "Failing this attempt.");
                appAttempt.origTrackingUrl = "";
                appAttempt.proxiedTrackingUrl = "";
                new FinalTransition(RMAppAttemptState.FAILED).transition(appAttempt, containerFinishedEvent);
                return RMAppAttemptState.FAILED;
            }
            appAttempt.justFinishedContainers.add(containerStatus);
            return RMAppAttemptState.RUNNING;
        }
    }

    private static final class ContainerAcquiredTransition
    extends BaseTransition {
        private ContainerAcquiredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerAcquiredEvent acquiredEvent = (RMAppAttemptContainerAcquiredEvent)event;
            appAttempt.ranNodes.add(acquiredEvent.getContainer().getNodeId());
        }
    }

    private static final class AMUnregisteredTransition
    extends FinalTransition {
        public AMUnregisteredTransition() {
            super(RMAppAttemptState.FINISHED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
            appAttempt.diagnostics.append(unregisterEvent.getDiagnostics());
            appAttempt.origTrackingUrl = unregisterEvent.getTrackingUrl();
            appAttempt.proxiedTrackingUrl = appAttempt.generateProxyUriWithoutScheme(appAttempt.origTrackingUrl);
            appAttempt.finalStatus = unregisterEvent.getFinalApplicationStatus();
            super.transition(appAttempt, event);
        }
    }

    private static final class StatusUpdateTransition
    extends BaseTransition {
        private StatusUpdateTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptStatusupdateEvent statusUpdateEvent = (RMAppAttemptStatusupdateEvent)event;
            appAttempt.progress = statusUpdateEvent.getProgress();
            appAttempt.rmContext.getAMLivelinessMonitor().receivedPing(statusUpdateEvent.getApplicationAttemptId());
        }
    }

    private static class FinalTransition
    extends BaseFinalTransition {
        public FinalTransition(RMAppAttemptState finalAttemptState) {
            super(finalAttemptState);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.progress = 1.0f;
            super.transition(appAttempt, event);
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
        }
    }

    private static final class AMContainerCrashedTransition
    extends BaseFinalTransition {
        public AMContainerCrashedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            ContainerStatus status = finishEvent.getContainerStatus();
            appAttempt.diagnostics.append("AM Container for " + appAttempt.getAppAttemptId() + " exited with " + " exitCode: " + status.getExitStatus() + " due to: " + status.getDiagnostics() + "." + "Failing this attempt.");
            super.transition(appAttempt, finishEvent);
        }
    }

    private static final class AMRegisteredTransition
    extends BaseTransition {
        private AMRegisteredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptRegistrationEvent registrationEvent = (RMAppAttemptRegistrationEvent)event;
            appAttempt.host = registrationEvent.getHost();
            appAttempt.rpcPort = registrationEvent.getRpcport();
            appAttempt.origTrackingUrl = registrationEvent.getTrackingurl();
            appAttempt.proxiedTrackingUrl = appAttempt.generateProxyUriWithoutScheme(appAttempt.origTrackingUrl);
            appAttempt.eventHandler.handle((Event)new RMAppEvent(appAttempt.getAppAttemptId().getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED));
        }
    }

    private static final class KillAllocatedAMTransition
    extends BaseFinalTransition {
        public KillAllocatedAMTransition() {
            super(RMAppAttemptState.KILLED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            super.transition(appAttempt, event);
            appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
        }
    }

    private static final class LaunchFailedTransition
    extends BaseFinalTransition {
        public LaunchFailedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptLaunchFailedEvent launchFaileEvent = (RMAppAttemptLaunchFailedEvent)event;
            appAttempt.diagnostics.append(launchFaileEvent.getMessage());
            super.transition(appAttempt, event);
        }
    }

    private static final class AMLaunchedTransition
    extends BaseTransition {
        private AMLaunchedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.rmContext.getAMLivelinessMonitor().register(appAttempt.applicationAttemptId);
        }
    }

    private static class BaseFinalTransition
    extends BaseTransition {
        private final RMAppAttemptState finalAttemptState;

        public BaseFinalTransition(RMAppAttemptState finalAttemptState) {
            this.finalAttemptState = finalAttemptState;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.masterService.unregisterAttempt(appAttempt.applicationAttemptId);
            ApplicationId applicationId = appAttempt.getAppAttemptId().getApplicationId();
            RMAppEvent appEvent = null;
            switch (this.finalAttemptState) {
                case FINISHED: {
                    appEvent = new RMAppEvent(applicationId, RMAppEventType.ATTEMPT_FINISHED);
                    break;
                }
                case KILLED: {
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_KILLED, "Application killed by user.");
                    break;
                }
                case FAILED: {
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_FAILED, appAttempt.getDiagnostics());
                    break;
                }
                default: {
                    LOG.error((Object)"Cannot get this state!! Error!!");
                }
            }
            appAttempt.eventHandler.handle((Event)appEvent);
            appAttempt.eventHandler.handle((Event)new AppRemovedSchedulerEvent(appAttempt.getAppAttemptId(), this.finalAttemptState));
        }
    }

    private static final class AMContainerAllocatedTransition
    extends BaseTransition {
        private AMContainerAllocatedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, EMPTY_CONTAINER_REQUEST_LIST, EMPTY_CONTAINER_RELEASE_LIST);
            appAttempt.masterContainer = amContainerAllocation.getContainers().get(0);
            appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.LAUNCH, appAttempt));
        }
    }

    private static final class ScheduleTransition
    extends BaseTransition {
        private ScheduleTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.eventHandler.handle((Event)new RMAppEvent(event.getApplicationAttemptId().getApplicationId(), RMAppEventType.APP_ACCEPTED));
            ResourceRequest request = BuilderUtils.newResourceRequest((Priority)AM_CONTAINER_PRIORITY, (String)"*", (Resource)appAttempt.submissionContext.getAMContainerSpec().getResource(), (int)1);
            Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, Collections.singletonList(request), EMPTY_CONTAINER_RELEASE_LIST);
            if (amContainerAllocation != null && amContainerAllocation.getContainers() != null) assert (amContainerAllocation.getContainers().size() == 0);
        }
    }

    private static final class AppRejectedTransition
    extends BaseTransition {
        private AppRejectedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptRejectedEvent rejectedEvent = (RMAppAttemptRejectedEvent)event;
            String message = rejectedEvent.getMessage();
            appAttempt.setDiagnostics(message);
            appAttempt.eventHandler.handle((Event)new RMAppRejectedEvent(rejectedEvent.getApplicationAttemptId().getApplicationId(), message));
        }
    }

    private static final class AttemptStartedTransition
    extends BaseTransition {
        private AttemptStartedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.masterService.registerAppAttempt(appAttempt.applicationAttemptId);
            appAttempt.eventHandler.handle((Event)new AppAddedSchedulerEvent(appAttempt.applicationAttemptId, appAttempt.submissionContext.getQueue(), appAttempt.submissionContext.getUser()));
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent> {
        private BaseTransition() {
        }

        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
        }
    }
}

