/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmnode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.records.HeartbeatResponse;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BuilderUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMNodeImpl
implements RMNode,
EventHandler<RMNodeEvent> {
    private static final Log LOG = LogFactory.getLog(RMNodeImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final NodeId nodeId;
    private final RMContext context;
    private final String hostName;
    private final int commandPort;
    private final int httpPort;
    private final String nodeAddress;
    private final String httpAddress;
    private final Resource totalCapability;
    private final Node node;
    private final NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)recordFactory.newRecordInstance(NodeHealthStatus.class);
    private final Map<ContainerId, ContainerStatus> justLaunchedContainers = new HashMap<ContainerId, ContainerStatus>();
    private final Set<ContainerId> containersToClean = new TreeSet<ContainerId>((Comparator<ContainerId>)new BuilderUtils.ContainerIdComparator());
    private final List<ApplicationId> finishedApplications = new ArrayList<ApplicationId>();
    private HeartbeatResponse latestHeartBeatResponse = (HeartbeatResponse)recordFactory.newRecordInstance(HeartbeatResponse.class);
    private static final StateMachineFactory<RMNodeImpl, RMNodeState, RMNodeEventType, RMNodeEvent> stateMachineFactory = new StateMachineFactory((Enum)RMNodeState.NEW).addTransition((Enum)RMNodeState.NEW, (Enum)RMNodeState.RUNNING, (Enum)RMNodeEventType.STARTED, (SingleArcTransition)new AddNodeTransition()).addTransition((Enum)RMNodeState.RUNNING, EnumSet.of(RMNodeState.RUNNING, RMNodeState.UNHEALTHY), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenHealthyTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.DECOMMISSIONED, (Enum)RMNodeEventType.DECOMMISSION, (SingleArcTransition)new RemoveNodeTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.LOST, (Enum)RMNodeEventType.EXPIRE, (SingleArcTransition)new RemoveNodeTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.LOST, (Enum)RMNodeEventType.REBOOTING, (SingleArcTransition)new RemoveNodeTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_APP, (SingleArcTransition)new CleanUpAppTransition()).addTransition((Enum)RMNodeState.RUNNING, (Enum)RMNodeState.RUNNING, (Enum)RMNodeEventType.CLEANUP_CONTAINER, (SingleArcTransition)new CleanUpContainerTransition()).addTransition((Enum)RMNodeState.UNHEALTHY, EnumSet.of(RMNodeState.UNHEALTHY, RMNodeState.RUNNING), (Enum)RMNodeEventType.STATUS_UPDATE, (MultipleArcTransition)new StatusUpdateWhenUnHealthyTransition()).installTopology();
    private final StateMachine<RMNodeState, RMNodeEventType, RMNodeEvent> stateMachine;

    public RMNodeImpl(NodeId nodeId, RMContext context, String hostName, int cmPort, int httpPort, Node node, Resource capability) {
        this.nodeId = nodeId;
        this.context = context;
        this.hostName = hostName;
        this.commandPort = cmPort;
        this.httpPort = httpPort;
        this.totalCapability = capability;
        this.nodeAddress = hostName + ":" + cmPort;
        this.httpAddress = hostName + ":" + httpPort;
        this.node = node;
        this.nodeHealthStatus.setIsNodeHealthy(true);
        this.nodeHealthStatus.setHealthReport("Healthy");
        this.nodeHealthStatus.setLastHealthReportTime(System.currentTimeMillis());
        this.latestHeartBeatResponse.setResponseId(0);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    public String toString() {
        return this.nodeId.toString();
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public int getCommandPort() {
        return this.commandPort;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @Override
    public NodeId getNodeID() {
        return this.nodeId;
    }

    @Override
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Override
    public String getHttpAddress() {
        return this.httpAddress;
    }

    @Override
    public Resource getTotalCapability() {
        return this.totalCapability;
    }

    @Override
    public String getRackName() {
        return this.node.getNetworkLocation();
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeHealthStatus getNodeHealthStatus() {
        this.readLock.lock();
        try {
            NodeHealthStatus nodeHealthStatus = this.nodeHealthStatus;
            return nodeHealthStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNodeHealthStatus(NodeHealthStatus status) {
        this.writeLock.lock();
        try {
            this.nodeHealthStatus.setHealthReport(status.getHealthReport());
            this.nodeHealthStatus.setIsNodeHealthy(status.getIsNodeHealthy());
            this.nodeHealthStatus.setLastHealthReportTime(status.getLastHealthReportTime());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMNodeState getState() {
        this.readLock.lock();
        try {
            RMNodeState rMNodeState = (RMNodeState)this.stateMachine.getCurrentState();
            return rMNodeState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationId> pullAppsToCleanup() {
        this.writeLock.lock();
        try {
            ArrayList<ApplicationId> lastfinishedApplications = new ArrayList<ApplicationId>();
            lastfinishedApplications.addAll(this.finishedApplications);
            this.finishedApplications.clear();
            ArrayList<ApplicationId> arrayList = lastfinishedApplications;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerId> pullContainersToCleanUp() {
        this.writeLock.lock();
        try {
            ArrayList<ContainerId> containersToCleanUp = new ArrayList<ContainerId>();
            containersToCleanUp.addAll(this.containersToClean);
            this.containersToClean.clear();
            ArrayList<ContainerId> arrayList = containersToCleanUp;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HeartbeatResponse getLastHeartBeatResponse() {
        this.writeLock.lock();
        try {
            HeartbeatResponse heartbeatResponse = this.latestHeartBeatResponse;
            return heartbeatResponse;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMNodeEvent event) {
        LOG.info((Object)("Processing " + event.getNodeId() + " of type " + event.getType()));
        try {
            this.writeLock.lock();
            RMNodeState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
                LOG.error((Object)("Invalid event " + event.getType() + " on Node  " + this.nodeId));
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(this.nodeId + " Node Transitioned from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public static class StatusUpdateWhenUnHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, RMNodeState> {
        public RMNodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            rmNode.latestHeartBeatResponse = statusEvent.getLatestResponse();
            NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
            rmNode.setNodeHealthStatus(remoteNodeHealthStatus);
            if (remoteNodeHealthStatus.getIsNodeHealthy()) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
                ClusterMetrics.getMetrics().decrNumUnhealthyNMs();
                return RMNodeState.RUNNING;
            }
            return RMNodeState.UNHEALTHY;
        }
    }

    public static class StatusUpdateWhenHealthyTransition
    implements MultipleArcTransition<RMNodeImpl, RMNodeEvent, RMNodeState> {
        public RMNodeState transition(RMNodeImpl rmNode, RMNodeEvent event) {
            RMNodeStatusEvent statusEvent = (RMNodeStatusEvent)event;
            rmNode.latestHeartBeatResponse = statusEvent.getLatestResponse();
            NodeHealthStatus remoteNodeHealthStatus = statusEvent.getNodeHealthStatus();
            rmNode.setNodeHealthStatus(remoteNodeHealthStatus);
            if (!remoteNodeHealthStatus.getIsNodeHealthy()) {
                rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
                ClusterMetrics.getMetrics().incrNumUnhealthyNMs();
                return RMNodeState.UNHEALTHY;
            }
            ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
            ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
            for (ContainerStatus remoteContainer : statusEvent.getContainers()) {
                ContainerId containerId = remoteContainer.getContainerId();
                if (remoteContainer.getState() == ContainerState.RUNNING) {
                    if (rmNode.justLaunchedContainers.containsKey(containerId)) continue;
                    rmNode.justLaunchedContainers.put(containerId, remoteContainer);
                    newlyLaunchedContainers.add(remoteContainer);
                    continue;
                }
                rmNode.justLaunchedContainers.remove(containerId);
                completedContainers.add(remoteContainer);
            }
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeUpdateSchedulerEvent(rmNode, newlyLaunchedContainers, completedContainers));
            return RMNodeState.RUNNING;
        }
    }

    public static class RemoveNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeRemovedSchedulerEvent(rmNode));
            rmNode.context.getRMNodes().remove(rmNode.nodeId);
            LOG.info((Object)("Removed Node " + rmNode.nodeId));
            ClusterMetrics.getMetrics().removeNode((RMNodeEventType)event.getType());
        }
    }

    public static class CleanUpContainerTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.containersToClean.add(((RMNodeCleanContainerEvent)event).getContainerId());
        }
    }

    public static class CleanUpAppTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.finishedApplications.add(((RMNodeCleanAppEvent)event).getAppId());
        }
    }

    public static class AddNodeTransition
    implements SingleArcTransition<RMNodeImpl, RMNodeEvent> {
        public void transition(RMNodeImpl rmNode, RMNodeEvent event) {
            rmNode.context.getDispatcher().getEventHandler().handle((Event)new NodeAddedSchedulerEvent(rmNode));
            ClusterMetrics.getMetrics().addNode();
        }
    }
}

