/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(context="yarn")
@InterfaceAudience.Private
public class QueueMetrics {
    @Metric(value={"# of apps submitted"})
    MutableCounterInt appsSubmitted;
    @Metric(value={"# of running apps"})
    MutableGaugeInt appsRunning;
    @Metric(value={"# of pending apps"})
    MutableGaugeInt appsPending;
    @Metric(value={"# of apps completed"})
    MutableCounterInt appsCompleted;
    @Metric(value={"# of apps killed"})
    MutableCounterInt appsKilled;
    @Metric(value={"# of apps failed"})
    MutableCounterInt appsFailed;
    @Metric(value={"Allocated memory in GiB"})
    MutableGaugeInt allocatedGB;
    @Metric(value={"# of allocated containers"})
    MutableGaugeInt allocatedContainers;
    @Metric(value={"Aggregate # of allocated containers"})
    MutableCounterLong aggregateContainersAllocated;
    @Metric(value={"Aggregate # of released containers"})
    MutableCounterLong aggregateContainersReleased;
    @Metric(value={"Available memory in GiB"})
    MutableGaugeInt availableGB;
    @Metric(value={"Pending memory allocation in GiB"})
    MutableGaugeInt pendingGB;
    @Metric(value={"# of pending containers"})
    MutableGaugeInt pendingContainers;
    @Metric(value={"# of reserved memory in GiB"})
    MutableGaugeInt reservedGB;
    @Metric(value={"# of reserved containers"})
    MutableGaugeInt reservedContainers;
    static final Logger LOG = LoggerFactory.getLogger(QueueMetrics.class);
    static final int GB = 1024;
    static final MetricsInfo RECORD_INFO = Interns.info((String)"QueueMetrics", (String)"Metrics for the resource scheduler");
    static final MetricsInfo QUEUE_INFO = Interns.info((String)"Queue", (String)"Metrics by queue");
    static final MetricsInfo USER_INFO = Interns.info((String)"User", (String)"Metrics by user");
    static final Splitter Q_SPLITTER = Splitter.on((char)'.').omitEmptyStrings().trimResults();
    final MetricsRegistry registry = new MetricsRegistry(RECORD_INFO);
    final String queueName;
    final QueueMetrics parent;
    final MetricsSystem metricsSystem;
    private final Map<String, QueueMetrics> users;

    QueueMetrics(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics) {
        this.queueName = queueName;
        this.parent = parent != null ? parent.getMetrics() : null;
        this.users = enableUserMetrics ? new HashMap() : null;
        this.metricsSystem = ms;
    }

    QueueMetrics tag(MetricsInfo info, String value) {
        this.registry.tag(info, value);
        return this;
    }

    static StringBuilder sourceName(String queueName) {
        StringBuilder sb = new StringBuilder(RECORD_INFO.name());
        int i = 0;
        for (String node : Q_SPLITTER.split((CharSequence)queueName)) {
            sb.append(",q").append(i++).append('=').append(node);
        }
        return sb;
    }

    public static synchronized QueueMetrics forQueue(String queueName, Queue parent, boolean enableUserMetrics) {
        return QueueMetrics.forQueue(DefaultMetricsSystem.instance(), queueName, parent, enableUserMetrics);
    }

    public static QueueMetrics forQueue(MetricsSystem ms, String queueName, Queue parent, boolean enableUserMetrics) {
        QueueMetrics metrics = new QueueMetrics(ms, queueName, parent, enableUserMetrics).tag(QUEUE_INFO, queueName);
        return ms == null ? metrics : (QueueMetrics)ms.register(QueueMetrics.sourceName(queueName).toString(), "Metrics for queue: " + queueName, (Object)metrics);
    }

    public synchronized QueueMetrics getUserMetrics(String userName) {
        if (this.users == null) {
            return null;
        }
        QueueMetrics metrics = this.users.get(userName);
        if (metrics == null) {
            metrics = new QueueMetrics(this.metricsSystem, this.queueName, null, false);
            this.users.put(userName, metrics);
            this.metricsSystem.register(QueueMetrics.sourceName(this.queueName).append(",user=").append(userName).toString(), "Metrics for user '" + userName + "' in queue '" + this.queueName + "'", (Object)metrics.tag(QUEUE_INFO, this.queueName).tag(USER_INFO, userName));
        }
        return metrics;
    }

    public void submitApp(String user) {
        this.appsSubmitted.incr();
        this.appsPending.incr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.submitApp(user);
        }
        if (this.parent != null) {
            this.parent.submitApp(user);
        }
    }

    public void incrAppsRunning(String user) {
        this.appsRunning.incr();
        this.appsPending.decr();
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.incrAppsRunning(user);
        }
        if (this.parent != null) {
            this.parent.incrAppsRunning(user);
        }
    }

    public void finishApp(AppSchedulingInfo app, RMAppAttemptState rmAppAttemptFinalState) {
        switch (rmAppAttemptFinalState) {
            case KILLED: {
                this.appsKilled.incr();
                break;
            }
            case FAILED: {
                this.appsFailed.incr();
                break;
            }
            default: {
                this.appsCompleted.incr();
            }
        }
        if (app.isPending()) {
            this.appsPending.decr();
        } else {
            this.appsRunning.decr();
        }
        QueueMetrics userMetrics = this.getUserMetrics(app.getUser());
        if (userMetrics != null) {
            userMetrics.finishApp(app, rmAppAttemptFinalState);
        }
        if (this.parent != null) {
            this.parent.finishApp(app, rmAppAttemptFinalState);
        }
    }

    public void setAvailableResourcesToQueue(Resource limit) {
        this.availableGB.set(limit.getMemory() / 1024);
    }

    public void setAvailableResourcesToUser(String user, Resource limit) {
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.setAvailableResourcesToQueue(limit);
        }
    }

    public void incrPendingResources(String user, int containers, Resource res) {
        this._incrPendingResources(containers, res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.incrPendingResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.incrPendingResources(user, containers, res);
        }
    }

    private void _incrPendingResources(int containers, Resource res) {
        this.pendingContainers.incr(containers);
        this.pendingGB.incr(res.getMemory() / 1024);
    }

    public void decrPendingResources(String user, int containers, Resource res) {
        this._decrPendingResources(containers, res);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.decrPendingResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.decrPendingResources(user, containers, res);
        }
    }

    private void _decrPendingResources(int containers, Resource res) {
        this.pendingContainers.decr(containers);
        this.pendingGB.decr(res.getMemory() / 1024);
    }

    public void allocateResources(String user, int containers, Resource res) {
        this.allocatedContainers.incr(containers);
        this.aggregateContainersAllocated.incr((long)containers);
        this.allocatedGB.incr(res.getMemory() / 1024 * containers);
        this._decrPendingResources(containers, Resources.multiply(res, containers));
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.allocateResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.allocateResources(user, containers, res);
        }
    }

    public void releaseResources(String user, int containers, Resource res) {
        this.allocatedContainers.decr(containers);
        this.aggregateContainersReleased.incr((long)containers);
        this.allocatedGB.decr(res.getMemory() / 1024 * containers);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.releaseResources(user, containers, res);
        }
        if (this.parent != null) {
            this.parent.releaseResources(user, containers, res);
        }
    }

    public void reserveResource(String user, Resource res) {
        this.reservedContainers.incr();
        this.reservedGB.incr(res.getMemory() / 1024);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.reserveResource(user, res);
        }
        if (this.parent != null) {
            this.parent.reserveResource(user, res);
        }
    }

    public void unreserveResource(String user, Resource res) {
        this.reservedContainers.decr();
        this.reservedGB.decr(res.getMemory() / 1024);
        QueueMetrics userMetrics = this.getUserMetrics(user);
        if (userMetrics != null) {
            userMetrics.unreserveResource(user, res);
        }
        if (this.parent != null) {
            this.parent.unreserveResource(user, res);
        }
    }

    public int getAppsSubmitted() {
        return this.appsSubmitted.value();
    }

    public int getAppsRunning() {
        return this.appsRunning.value();
    }

    public int getAppsPending() {
        return this.appsPending.value();
    }

    public int getAppsCompleted() {
        return this.appsCompleted.value();
    }

    public int getAppsKilled() {
        return this.appsKilled.value();
    }

    public int getAppsFailed() {
        return this.appsFailed.value();
    }

    public int getAllocatedGB() {
        return this.allocatedGB.value();
    }

    public int getAllocatedContainers() {
        return this.allocatedContainers.value();
    }

    public int getAvailableGB() {
        return this.availableGB.value();
    }

    public int getPendingGB() {
        return this.pendingGB.value();
    }

    public int getPendingContainers() {
        return this.pendingContainers.value();
    }

    public int getReservedGB() {
        return this.reservedGB.value();
    }

    public int getReservedContainers() {
        return this.reservedContainers.value();
    }
}

