/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.security.ContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.BuilderUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeafQueue
implements CSQueue {
    private static final Log LOG = LogFactory.getLog(LeafQueue.class);
    private final String queueName;
    private CSQueue parent;
    private float capacity;
    private float absoluteCapacity;
    private float maximumCapacity;
    private float absoluteMaxCapacity;
    private int userLimit;
    private float userLimitFactor;
    private int maxApplications;
    private int maxApplicationsPerUser;
    private float maxAMResourcePercent;
    private int maxActiveApplications;
    private int maxActiveApplicationsPerUser;
    private org.apache.hadoop.yarn.api.records.Resource usedResources = Resources.createResource(0);
    private float utilization = 0.0f;
    private float usedCapacity = 0.0f;
    private volatile int numContainers;
    Set<SchedulerApp> activeApplications;
    Map<ApplicationAttemptId, SchedulerApp> applicationsMap = new HashMap<ApplicationAttemptId, SchedulerApp>();
    Set<SchedulerApp> pendingApplications;
    private final org.apache.hadoop.yarn.api.records.Resource minimumAllocation;
    private final org.apache.hadoop.yarn.api.records.Resource maximumAllocation;
    private final float minimumAllocationFactor;
    private ContainerTokenSecretManager containerTokenSecretManager;
    private Map<String, User> users = new HashMap<String, User>();
    private final QueueMetrics metrics;
    private QueueInfo queueInfo;
    private QueueState state;
    private Map<QueueACL, AccessControlList> acls = new HashMap<QueueACL, AccessControlList>();
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private CapacitySchedulerContext scheduler;
    static final int DEFAULT_AM_RESOURCE = 2048;

    public LeafQueue(CapacitySchedulerContext cs, String queueName, CSQueue parent, Comparator<SchedulerApp> applicationComparator, CSQueue old) {
        this.scheduler = cs;
        this.queueName = queueName;
        this.parent = parent;
        this.metrics = old != null ? old.getMetrics() : QueueMetrics.forQueue(this.getQueuePath(), parent, cs.getConfiguration().getEnableUserMetrics());
        this.minimumAllocation = cs.getMinimumResourceCapability();
        this.maximumAllocation = cs.getMaximumResourceCapability();
        this.minimumAllocationFactor = (float)(this.maximumAllocation.getMemory() - this.minimumAllocation.getMemory()) / (float)this.maximumAllocation.getMemory();
        this.containerTokenSecretManager = cs.getContainerTokenSecretManager();
        float capacity = (float)cs.getConfiguration().getCapacity(this.getQueuePath()) / 100.0f;
        float absoluteCapacity = parent.getAbsoluteCapacity() * capacity;
        float maximumCapacity = cs.getConfiguration().getMaximumCapacity(this.getQueuePath());
        float absoluteMaxCapacity = maximumCapacity == -1.0f ? Float.MAX_VALUE : parent.getAbsoluteCapacity() * maximumCapacity / 100.0f;
        int userLimit = cs.getConfiguration().getUserLimit(this.getQueuePath());
        float userLimitFactor = cs.getConfiguration().getUserLimitFactor(this.getQueuePath());
        int maxSystemJobs = cs.getConfiguration().getMaximumSystemApplications();
        int maxApplications = (int)((float)maxSystemJobs * absoluteCapacity);
        int maxApplicationsPerUser = (int)((float)maxApplications * ((float)userLimit / 100.0f) * userLimitFactor);
        this.maxAMResourcePercent = cs.getConfiguration().getMaximumApplicationMasterResourcePercent();
        int maxActiveApplications = this.computeMaxActiveApplications(cs.getClusterResources(), this.maxAMResourcePercent, absoluteCapacity);
        int maxActiveApplicationsPerUser = this.computeMaxActiveApplicationsPerUser(maxActiveApplications, userLimit, userLimitFactor);
        this.queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        this.queueInfo.setQueueName(queueName);
        this.queueInfo.setChildQueues(new ArrayList());
        QueueState state = cs.getConfiguration().getState(this.getQueuePath());
        Map<QueueACL, AccessControlList> acls = cs.getConfiguration().getAcls(this.getQueuePath());
        this.setupQueueConfigs(capacity, absoluteCapacity, maximumCapacity, absoluteMaxCapacity, userLimit, userLimitFactor, maxApplications, maxApplicationsPerUser, maxActiveApplications, maxActiveApplicationsPerUser, state, acls);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("LeafQueue: name=" + queueName + ", fullname=" + this.getQueuePath()));
        }
        this.pendingApplications = new TreeSet<SchedulerApp>(applicationComparator);
        this.activeApplications = new TreeSet<SchedulerApp>(applicationComparator);
    }

    private int computeMaxActiveApplications(org.apache.hadoop.yarn.api.records.Resource clusterResource, float maxAMResourcePercent, float absoluteCapacity) {
        return Math.max((int)((float)clusterResource.getMemory() / 2048.0f * maxAMResourcePercent * absoluteCapacity), 1);
    }

    private int computeMaxActiveApplicationsPerUser(int maxActiveApplications, int userLimit, float userLimitFactor) {
        return (int)((float)maxActiveApplications * ((float)userLimit / 100.0f) * userLimitFactor);
    }

    private synchronized void setupQueueConfigs(float capacity, float absoluteCapacity, float maxCapacity, float absoluteMaxCapacity, int userLimit, float userLimitFactor, int maxApplications, int maxApplicationsPerUser, int maxActiveApplications, int maxActiveApplicationsPerUser, QueueState state, Map<QueueACL, AccessControlList> acls) {
        this.capacity = capacity;
        this.absoluteCapacity = this.parent.getAbsoluteCapacity() * capacity;
        this.maximumCapacity = maxCapacity;
        this.absoluteMaxCapacity = absoluteMaxCapacity;
        this.userLimit = userLimit;
        this.userLimitFactor = userLimitFactor;
        this.maxApplications = maxApplications;
        this.maxApplicationsPerUser = maxApplicationsPerUser;
        this.maxActiveApplications = maxActiveApplications;
        this.maxActiveApplicationsPerUser = maxActiveApplicationsPerUser;
        this.state = state;
        this.acls = acls;
        this.queueInfo.setCapacity(capacity);
        this.queueInfo.setMaximumCapacity(this.maximumCapacity);
        this.queueInfo.setQueueState(state);
        StringBuilder aclsString = new StringBuilder();
        for (Map.Entry<QueueACL, AccessControlList> e : acls.entrySet()) {
            aclsString.append(e.getKey() + ":" + e.getValue().getAclString());
        }
        LOG.info((Object)("Initializing " + this.queueName + "\n" + "capacity = " + capacity + " [= (float) configuredCapacity / 100 ]" + "\n" + "asboluteCapacity = " + absoluteCapacity + " [= parentAbsoluteCapacity * capacity ]" + "\n" + "maxCapacity = " + maxCapacity + " [= configuredMaxCapacity ]" + "\n" + "absoluteMaxCapacity = " + absoluteMaxCapacity + " [= Float.MAX_VALUE if maximumCapacity undefined, " + "(parentAbsoluteCapacity * maximumCapacity) / 100 otherwise ]" + "\n" + "userLimit = " + userLimit + " [= configuredUserLimit ]" + "\n" + "userLimitFactor = " + userLimitFactor + " [= configuredUserLimitFactor ]" + "\n" + "maxApplications = " + maxApplications + " [= (int)(configuredMaximumSystemApplications * absoluteCapacity) ]" + "\n" + "maxApplicationsPerUser = " + maxApplicationsPerUser + " [= (int)(maxApplications * (userLimit / 100.0f) * userLimitFactor) ]" + "\n" + "maxActiveApplications = " + maxActiveApplications + " [= max(" + "(int)((clusterResourceMemory / (float)DEFAULT_AM_RESOURCE) *" + "maxAMResourcePercent * absoluteCapacity)," + "1) ]" + "\n" + "maxActiveApplicationsPerUser = " + maxActiveApplicationsPerUser + " [= (int)(maxActiveApplications * (userLimit / 100.0f) * userLimitFactor) ]" + "\n" + "utilization = " + this.utilization + " [= usedResourcesMemory / queueLimit ]" + "\n" + "usedCapacity = " + this.usedCapacity + " [= usedResourcesMemory / (clusterResourceMemory * capacity) ]" + "\n" + "maxAMResourcePercent = " + this.maxAMResourcePercent + " [= configuredMaximumAMResourcePercent ]" + "\n" + "minimumAllocationFactor = " + this.minimumAllocationFactor + " [= (float)(maximumAllocationMemory - minimumAllocationMemory) / maximumAllocationMemory ]" + "\n" + "numContainers = " + this.numContainers + " [= currentNumContainers ]" + "\n" + "state = " + state + " [= configuredState ]" + "\n" + "acls = " + aclsString + " [= configuredAcls ]" + "\n"));
    }

    @Override
    public synchronized float getCapacity() {
        return this.capacity;
    }

    @Override
    public synchronized float getAbsoluteCapacity() {
        return this.absoluteCapacity;
    }

    @Override
    public synchronized float getMaximumCapacity() {
        return this.maximumCapacity;
    }

    @Override
    public synchronized float getAbsoluteMaximumCapacity() {
        return this.absoluteMaxCapacity;
    }

    @Override
    public CSQueue getParent() {
        return this.parent;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public String getQueuePath() {
        return this.parent.getQueuePath() + "." + this.getQueueName();
    }

    @InterfaceAudience.Private
    public org.apache.hadoop.yarn.api.records.Resource getMinimumAllocation() {
        return this.minimumAllocation;
    }

    @InterfaceAudience.Private
    public org.apache.hadoop.yarn.api.records.Resource getMaximumAllocation() {
        return this.maximumAllocation;
    }

    @InterfaceAudience.Private
    public float getMinimumAllocationFactor() {
        return this.minimumAllocationFactor;
    }

    public int getMaxApplications() {
        return this.maxApplications;
    }

    public synchronized int getMaxApplicationsPerUser() {
        return this.maxApplicationsPerUser;
    }

    public synchronized int getMaximumActiveApplications() {
        return this.maxActiveApplications;
    }

    public synchronized int getMaximumActiveApplicationsPerUser() {
        return this.maxActiveApplicationsPerUser;
    }

    @Override
    public synchronized float getUsedCapacity() {
        return this.usedCapacity;
    }

    @Override
    public synchronized org.apache.hadoop.yarn.api.records.Resource getUsedResources() {
        return this.usedResources;
    }

    @Override
    public synchronized float getUtilization() {
        return this.utilization;
    }

    @Override
    public List<CSQueue> getChildQueues() {
        return null;
    }

    synchronized void setUtilization(float utilization) {
        this.utilization = utilization;
    }

    synchronized void setUsedCapacity(float usedCapacity) {
        this.usedCapacity = usedCapacity;
    }

    synchronized void setMaxCapacity(float maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
        this.absoluteMaxCapacity = maximumCapacity == -1.0f ? Float.MAX_VALUE : this.parent.getAbsoluteCapacity() * maximumCapacity;
    }

    synchronized void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    synchronized void setUserLimitFactor(int userLimitFactor) {
        this.userLimitFactor = userLimitFactor;
    }

    synchronized void setParentQueue(CSQueue parent) {
        this.parent = parent;
    }

    @Override
    public synchronized int getNumApplications() {
        return this.getNumPendingApplications() + this.getNumActiveApplications();
    }

    public synchronized int getNumPendingApplications() {
        return this.pendingApplications.size();
    }

    public synchronized int getNumActiveApplications() {
        return this.activeApplications.size();
    }

    @InterfaceAudience.Private
    public synchronized int getNumApplications(String user) {
        return this.getUser(user).getTotalApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumPendingApplications(String user) {
        return this.getUser(user).getPendingApplications();
    }

    @InterfaceAudience.Private
    public synchronized int getNumActiveApplications(String user) {
        return this.getUser(user).getActiveApplications();
    }

    public synchronized int getNumContainers() {
        return this.numContainers;
    }

    @Override
    public synchronized QueueState getState() {
        return this.state;
    }

    @InterfaceAudience.Private
    public synchronized int getUserLimit() {
        return this.userLimit;
    }

    @InterfaceAudience.Private
    public synchronized float getUserLimitFactor() {
        return this.userLimitFactor;
    }

    @Override
    public synchronized Map<QueueACL, AccessControlList> getQueueAcls() {
        return new HashMap<QueueACL, AccessControlList>(this.acls);
    }

    @Override
    public synchronized QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        this.queueInfo.setCurrentCapacity(this.usedCapacity);
        return this.queueInfo;
    }

    @Override
    public synchronized List<QueueUserACLInfo> getQueueUserAclInfo(UserGroupInformation user) {
        QueueUserACLInfo userAclInfo = (QueueUserACLInfo)this.recordFactory.newRecordInstance(QueueUserACLInfo.class);
        ArrayList<QueueACL> operations = new ArrayList<QueueACL>();
        for (Map.Entry<QueueACL, AccessControlList> e : this.acls.entrySet()) {
            QueueACL operation = e.getKey();
            AccessControlList acl = e.getValue();
            if (!acl.isUserAllowed(user)) continue;
            operations.add(operation);
        }
        userAclInfo.setQueueName(this.getQueueName());
        userAclInfo.setUserAcls(operations);
        return Collections.singletonList(userAclInfo);
    }

    public String toString() {
        return this.queueName + ":" + this.capacity + ":" + this.absoluteCapacity + ":" + this.getUsedCapacity() + ":" + this.getUtilization() + ":" + this.getNumApplications() + ":" + this.getNumContainers();
    }

    private synchronized User getUser(String userName) {
        User user = this.users.get(userName);
        if (user == null) {
            user = new User();
            this.users.put(userName, user);
        }
        return user;
    }

    @Override
    public synchronized void reinitialize(CSQueue queue, org.apache.hadoop.yarn.api.records.Resource clusterResource) throws IOException {
        if (!(queue instanceof LeafQueue) || !queue.getQueuePath().equals(this.getQueuePath())) {
            throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + queue.getQueuePath());
        }
        LeafQueue leafQueue = (LeafQueue)queue;
        this.setupQueueConfigs(leafQueue.capacity, leafQueue.absoluteCapacity, leafQueue.maximumCapacity, leafQueue.absoluteMaxCapacity, leafQueue.userLimit, leafQueue.userLimitFactor, leafQueue.maxApplications, leafQueue.getMaxApplicationsPerUser(), leafQueue.getMaximumActiveApplications(), leafQueue.getMaximumActiveApplicationsPerUser(), leafQueue.state, leafQueue.acls);
        this.updateResource(clusterResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.acls.get(acl).isUserAllowed(user)) {
                return true;
            }
        }
        return this.parent.hasAccess(acl, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitApplication(SchedulerApp application, String userName, String queue) throws AccessControlException {
        UserGroupInformation userUgi;
        try {
            userUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            throw new AccessControlException((Throwable)ioe);
        }
        if (!this.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi)) {
            throw new AccessControlException("User " + userName + " cannot submit" + " applications to queue " + this.getQueuePath());
        }
        User user = null;
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            if (this.getState() != QueueState.RUNNING) {
                String msg = "Queue " + this.getQueuePath() + " is STOPPED. Cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            if (this.getNumApplications() >= this.getMaxApplications()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + this.getNumApplications() + " applications," + " cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            user = this.getUser(userName);
            if (user.getTotalApplications() >= this.getMaxApplicationsPerUser()) {
                String msg = "Queue " + this.getQueuePath() + " already has " + user.getTotalApplications() + " applications from user " + userName + " cannot accept submission of application: " + application.getApplicationId();
                LOG.info((Object)msg);
                throw new AccessControlException(msg);
            }
            this.addApplication(application, user);
        }
        this.metrics.submitApp(userName);
        try {
            this.parent.submitApplication(application, userName, queue);
        }
        catch (AccessControlException ace) {
            LOG.info((Object)("Failed to submit application to parent-queue: " + this.parent.getQueuePath()), (Throwable)ace);
            this.removeApplication(application, user);
            throw ace;
        }
    }

    private synchronized void activateApplications() {
        Iterator<SchedulerApp> i = this.pendingApplications.iterator();
        while (i.hasNext()) {
            SchedulerApp application = i.next();
            if (this.getNumActiveApplications() >= this.getMaximumActiveApplications()) break;
            User user = this.getUser(application.getUser());
            if (user.getActiveApplications() >= this.getMaximumActiveApplicationsPerUser()) continue;
            user.activateApplication();
            this.activeApplications.add(application);
            i.remove();
            LOG.info((Object)("Application " + application.getApplicationId().getId() + " from user: " + application.getUser() + " activated in queue: " + this.getQueueName()));
        }
    }

    private synchronized void addApplication(SchedulerApp application, User user) {
        user.submitApplication();
        this.pendingApplications.add(application);
        this.applicationsMap.put(application.getApplicationAttemptId(), application);
        this.activateApplications();
        LOG.info((Object)("Application added - appId: " + application.getApplicationId() + " user: " + user + "," + " leaf-queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishApplication(SchedulerApp application, String queue) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.removeApplication(application, this.getUser(application.getUser()));
        }
        this.parent.finishApplication(application, queue);
    }

    public synchronized void removeApplication(SchedulerApp application, User user) {
        this.activeApplications.remove(application);
        this.applicationsMap.remove(application.getApplicationAttemptId());
        user.finishApplication();
        if (user.getTotalApplications() == 0) {
            this.users.remove(application.getUser());
        }
        this.activateApplications();
        LOG.info((Object)("Application removed - appId: " + application.getApplicationId() + " user: " + application.getUser() + " queue: " + this.getQueueName() + " #user-pending-applications: " + user.getPendingApplications() + " #user-active-applications: " + user.getActiveApplications() + " #queue-pending-applications: " + this.getNumPendingApplications() + " #queue-active-applications: " + this.getNumActiveApplications()));
    }

    private synchronized SchedulerApp getApplication(ApplicationAttemptId applicationAttemptId) {
        return this.applicationsMap.get(applicationAttemptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized org.apache.hadoop.yarn.api.records.Resource assignContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node) {
        RMContainer reservedContainer;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getHostName() + " #applications=" + this.activeApplications.size()));
        }
        if ((reservedContainer = node.getReservedContainer()) != null) {
            SchedulerApp application = this.getApplication(reservedContainer.getApplicationAttemptId());
            return this.assignReservedContainer(application, node, reservedContainer, clusterResource);
        }
        for (SchedulerApp application : this.activeApplications) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("pre-assignContainers for application " + application.getApplicationId()));
            }
            application.showRequests();
            SchedulerApp schedulerApp = application;
            synchronized (schedulerApp) {
                this.computeAndSetUserResourceLimit(application, clusterResource);
                for (Priority priority : application.getPriorities()) {
                    org.apache.hadoop.yarn.api.records.Resource required;
                    if (!this.needContainers(application, priority, required = application.getResourceRequest(priority, "*").getCapability())) continue;
                    if (!this.assignToQueue(clusterResource, required)) {
                        return Resources.none();
                    }
                    org.apache.hadoop.yarn.api.records.Resource userLimit = this.computeUserLimit(application, clusterResource, required);
                    if (!this.assignToUser(application.getUser(), userLimit)) break;
                    application.addSchedulingOpportunity(priority);
                    org.apache.hadoop.yarn.api.records.Resource assigned = this.assignContainersOnNode(clusterResource, node, application, priority, null);
                    if (!Resources.greaterThan(assigned, Resources.none())) break;
                    org.apache.hadoop.yarn.api.records.Resource assignedResource = application.getResourceRequest(priority, "*").getCapability();
                    this.allocateResource(clusterResource, application, assignedResource);
                    application.resetSchedulingOpportunities(priority);
                    return assignedResource;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("post-assignContainers for application " + application.getApplicationId()));
            }
            application.showRequests();
        }
        return Resources.none();
    }

    private synchronized org.apache.hadoop.yarn.api.records.Resource assignReservedContainer(SchedulerApp application, SchedulerNode node, RMContainer rmContainer, org.apache.hadoop.yarn.api.records.Resource clusterResource) {
        Priority priority = rmContainer.getReservedPriority();
        if (application.getTotalRequiredResources(priority) == 0) {
            Container container = rmContainer.getContainer();
            this.completedContainer(clusterResource, application, node, rmContainer, SchedulerUtils.createAbnormalContainerStatus(container.getId(), "Container reservation no longer required."), RMContainerEventType.RELEASED);
            return container.getResource();
        }
        this.assignContainersOnNode(clusterResource, node, application, priority, rmContainer);
        return Resource.NONE;
    }

    private synchronized boolean assignToQueue(org.apache.hadoop.yarn.api.records.Resource clusterResource, org.apache.hadoop.yarn.api.records.Resource required) {
        float potentialNewCapacity = (float)(this.usedResources.getMemory() + required.getMemory()) / (float)clusterResource.getMemory();
        if (potentialNewCapacity > this.absoluteMaxCapacity) {
            LOG.info((Object)(this.getQueueName() + " usedResources: " + this.usedResources.getMemory() + " currentCapacity " + (float)this.usedResources.getMemory() / (float)clusterResource.getMemory() + " required " + required.getMemory() + " potentialNewCapacity: " + potentialNewCapacity + " ( " + " > max-capacity (" + this.absoluteMaxCapacity + ")"));
            return false;
        }
        return true;
    }

    private void computeAndSetUserResourceLimit(SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource clusterResource) {
        org.apache.hadoop.yarn.api.records.Resource userLimit = this.computeUserLimit(application, clusterResource, Resources.none());
        application.setAvailableResourceLimit(userLimit);
        this.metrics.setAvailableResourcesToUser(application.getUser(), application.getHeadroom());
    }

    private int roundUp(int memory) {
        return LeafQueue.divideAndCeil(memory, this.minimumAllocation.getMemory()) * this.minimumAllocation.getMemory();
    }

    private org.apache.hadoop.yarn.api.records.Resource computeUserLimit(SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource clusterResource, org.apache.hadoop.yarn.api.records.Resource required) {
        int queueCapacity = Math.max(this.roundUp((int)(this.absoluteCapacity * (float)clusterResource.getMemory())), required.getMemory());
        int consumed = this.usedResources.getMemory();
        int currentCapacity = consumed < queueCapacity ? queueCapacity : consumed + required.getMemory();
        String userName = application.getUser();
        int activeUsers = this.users.size();
        User user = this.getUser(userName);
        int limit = this.roundUp(Math.min(Math.max(LeafQueue.divideAndCeil(currentCapacity, activeUsers), LeafQueue.divideAndCeil(this.userLimit * currentCapacity, 100)), (int)((float)queueCapacity * this.userLimitFactor)));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User limit computation for " + userName + " in queue " + this.getQueueName() + " userLimit=" + this.userLimit + " userLimitFactor=" + this.userLimitFactor + " required: " + required + " consumed: " + user.getConsumedResources() + " limit: " + limit + " queueCapacity: " + queueCapacity + " qconsumed: " + consumed + " currentCapacity: " + currentCapacity + " activeUsers: " + activeUsers + " clusterCapacity: " + clusterResource.getMemory()));
        }
        return Resources.createResource(limit);
    }

    private synchronized boolean assignToUser(String userName, org.apache.hadoop.yarn.api.records.Resource limit) {
        User user = this.getUser(userName);
        if (user.getConsumedResources().getMemory() > limit.getMemory()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User " + userName + " in queue " + this.getQueueName() + " will exceed limit - " + " consumed: " + user.getConsumedResources() + " limit: " + limit));
            }
            return false;
        }
        return true;
    }

    private static int divideAndCeil(int a, int b) {
        if (b == 0) {
            LOG.info((Object)("divideAndCeil called with a=" + a + " b=" + b));
            return 0;
        }
        return (a + (b - 1)) / b;
    }

    boolean needContainers(SchedulerApp application, Priority priority, org.apache.hadoop.yarn.api.records.Resource required) {
        int requiredContainers = application.getTotalRequiredResources(priority);
        int reservedContainers = application.getNumReservedContainers(priority);
        int starvation = 0;
        if (reservedContainers > 0) {
            float nodeFactor = (float)required.getMemory() / (float)this.getMaximumAllocation().getMemory();
            starvation = (int)((float)application.getReReservations(priority) / (float)reservedContainers * (1.0f - Math.min(nodeFactor, this.getMinimumAllocationFactor())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("needsContainers: app.#re-reserve=" + application.getReReservations(priority) + " reserved=" + reservedContainers + " nodeFactor=" + nodeFactor + " minAllocFactor=" + this.minimumAllocationFactor + " starvation=" + starvation));
            }
        }
        return starvation + requiredContainers - reservedContainers > 0;
    }

    private org.apache.hadoop.yarn.api.records.Resource assignContainersOnNode(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        org.apache.hadoop.yarn.api.records.Resource assigned = Resources.none();
        assigned = this.assignNodeLocalContainers(clusterResource, node, application, priority, reservedContainer);
        if (Resources.greaterThan(assigned, Resources.none())) {
            return assigned;
        }
        assigned = this.assignRackLocalContainers(clusterResource, node, application, priority, reservedContainer);
        if (Resources.greaterThan(assigned, Resources.none())) {
            return assigned;
        }
        return this.assignOffSwitchContainers(clusterResource, node, application, priority, reservedContainer);
    }

    private org.apache.hadoop.yarn.api.records.Resource assignNodeLocalContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        ResourceRequest request = application.getResourceRequest(priority, node.getHostName());
        if (request != null && this.canAssign(application, priority, node, NodeType.NODE_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, request, NodeType.NODE_LOCAL, reservedContainer);
        }
        return Resources.none();
    }

    private org.apache.hadoop.yarn.api.records.Resource assignRackLocalContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        ResourceRequest request = application.getResourceRequest(priority, node.getRackName());
        if (request != null && this.canAssign(application, priority, node, NodeType.RACK_LOCAL, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, request, NodeType.RACK_LOCAL, reservedContainer);
        }
        return Resources.none();
    }

    private org.apache.hadoop.yarn.api.records.Resource assignOffSwitchContainers(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, RMContainer reservedContainer) {
        ResourceRequest request = application.getResourceRequest(priority, "*");
        if (request != null && this.canAssign(application, priority, node, NodeType.OFF_SWITCH, reservedContainer)) {
            return this.assignContainer(clusterResource, node, application, priority, request, NodeType.OFF_SWITCH, reservedContainer);
        }
        return Resources.none();
    }

    boolean canAssign(SchedulerApp application, Priority priority, SchedulerNode node, NodeType type, RMContainer reservedContainer) {
        ResourceRequest nodeLocalRequest;
        if (reservedContainer != null) {
            return true;
        }
        if (type == NodeType.OFF_SWITCH) {
            float localityWaitFactor;
            ResourceRequest offSwitchRequest = application.getResourceRequest(priority, "*");
            long missedOpportunities = application.getSchedulingOpportunities(priority);
            long requiredContainers = offSwitchRequest.getNumContainers();
            return (float)requiredContainers * (localityWaitFactor = application.getLocalityWaitFactor(priority, this.scheduler.getNumClusterNodes())) < (float)missedOpportunities;
        }
        ResourceRequest rackLocalRequest = application.getResourceRequest(priority, node.getRackName());
        if (rackLocalRequest == null || rackLocalRequest.getNumContainers() <= 0) {
            return false;
        }
        if (type == NodeType.RACK_LOCAL) {
            return true;
        }
        if (type == NodeType.NODE_LOCAL && (nodeLocalRequest = application.getResourceRequest(priority, node.getHostName())) != null) {
            return nodeLocalRequest.getNumContainers() > 0;
        }
        return false;
    }

    private Container getContainer(RMContainer rmContainer, SchedulerApp application, SchedulerNode node, org.apache.hadoop.yarn.api.records.Resource capability, Priority priority) {
        return rmContainer != null ? rmContainer.getContainer() : this.createContainer(application, node, capability, priority);
    }

    public Container createContainer(SchedulerApp application, SchedulerNode node, org.apache.hadoop.yarn.api.records.Resource capability, Priority priority) {
        NodeId nodeId = node.getRMNode().getNodeID();
        ContainerId containerId = BuilderUtils.newContainerId((ApplicationAttemptId)application.getApplicationAttemptId(), (int)application.getNewContainerId());
        ContainerToken containerToken = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            ContainerTokenIdentifier tokenIdentifier = new ContainerTokenIdentifier(containerId, nodeId.toString(), capability);
            containerToken = BuilderUtils.newContainerToken((NodeId)nodeId, (ByteBuffer)ByteBuffer.wrap(this.containerTokenSecretManager.createPassword(tokenIdentifier)), (ContainerTokenIdentifier)tokenIdentifier);
        }
        Container container = BuilderUtils.newContainer((ContainerId)containerId, (NodeId)nodeId, (String)node.getRMNode().getHttpAddress(), (org.apache.hadoop.yarn.api.records.Resource)capability, (Priority)priority, containerToken);
        return container;
    }

    private org.apache.hadoop.yarn.api.records.Resource assignContainer(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerNode node, SchedulerApp application, Priority priority, ResourceRequest request, NodeType type, RMContainer rmContainer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("assignContainers: node=" + node.getHostName() + " application=" + application.getApplicationId().getId() + " priority=" + priority.getPriority() + " request=" + request + " type=" + (Object)((Object)type)));
        }
        org.apache.hadoop.yarn.api.records.Resource capability = request.getCapability();
        org.apache.hadoop.yarn.api.records.Resource available = node.getAvailableResource();
        assert (available.getMemory() > 0);
        Container container = this.getContainer(rmContainer, application, node, capability, priority);
        int availableContainers = available.getMemory() / capability.getMemory();
        if (availableContainers > 0) {
            RMContainer allocatedContainer;
            if (rmContainer != null) {
                this.unreserve(application, priority, node, rmContainer);
            }
            if ((allocatedContainer = application.allocate(type, node, priority, request, container)) == null) {
                return Resources.none();
            }
            node.allocateContainer(application.getApplicationId(), allocatedContainer);
            LOG.info((Object)("assignedContainer application=" + application.getApplicationId() + " container=" + container + " containerId=" + container.getId() + " queue=" + this + " util=" + this.getUtilization() + " used=" + this.usedResources + " cluster=" + clusterResource));
            return container.getResource();
        }
        this.reserve(application, priority, node, rmContainer, container);
        LOG.info((Object)("Reserved container  application=" + application.getApplicationId() + " resource=" + request.getCapability() + " queue=" + this.toString() + " util=" + this.getUtilization() + " used=" + this.usedResources + " cluster=" + clusterResource));
        return request.getCapability();
    }

    private void reserve(SchedulerApp application, Priority priority, SchedulerNode node, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            this.getMetrics().reserveResource(application.getUser(), container.getResource());
        }
        rmContainer = application.reserve(node, priority, rmContainer, container);
        node.reserveResource(application, priority, rmContainer);
    }

    private void unreserve(SchedulerApp application, Priority priority, SchedulerNode node, RMContainer rmContainer) {
        application.unreserve(node, priority);
        node.unreserveResource(application);
        this.getMetrics().unreserveResource(application.getUser(), rmContainer.getContainer().getResource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completedContainer(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, SchedulerNode node, RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (application != null) {
            LeafQueue leafQueue = this;
            synchronized (leafQueue) {
                Container container = rmContainer.getContainer();
                if (rmContainer.getState() == RMContainerState.RESERVED) {
                    application.unreserve(node, rmContainer.getReservedPriority());
                    node.unreserveResource(application);
                } else {
                    application.containerCompleted(rmContainer, containerStatus, event);
                    node.releaseContainer(container);
                }
                this.releaseResource(clusterResource, application, container.getResource());
                LOG.info((Object)("completedContainer container=" + container + " resource=" + container.getResource() + " queue=" + this + " util=" + this.getUtilization() + " used=" + this.usedResources + " cluster=" + clusterResource));
            }
            this.parent.completedContainer(clusterResource, application, node, rmContainer, null, event);
        }
    }

    synchronized void allocateResource(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource resource) {
        Resources.addTo(this.usedResources, resource);
        this.updateResource(clusterResource);
        ++this.numContainers;
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.assignContainer(resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        LOG.info((Object)(this.getQueueName() + " used=" + this.usedResources + " numContainers=" + this.numContainers + " user=" + userName + " resources=" + user.getConsumedResources()));
    }

    synchronized void releaseResource(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, org.apache.hadoop.yarn.api.records.Resource resource) {
        Resources.subtractFrom(this.usedResources, resource);
        this.updateResource(clusterResource);
        --this.numContainers;
        String userName = application.getUser();
        User user = this.getUser(userName);
        user.releaseContainer(resource);
        this.metrics.setAvailableResourcesToUser(userName, application.getHeadroom());
        LOG.info((Object)(this.getQueueName() + " used=" + this.usedResources + " numContainers=" + this.numContainers + " user=" + userName + " resources=" + user.getConsumedResources()));
    }

    @Override
    public synchronized void updateClusterResource(org.apache.hadoop.yarn.api.records.Resource clusterResource) {
        this.maxActiveApplications = this.computeMaxActiveApplications(clusterResource, this.maxAMResourcePercent, this.absoluteCapacity);
        this.maxActiveApplicationsPerUser = this.computeMaxActiveApplicationsPerUser(this.maxActiveApplications, this.userLimit, this.userLimitFactor);
        for (SchedulerApp application : this.activeApplications) {
            this.computeAndSetUserResourceLimit(application, clusterResource);
        }
    }

    private synchronized void updateResource(org.apache.hadoop.yarn.api.records.Resource clusterResource) {
        float queueLimit = (float)clusterResource.getMemory() * this.absoluteCapacity;
        this.setUtilization((float)this.usedResources.getMemory() / queueLimit);
        this.setUsedCapacity((float)this.usedResources.getMemory() / ((float)clusterResource.getMemory() * this.capacity));
        org.apache.hadoop.yarn.api.records.Resource resourceLimit = Resources.createResource(this.roundUp((int)queueLimit));
        this.metrics.setAvailableResourcesToQueue(Resources.subtractFrom(resourceLimit, this.usedResources));
    }

    @Override
    public QueueMetrics getMetrics() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recoverContainer(org.apache.hadoop.yarn.api.records.Resource clusterResource, SchedulerApp application, Container container) {
        LeafQueue leafQueue = this;
        synchronized (leafQueue) {
            this.allocateResource(clusterResource, application, container.getResource());
        }
        this.parent.recoverContainer(clusterResource, application, container);
    }

    static class User {
        org.apache.hadoop.yarn.api.records.Resource consumed = Resources.createResource(0);
        int pendingApplications = 0;
        int activeApplications = 0;

        User() {
        }

        public org.apache.hadoop.yarn.api.records.Resource getConsumedResources() {
            return this.consumed;
        }

        public int getPendingApplications() {
            return this.pendingApplications;
        }

        public int getActiveApplications() {
            return this.activeApplications;
        }

        public int getTotalApplications() {
            return this.getPendingApplications() + this.getActiveApplications();
        }

        public synchronized void submitApplication() {
            ++this.pendingApplications;
        }

        public synchronized void activateApplication() {
            --this.pendingApplications;
            ++this.activeApplications;
        }

        public synchronized void finishApplication() {
            --this.activeApplications;
        }

        public synchronized void assignContainer(org.apache.hadoop.yarn.api.records.Resource resource) {
            Resources.addTo(this.consumed, resource);
        }

        public synchronized void releaseContainer(org.apache.hadoop.yarn.api.records.Resource resource) {
            Resources.subtractFrom(this.consumed, resource);
        }
    }
}

