/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;

class CapacitySchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float WIDTH_F = 0.8f;
    static final String Q_END = "left:101%";
    static final String OVER = "font-size:1px;background:rgba(255, 140, 0, 0.8)";
    static final String UNDER = "font-size:1px;background:rgba(50, 205, 50, 0.8)";
    static final float EPSILON = 1.0E-8f;

    CapacitySchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage._> html) {
        ((Hamlet.HTML)html.style().$type("text/css")._(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }"})._()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript")._(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    data.inst.open_all(); }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'root') q = '';", "    $('#apps').dataTable().fnFilter(q, 3);", "  });", "  $('#cs').show();", "});"})._();
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return String.format("%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String width(float f) {
        return String.format("width:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String left(float f) {
        return String.format("left:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static class QueuesBlock
    extends HtmlBlock {
        final CapacityScheduler cs;
        final Parent parent;

        @Inject
        QueuesBlock(ResourceManager rm, Parent parent) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
            this.parent = parent;
        }

        public void render(HtmlBlock.Block html) {
            html._(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top")._(new Object[]{"Application Queues"})._()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.cs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(CapacitySchedulerPage.Q_END)._(new Object[]{"100% "})._()).span(".q", "default")._())._();
            } else {
                CSQueue root;
                this.parent.queue = root = this.cs.getRootQueue();
                float used = root.getUsedCapacity();
                float set = root.getCapacity();
                float delta = Math.abs(set - used) + 0.001f;
                ((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).$title(StringHelper.join((Object[])new Object[]{"used:", CapacitySchedulerPage.percent(used)})).span().$style(CapacitySchedulerPage.Q_END)._(new Object[]{"100%"})._()).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(delta), Character.valueOf(';'), used > set ? CapacitySchedulerPage.OVER : CapacitySchedulerPage.UNDER, Character.valueOf(';'), used > set ? CapacitySchedulerPage.left(set) : CapacitySchedulerPage.left(used)}))._(new Object[]{"."})._()).span(".q", "root")._())._(QueueBlock.class)._();
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul._())._()).script().$type("text/javascript")._(new Object[]{"$('#cs').hide();"})._())._())._(AppsBlock.class);
        }
    }

    public static class QueueBlock
    extends HtmlBlock {
        final Parent parent;

        @Inject
        QueueBlock(Parent parent) {
            this.parent = parent;
        }

        public void render(HtmlBlock.Block html) {
            Hamlet.UL ul = html.ul();
            CSQueue parentQueue = this.parent.queue;
            for (CSQueue queue : parentQueue.getChildQueues()) {
                float used = queue.getUsedCapacity();
                float set = queue.getCapacity();
                float delta = Math.abs(set - used) + 0.001f;
                float max = queue.getMaximumCapacity();
                if (max < 1.0E-8f || max > 1.0f) {
                    max = 1.0f;
                }
                Hamlet.LI li = (Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(max * 0.8f)).$title(StringHelper.join((Object[])new Object[]{"used:", CapacitySchedulerPage.percent(used), " set:", CapacitySchedulerPage.percent(set), " max:", CapacitySchedulerPage.percent(max)})).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(delta / max), Character.valueOf(';'), used > set ? CapacitySchedulerPage.OVER : CapacitySchedulerPage.UNDER, Character.valueOf(';'), used > set ? CapacitySchedulerPage.left(set / max) : CapacitySchedulerPage.left(used / max)}))._(new Object[]{Character.valueOf('.')})._()).span(".q", queue.getQueuePath().substring(5))._();
                if (queue instanceof ParentQueue) {
                    this.parent.queue = queue;
                    li._(QueueBlock.class);
                }
                li._();
            }
            ul._();
        }
    }

    @RequestScoped
    static class Parent {
        CSQueue queue;

        Parent() {
        }
    }
}

