/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsBlockWithMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsList;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.NavBlock;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.apache.hadoop.yarn.webapp.view.TwoColumnLayout;

public class RmView
extends TwoColumnLayout {
    static final int MAX_DISPLAY_ROWS = 100;
    static final int MAX_FAST_ROWS = 1000;
    static final int MAX_INLINE_ROWS = 2000;

    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        this.set("ui.dataTables.id", "apps");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"apps"), this.appsTableInit());
        this.setTableStyles(html, "apps", new String[]{".queue {width:6em}", ".ui {width:8em}"});
    }

    protected void commonPreHead(Hamlet.HTML<HtmlPage._> html) {
        this.set("ui.accordion.id", "nav");
        this.set(JQueryUI.initID((String)"ui.accordion", (String)"nav"), "{autoHeight:false, active:0}");
        this.set("ui.themeswitcher.id", "themeswitcher");
    }

    protected Class<? extends SubView> nav() {
        return NavBlock.class;
    }

    protected Class<? extends SubView> content() {
        return AppsBlockWithMetrics.class;
    }

    private String appsTableInit() {
        int rowLimit;
        AppsList list = (AppsList)this.getInstance(AppsList.class);
        StringBuilder init = JQueryUI.tableInit().append(", aoColumns:[{sType:'title-numeric'}, null, null, null, null,").append("null,{sType:'title-numeric', bSearchable:false}, null, null]");
        String rows = this.$("rowlimit");
        int n = rowLimit = rows.isEmpty() ? 100 : Integer.parseInt(rows);
        if (list.apps.size() < rowLimit) {
            list.rendering = JQueryUI.Render.HTML;
            return init.append('}').toString();
        }
        if (list.apps.size() > 1000) {
            JQueryUI.tableInitProgress((StringBuilder)init, (long)(list.apps.size() * 6));
        }
        if (list.apps.size() > 2000) {
            list.rendering = JQueryUI.Render.JS_LOAD;
            return init.append(", sAjaxSource:'").append(this.url(new String[]{"apps", "json"})).append("'}").toString();
        }
        list.rendering = JQueryUI.Render.JS_ARRAY;
        return init.append(", aaData:appsData}").toString();
    }
}

