/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.yarn.api.RMAdminProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshAdminAclsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshAdminAclsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshServiceAclsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshServiceAclsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshSuperUserGroupsConfigurationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshSuperUserGroupsConfigurationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshUserToGroupsMappingsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshUserToGroupsMappingsResponse;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRemoteException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.service.AbstractService;

public class AdminService
extends AbstractService
implements RMAdminProtocol {
    private static final Log LOG = LogFactory.getLog(AdminService.class);
    private final Configuration conf;
    private final ResourceScheduler scheduler;
    private final RMContext rmContext;
    private final NodesListManager nodesListManager;
    private final ClientRMService clientRMService;
    private final ApplicationMasterService applicationMasterService;
    private final ResourceTrackerService resourceTrackerService;
    private Server server;
    private InetSocketAddress masterServiceAddress;
    private AccessControlList adminAcl;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    public AdminService(Configuration conf, ResourceScheduler scheduler, RMContext rmContext, NodesListManager nodesListManager, ClientRMService clientRMService, ApplicationMasterService applicationMasterService, ResourceTrackerService resourceTrackerService) {
        super(AdminService.class.getName());
        this.conf = conf;
        this.scheduler = scheduler;
        this.rmContext = rmContext;
        this.nodesListManager = nodesListManager;
        this.clientRMService = clientRMService;
        this.applicationMasterService = applicationMasterService;
        this.resourceTrackerService = resourceTrackerService;
    }

    public void init(Configuration conf) {
        super.init(conf);
        this.masterServiceAddress = conf.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033);
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
    }

    public void start() {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(RMAdminProtocol.class, (Object)this, this.masterServiceAddress, conf, null, conf.getInt("yarn.resourcemanager.admin.client.thread-count", 1));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new RMPolicyProvider());
        }
        this.server.start();
        conf.updateConnectAddr("yarn.resourcemanager.admin.address", this.server.getListenerAddress());
        super.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
        super.stop();
    }

    private UserGroupInformation checkAcls(String method) throws YarnRemoteException {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Couldn't get current user", (Throwable)ioe);
            RMAuditLogger.logFailure("UNKNOWN", method, this.adminAcl.toString(), "AdminService", "Couldn't get current user");
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
        if (!this.adminAcl.isUserAllowed(user)) {
            LOG.warn((Object)("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'"));
            RMAuditLogger.logFailure(user.getShortUserName(), method, this.adminAcl.toString(), "AdminService", "Unauthorized user");
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + user.getShortUserName() + " doesn't have permission" + " to call '" + method + "'"));
        }
        LOG.info((Object)("RM Admin: " + method + " invoked by user " + user.getShortUserName()));
        return user;
    }

    public RefreshQueuesResponse refreshQueues(RefreshQueuesRequest request) throws YarnRemoteException {
        UserGroupInformation user = this.checkAcls("refreshQueues");
        try {
            this.scheduler.reinitialize(this.conf, this.rmContext);
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshQueues", "AdminService");
            return (RefreshQueuesResponse)this.recordFactory.newRecordInstance(RefreshQueuesResponse.class);
        }
        catch (IOException ioe) {
            LOG.info((Object)"Exception refreshing queues ", (Throwable)ioe);
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshQueues", this.adminAcl.toString(), "AdminService", "Exception refreshing queues");
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    public RefreshNodesResponse refreshNodes(RefreshNodesRequest request) throws YarnRemoteException {
        UserGroupInformation user = this.checkAcls("refreshNodes");
        try {
            this.nodesListManager.refreshNodes((Configuration)new YarnConfiguration());
            RMAuditLogger.logSuccess(user.getShortUserName(), "refreshNodes", "AdminService");
            return (RefreshNodesResponse)this.recordFactory.newRecordInstance(RefreshNodesResponse.class);
        }
        catch (IOException ioe) {
            LOG.info((Object)"Exception refreshing nodes ", (Throwable)ioe);
            RMAuditLogger.logFailure(user.getShortUserName(), "refreshNodes", this.adminAcl.toString(), "AdminService", "Exception refreshing nodes");
            throw RPCUtil.getRemoteException((Throwable)ioe);
        }
    }

    public RefreshSuperUserGroupsConfigurationResponse refreshSuperUserGroupsConfiguration(RefreshSuperUserGroupsConfigurationRequest request) throws YarnRemoteException {
        UserGroupInformation user = this.checkAcls("refreshSuperUserGroupsConfiguration");
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)new Configuration());
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshSuperUserGroupsConfiguration", "AdminService");
        return (RefreshSuperUserGroupsConfigurationResponse)this.recordFactory.newRecordInstance(RefreshSuperUserGroupsConfigurationResponse.class);
    }

    public RefreshUserToGroupsMappingsResponse refreshUserToGroupsMappings(RefreshUserToGroupsMappingsRequest request) throws YarnRemoteException {
        UserGroupInformation user = this.checkAcls("refreshUserToGroupsMappings");
        Groups.getUserToGroupsMappingService().refresh();
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshUserToGroupsMappings", "AdminService");
        return (RefreshUserToGroupsMappingsResponse)this.recordFactory.newRecordInstance(RefreshUserToGroupsMappingsResponse.class);
    }

    public RefreshAdminAclsResponse refreshAdminAcls(RefreshAdminAclsRequest request) throws YarnRemoteException {
        UserGroupInformation user = this.checkAcls("refreshAdminAcls");
        Configuration conf = new Configuration();
        this.adminAcl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        RMAuditLogger.logSuccess(user.getShortUserName(), "refreshAdminAcls", "AdminService");
        return (RefreshAdminAclsResponse)this.recordFactory.newRecordInstance(RefreshAdminAclsResponse.class);
    }

    public RefreshServiceAclsResponse refreshServiceAcls(RefreshServiceAclsRequest request) throws YarnRemoteException {
        Configuration conf = new Configuration();
        if (!conf.getBoolean("hadoop.security.authorization", false)) {
            throw RPCUtil.getRemoteException((Throwable)new IOException("Service Authorization (hadoop.security.authorization) not enabled."));
        }
        RMPolicyProvider policyProvider = new RMPolicyProvider();
        this.refreshServiceAcls(conf, policyProvider);
        this.clientRMService.refreshServiceAcls(conf, policyProvider);
        this.applicationMasterService.refreshServiceAcls(conf, policyProvider);
        this.resourceTrackerService.refreshServiceAcls(conf, policyProvider);
        return (RefreshServiceAclsResponse)this.recordFactory.newRecordInstance(RefreshServiceAclsResponse.class);
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public String[] getGroupsForUser(String user) throws IOException {
        return UserGroupInformation.createRemoteUser((String)user).getGroupNames();
    }
}

