/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(FileSystemRMStateStore.class);
    private static final String ROOT_DIR_NAME = "FSRMStateRoot";
    private FileSystem fs;
    private Path fsRootDirPath;
    @VisibleForTesting
    Path fsWorkingPath;

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.resourcemanager.fs.rm-state-store.uri"));
        this.fsRootDirPath = new Path(this.fsWorkingPath, ROOT_DIR_NAME);
        this.fs = this.fsWorkingPath.getFileSystem(conf);
        this.fs.mkdirs(this.fsRootDirPath);
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        this.fs.close();
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        try {
            RMStateStore.RMState state = new RMStateStore.RMState();
            FileStatus[] childNodes = this.fs.listStatus(this.fsRootDirPath);
            ArrayList<RMStateStore.ApplicationAttemptState> attempts = new ArrayList<RMStateStore.ApplicationAttemptState>();
            for (FileStatus childNodeStatus : childNodes) {
                assert (childNodeStatus.isFile());
                String childNodeName = childNodeStatus.getPath().getName();
                Path childNodePath = this.getNodePath(childNodeName);
                byte[] childData = this.readFile(childNodePath, childNodeStatus.getLen());
                if (childNodeName.startsWith("application_")) {
                    LOG.info((Object)("Loading application from node: " + childNodeName));
                    ApplicationId appId = ConverterUtils.toApplicationId((String)childNodeName);
                    ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl(YarnProtos.ApplicationStateDataProto.parseFrom((byte[])childData));
                    RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getApplicationSubmissionContext());
                    assert (appId.equals((Object)appState.context.getApplicationId()));
                    state.appState.put(appId, appState);
                    continue;
                }
                if (childNodeName.startsWith("appattempt_")) {
                    LOG.info((Object)("Loading application attempt from node: " + childNodeName));
                    ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)childNodeName);
                    ApplicationAttemptStateDataPBImpl attemptStateData = new ApplicationAttemptStateDataPBImpl(YarnProtos.ApplicationAttemptStateDataProto.parseFrom((byte[])childData));
                    RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer());
                    assert (attemptId.equals((Object)attemptState.getAttemptId()));
                    attempts.add(attemptState);
                    continue;
                }
                LOG.info((Object)("Unknown child node with name: " + childNodeName));
            }
            for (RMStateStore.ApplicationAttemptState attemptState : attempts) {
                ApplicationId appId = attemptState.getAttemptId().getApplicationId();
                RMStateStore.ApplicationState appState = state.appState.get(appId);
                if (appState != null) {
                    appState.attempts.put(attemptState.getAttemptId(), attemptState);
                    continue;
                }
                LOG.info((Object)("Application node not found for attempt: " + attemptState.getAttemptId()));
                this.deleteFile(this.getNodePath(attemptState.getAttemptId().toString()));
            }
            return state;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void storeApplicationState(String appId, ApplicationStateDataPBImpl appStateDataPB) throws Exception {
        Path nodeCreatePath = this.getNodePath(appId);
        LOG.info((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void storeApplicationAttemptState(String attemptId, ApplicationAttemptStateDataPBImpl attemptStateDataPB) throws Exception {
        Path nodeCreatePath = this.getNodePath(attemptId);
        LOG.info((Object)("Storing info for attempt: " + attemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for attempt: " + attemptId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void removeApplicationState(RMStateStore.ApplicationState appState) throws Exception {
        String appId = appState.getAppId().toString();
        Path nodeRemovePath = this.getNodePath(appId);
        LOG.info((Object)("Removing info for app: " + appId + " at: " + nodeRemovePath));
        this.deleteFile(nodeRemovePath);
        for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
            this.removeApplicationAttemptState(attemptId.toString());
        }
    }

    public synchronized void removeApplicationAttemptState(String attemptId) throws Exception {
        Path nodeRemovePath = this.getNodePath(attemptId);
        LOG.info((Object)("Removing info for attempt: " + attemptId + " at: " + nodeRemovePath));
        this.deleteFile(nodeRemovePath);
    }

    private void deleteFile(Path deletePath) throws Exception {
        if (!this.fs.delete(deletePath, true)) {
            throw new Exception("Failed to delete " + deletePath);
        }
    }

    private byte[] readFile(Path inputPath, long len) throws Exception {
        FSDataInputStream fsIn = this.fs.open(inputPath);
        byte[] data = new byte[(int)len];
        fsIn.readFully(data);
        return data;
    }

    private void writeFile(Path outputPath, byte[] data) throws Exception {
        FSDataOutputStream fsOut = this.fs.create(outputPath, false);
        fsOut.write(data);
        fsOut.flush();
        fsOut.close();
    }

    @VisibleForTesting
    Path getNodePath(String nodeName) {
        return new Path(this.fsRootDirPath, nodeName);
    }
}

