/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ClientToken;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.security.client.ClientTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEvent;
import org.apache.hadoop.yarn.server.resourcemanager.amlauncher.AMLauncherEventType;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFinishedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptLaunchFailedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStatusupdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStoredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.webproxy.ProxyUriUtils;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BuilderUtils;
import org.apache.hadoop.yarn.util.StringHelper;

public class RMAppAttemptImpl
implements RMAppAttempt,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppAttemptImpl.class);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    public static final Priority AM_CONTAINER_PRIORITY = (Priority)recordFactory.newRecordInstance(Priority.class);
    private final StateMachine<RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachine;
    private final RMContext rmContext;
    private final EventHandler eventHandler;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final ApplicationAttemptId applicationAttemptId;
    private ClientToken clientToken;
    private final ApplicationSubmissionContext submissionContext;
    private final Set<NodeId> ranNodes = new HashSet<NodeId>();
    private final List<ContainerStatus> justFinishedContainers = new ArrayList<ContainerStatus>();
    private Container masterContainer;
    private float progress = 0.0f;
    private String host = "N/A";
    private int rpcPort;
    private String origTrackingUrl = "N/A";
    private String proxiedTrackingUrl = "N/A";
    private long startTime = 0L;
    private FinalApplicationStatus finalStatus = null;
    private final StringBuilder diagnostics = new StringBuilder();
    private Configuration conf;
    private static final StateMachineFactory<RMAppAttemptImpl, RMAppAttemptState, RMAppAttemptEventType, RMAppAttemptEvent> stateMachineFactory;
    private static final List<ContainerId> EMPTY_CONTAINER_RELEASE_LIST;
    private static final List<ResourceRequest> EMPTY_CONTAINER_REQUEST_LIST;

    public RMAppAttemptImpl(ApplicationAttemptId appAttemptId, RMContext rmContext, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationSubmissionContext submissionContext, Configuration conf) {
        this.conf = conf;
        this.applicationAttemptId = appAttemptId;
        this.rmContext = rmContext;
        this.eventHandler = rmContext.getDispatcher().getEventHandler();
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        if (UserGroupInformation.isSecurityEnabled()) {
            this.rmContext.getClientToAMTokenSecretManager().registerApplication(appAttemptId);
            Token token = new Token((TokenIdentifier)new ClientTokenIdentifier(appAttemptId), (SecretManager)this.rmContext.getClientToAMTokenSecretManager());
            this.clientToken = BuilderUtils.newClientToken((byte[])token.getIdentifier(), (String)token.getKind().toString(), (byte[])token.getPassword(), (String)token.getService().toString());
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.proxiedTrackingUrl = this.generateProxyUriWithoutScheme();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    @Override
    public ApplicationAttemptId getAppAttemptId() {
        return this.applicationAttemptId;
    }

    @Override
    public ApplicationSubmissionContext getSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            FinalApplicationStatus finalApplicationStatus = this.finalStatus;
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttemptState getAppAttemptState() {
        this.readLock.lock();
        try {
            RMAppAttemptState rMAppAttemptState = (RMAppAttemptState)this.stateMachine.getCurrentState();
            return rMAppAttemptState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHost() {
        this.readLock.lock();
        try {
            String string = this.host;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRpcPort() {
        this.readLock.lock();
        try {
            int n = this.rpcPort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.proxiedTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOriginalTrackingUrl() {
        this.readLock.lock();
        try {
            String string = this.origTrackingUrl;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWebProxyBase() {
        this.readLock.lock();
        try {
            String string = ProxyUriUtils.getPath((ApplicationId)this.applicationAttemptId.getApplicationId());
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private String generateProxyUriWithoutScheme() {
        return this.generateProxyUriWithoutScheme(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateProxyUriWithoutScheme(String trackingUriWithoutScheme) {
        this.readLock.lock();
        try {
            URI trackingUri = StringUtils.isEmpty((String)trackingUriWithoutScheme) ? null : ProxyUriUtils.getUriFromAMUrl((String)trackingUriWithoutScheme);
            String proxy = YarnConfiguration.getProxyHostAndPort((Configuration)this.conf);
            URI proxyUri = ProxyUriUtils.getUriFromAMUrl((String)proxy);
            URI result = ProxyUriUtils.getProxyUri((URI)trackingUri, (URI)proxyUri, (ApplicationId)this.applicationAttemptId.getApplicationId());
            String string = result.toASCIIString().substring(HttpConfig.getSchemePrefix().length());
            return string;
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)("Could not proxify " + trackingUriWithoutScheme), (Throwable)e);
            String string = trackingUriWithoutScheme;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ClientToken getClientToken() {
        return this.clientToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDiagnostics() {
        this.readLock.lock();
        try {
            String string = this.diagnostics.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiagnostics(String message) {
        this.writeLock.lock();
        try {
            this.diagnostics.append(message);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            float f = this.progress;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerStatus> getJustFinishedContainers() {
        this.readLock.lock();
        try {
            List<ContainerStatus> list = this.justFinishedContainers;
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ContainerStatus> pullJustFinishedContainers() {
        this.writeLock.lock();
        try {
            ArrayList<ContainerStatus> returnList = new ArrayList<ContainerStatus>(this.justFinishedContainers.size());
            returnList.addAll(this.justFinishedContainers);
            this.justFinishedContainers.clear();
            ArrayList<ContainerStatus> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<NodeId> getRanNodes() {
        return this.ranNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container getMasterContainer() {
        this.readLock.lock();
        try {
            Container container = this.masterContainer;
            return container;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void setMasterContainer(Container container) {
        this.masterContainer = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppAttemptEvent event) {
        this.writeLock.lock();
        try {
            ApplicationAttemptId appAttemptID = event.getApplicationAttemptId();
            LOG.debug((Object)("Processing event for " + appAttemptID + " of type " + event.getType()));
            RMAppAttemptState oldState = this.getAppAttemptState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getAppAttemptState()) {
                LOG.info((Object)(appAttemptID + " State change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getAppAttemptState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationResourceUsageReport getApplicationResourceUsageReport() {
        this.readLock.lock();
        try {
            int numUsedContainers = 0;
            int numReservedContainers = 0;
            Resource currentConsumption = Resources.createResource(0, 0);
            Resource reservedResources = Resources.createResource(0, 0);
            SchedulerAppReport schedApp = this.scheduler.getSchedulerAppInfo(this.getAppAttemptId());
            if (schedApp != null) {
                Collection<RMContainer> liveContainers = schedApp.getLiveContainers();
                Collection<RMContainer> reservedContainers = schedApp.getReservedContainers();
                if (liveContainers != null) {
                    numUsedContainers = liveContainers.size();
                    for (RMContainer lc : liveContainers) {
                        Resources.addTo(currentConsumption, lc.getContainer().getResource());
                    }
                }
                if (reservedContainers != null) {
                    numReservedContainers = reservedContainers.size();
                    for (RMContainer rc : reservedContainers) {
                        Resources.addTo(reservedResources, rc.getContainer().getResource());
                    }
                }
            }
            ApplicationResourceUsageReport applicationResourceUsageReport = BuilderUtils.newApplicationResourceUsageReport((int)numUsedContainers, (int)numReservedContainers, (Resource)currentConsumption, (Resource)reservedResources, (Resource)Resources.add(currentConsumption, reservedResources));
            return applicationResourceUsageReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) {
        RMStateStore.ApplicationState appState = state.getApplicationState().get(this.getAppAttemptId().getApplicationId());
        RMStateStore.ApplicationAttemptState attemptState = appState.getAttempt(this.getAppAttemptId());
        assert (attemptState != null);
        this.setMasterContainer(attemptState.getMasterContainer());
        LOG.info((Object)("Recovered attempt: AppId: " + this.getAppAttemptId().getApplicationId() + " AttemptId: " + this.getAppAttemptId() + " MasterContainer: " + this.masterContainer));
        this.setDiagnostics("Attempt recovered after RM restart");
        this.handle(new RMAppAttemptEvent(this.getAppAttemptId(), RMAppAttemptEventType.RECOVER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void launchAttempt() {
        this.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.LAUNCH, this));
    }

    private void attemptLaunched() {
        this.rmContext.getAMLivelinessMonitor().register(this.getAppAttemptId());
    }

    private void checkAttemptStoreError(RMAppAttemptEvent event) {
        RMAppAttemptStoredEvent storeEvent = (RMAppAttemptStoredEvent)event;
        if (storeEvent.getStoredException() != null) {
            LOG.error((Object)("Failed to store attempt: " + this.getAppAttemptId()), (Throwable)storeEvent.getStoredException());
            ExitUtil.terminate((int)1, (Throwable)storeEvent.getStoredException());
        }
    }

    private void storeAttempt(RMStateStore store) {
        LOG.info((Object)("Storing attempt: AppId: " + this.getAppAttemptId().getApplicationId() + " AttemptId: " + this.getAppAttemptId() + " MasterContainer: " + this.masterContainer));
        store.storeApplicationAttempt(this);
    }

    static {
        AM_CONTAINER_PRIORITY.setPriority(0);
        stateMachineFactory = new StateMachineFactory((Enum)RMAppAttemptState.NEW).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptEventType.START, (SingleArcTransition)new AttemptStartedTransition()).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new UnexpectedAMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.NEW, (Enum)RMAppAttemptState.RECOVERED, (Enum)RMAppAttemptEventType.RECOVER).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, EnumSet.of(RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, RMAppAttemptState.SCHEDULED), (Enum)RMAppAttemptEventType.APP_ACCEPTED, (MultipleArcTransition)new ScheduleTransition()).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.SUBMITTED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new UnexpectedAMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED, (SingleArcTransition)new AMContainerAllocatedTransition()).addTransition((Enum)RMAppAttemptState.SCHEDULED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.ATTEMPT_SAVED, (SingleArcTransition)new AttemptStoredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED_SAVING, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.ATTEMPT_SAVED, (SingleArcTransition)new UnmanagedAMAttemptSavedTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new UnexpectedAMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new BaseFinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptEventType.LAUNCHED, (SingleArcTransition)new AMLaunchedTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.LAUNCH_FAILED, (SingleArcTransition)new LaunchFailedTransition()).addTransition((Enum)RMAppAttemptState.ALLOCATED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new KillAllocatedAMTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.REGISTERED, (SingleArcTransition)new AMRegisteredTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (SingleArcTransition)new AMContainerCrashedTransition()).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.LAUNCHED, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.UNREGISTERED, (MultipleArcTransition)new AMUnregisteredTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.STATUS_UPDATE, (SingleArcTransition)new StatusUpdateTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ALLOCATED).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptEventType.CONTAINER_ACQUIRED, (SingleArcTransition)new ContainerAcquiredTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, EnumSet.of(RMAppAttemptState.RUNNING, RMAppAttemptState.FAILED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new ContainerFinishedTransition()).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FAILED)).addTransition((Enum)RMAppAttemptState.RUNNING, (Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptEventType.KILL, (SingleArcTransition)new FinalTransition(RMAppAttemptState.KILLED)).addTransition((Enum)RMAppAttemptState.FAILED, (Enum)RMAppAttemptState.FAILED, EnumSet.of(RMAppAttemptEventType.EXPIRE, new RMAppAttemptEventType[]{RMAppAttemptEventType.KILL, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED})).addTransition((Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptState.FINISHING, RMAppAttemptState.FINISHED), (Enum)RMAppAttemptEventType.CONTAINER_FINISHED, (MultipleArcTransition)new AMFinishingContainerFinishedTransition()).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptEventType.EXPIRE, (SingleArcTransition)new FinalTransition(RMAppAttemptState.FINISHED)).addTransition((Enum)RMAppAttemptState.FINISHING, (Enum)RMAppAttemptState.FINISHING, EnumSet.of(RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.STATUS_UPDATE, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.FINISHED, (Enum)RMAppAttemptState.FINISHED, EnumSet.of(RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.KILL)).addTransition((Enum)RMAppAttemptState.KILLED, (Enum)RMAppAttemptState.KILLED, EnumSet.of(RMAppAttemptEventType.APP_ACCEPTED, new RMAppAttemptEventType[]{RMAppAttemptEventType.APP_REJECTED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.ATTEMPT_SAVED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.STATUS_UPDATE})).addTransition((Enum)RMAppAttemptState.RECOVERED, (Enum)RMAppAttemptState.RECOVERED, EnumSet.of(RMAppAttemptEventType.START, new RMAppAttemptEventType[]{RMAppAttemptEventType.APP_ACCEPTED, RMAppAttemptEventType.APP_REJECTED, RMAppAttemptEventType.EXPIRE, RMAppAttemptEventType.LAUNCHED, RMAppAttemptEventType.LAUNCH_FAILED, RMAppAttemptEventType.REGISTERED, RMAppAttemptEventType.CONTAINER_ALLOCATED, RMAppAttemptEventType.CONTAINER_ACQUIRED, RMAppAttemptEventType.ATTEMPT_SAVED, RMAppAttemptEventType.CONTAINER_FINISHED, RMAppAttemptEventType.UNREGISTERED, RMAppAttemptEventType.KILL, RMAppAttemptEventType.STATUS_UPDATE})).installTopology();
        EMPTY_CONTAINER_RELEASE_LIST = new ArrayList<ContainerId>();
        EMPTY_CONTAINER_REQUEST_LIST = new ArrayList<ResourceRequest>();
    }

    private static final class AMFinishingContainerFinishedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AMFinishingContainerFinishedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                new FinalTransition(RMAppAttemptState.FINISHED).transition(appAttempt, containerFinishedEvent);
                return RMAppAttemptState.FINISHED;
            }
            appAttempt.justFinishedContainers.add(containerStatus);
            return RMAppAttemptState.FINISHING;
        }
    }

    private static final class ContainerFinishedTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private ContainerFinishedTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent containerFinishedEvent = (RMAppAttemptContainerFinishedEvent)event;
            ContainerStatus containerStatus = containerFinishedEvent.getContainerStatus();
            if (appAttempt.masterContainer != null && appAttempt.masterContainer.getId().equals((Object)containerStatus.getContainerId())) {
                assert (!appAttempt.submissionContext.getUnmanagedAM());
                appAttempt.diagnostics.append("AM Container for " + appAttempt.getAppAttemptId() + " exited with " + " exitCode: " + containerStatus.getExitStatus() + " due to: " + containerStatus.getDiagnostics() + "." + "Failing this attempt.");
                appAttempt.origTrackingUrl = StringHelper.pjoin((Object[])new Object[]{YarnConfiguration.getRMWebAppHostAndPort((Configuration)appAttempt.conf), "cluster", "app", appAttempt.getAppAttemptId().getApplicationId()});
                appAttempt.proxiedTrackingUrl = appAttempt.origTrackingUrl;
                new FinalTransition(RMAppAttemptState.FAILED).transition(appAttempt, containerFinishedEvent);
                return RMAppAttemptState.FAILED;
            }
            appAttempt.justFinishedContainers.add(containerStatus);
            return RMAppAttemptState.RUNNING;
        }
    }

    private static final class ContainerAcquiredTransition
    extends BaseTransition {
        private ContainerAcquiredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerAcquiredEvent acquiredEvent = (RMAppAttemptContainerAcquiredEvent)event;
            appAttempt.ranNodes.add(acquiredEvent.getContainer().getNodeId());
        }
    }

    private static final class AMUnregisteredTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private AMUnregisteredTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            ApplicationAttemptId appAttemptId = appAttempt.getAppAttemptId();
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttemptId);
            appAttempt.rmContext.getApplicationTokenSecretManager().applicationMasterFinished(appAttemptId);
            appAttempt.progress = 1.0f;
            RMAppAttemptUnregistrationEvent unregisterEvent = (RMAppAttemptUnregistrationEvent)event;
            appAttempt.diagnostics.append(unregisterEvent.getDiagnostics());
            appAttempt.origTrackingUrl = unregisterEvent.getTrackingUrl();
            appAttempt.proxiedTrackingUrl = appAttempt.generateProxyUriWithoutScheme(appAttempt.origTrackingUrl);
            appAttempt.finalStatus = unregisterEvent.getFinalApplicationStatus();
            if (appAttempt.getSubmissionContext().getUnmanagedAM()) {
                new FinalTransition(RMAppAttemptState.FINISHED).transition(appAttempt, event);
                return RMAppAttemptState.FINISHED;
            }
            appAttempt.rmContext.getAMFinishingMonitor().register(appAttemptId);
            ApplicationId applicationId = appAttempt.getAppAttemptId().getApplicationId();
            appAttempt.eventHandler.handle((Event)new RMAppEvent(applicationId, RMAppEventType.ATTEMPT_FINISHING));
            return RMAppAttemptState.FINISHING;
        }
    }

    private static final class StatusUpdateTransition
    extends BaseTransition {
        private StatusUpdateTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptStatusupdateEvent statusUpdateEvent = (RMAppAttemptStatusupdateEvent)event;
            appAttempt.progress = statusUpdateEvent.getProgress();
            appAttempt.rmContext.getAMLivelinessMonitor().receivedPing(statusUpdateEvent.getApplicationAttemptId());
        }
    }

    private static class UnexpectedAMRegisteredTransition
    extends BaseFinalTransition {
        public UnexpectedAMRegisteredTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            assert (appAttempt.submissionContext.getUnmanagedAM());
            appAttempt.setDiagnostics("Unmanaged AM must register after AM attempt reaches LAUNCHED state.");
            super.transition(appAttempt, event);
        }
    }

    private static class FinalTransition
    extends BaseFinalTransition {
        public FinalTransition(RMAppAttemptState finalAttemptState) {
            super(finalAttemptState);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.progress = 1.0f;
            super.transition(appAttempt, event);
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            appAttempt.rmContext.getAMFinishingMonitor().unregister(appAttempt.getAppAttemptId());
            if (UserGroupInformation.isSecurityEnabled()) {
                appAttempt.rmContext.getClientToAMTokenSecretManager().unRegisterApplication(appAttempt.getAppAttemptId());
            }
            if (!appAttempt.submissionContext.getUnmanagedAM()) {
                appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
            }
        }
    }

    private static final class AMContainerCrashedTransition
    extends BaseFinalTransition {
        public AMContainerCrashedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptContainerFinishedEvent finishEvent = (RMAppAttemptContainerFinishedEvent)event;
            appAttempt.rmContext.getAMLivelinessMonitor().unregister(appAttempt.getAppAttemptId());
            ContainerStatus status = finishEvent.getContainerStatus();
            appAttempt.diagnostics.append("AM Container for " + appAttempt.getAppAttemptId() + " exited with " + " exitCode: " + status.getExitStatus() + " due to: " + status.getDiagnostics() + "." + "Failing this attempt.");
            super.transition(appAttempt, finishEvent);
        }
    }

    private static final class AMRegisteredTransition
    extends BaseTransition {
        private AMRegisteredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptRegistrationEvent registrationEvent = (RMAppAttemptRegistrationEvent)event;
            appAttempt.host = registrationEvent.getHost();
            appAttempt.rpcPort = registrationEvent.getRpcport();
            appAttempt.origTrackingUrl = registrationEvent.getTrackingurl();
            appAttempt.proxiedTrackingUrl = appAttempt.generateProxyUriWithoutScheme(appAttempt.origTrackingUrl);
            appAttempt.eventHandler.handle((Event)new RMAppEvent(appAttempt.getAppAttemptId().getApplicationId(), RMAppEventType.ATTEMPT_REGISTERED));
        }
    }

    private static final class KillAllocatedAMTransition
    extends BaseFinalTransition {
        public KillAllocatedAMTransition() {
            super(RMAppAttemptState.KILLED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            super.transition(appAttempt, event);
            appAttempt.eventHandler.handle((Event)new AMLauncherEvent(AMLauncherEventType.CLEANUP, appAttempt));
        }
    }

    private static final class LaunchFailedTransition
    extends BaseFinalTransition {
        public LaunchFailedTransition() {
            super(RMAppAttemptState.FAILED);
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptLaunchFailedEvent launchFaileEvent = (RMAppAttemptLaunchFailedEvent)event;
            appAttempt.diagnostics.append(launchFaileEvent.getMessage());
            super.transition(appAttempt, event);
        }
    }

    private static final class UnmanagedAMAttemptSavedTransition
    extends AMLaunchedTransition {
        private UnmanagedAMAttemptSavedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.checkAttemptStoreError(event);
            appAttempt.eventHandler.handle((Event)new RMAppEvent(event.getApplicationAttemptId().getApplicationId(), RMAppEventType.APP_ACCEPTED));
            super.transition(appAttempt, event);
        }
    }

    private static class AMLaunchedTransition
    extends BaseTransition {
        private AMLaunchedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.attemptLaunched();
        }
    }

    private static class BaseFinalTransition
    extends BaseTransition {
        private final RMAppAttemptState finalAttemptState;

        public BaseFinalTransition(RMAppAttemptState finalAttemptState) {
            this.finalAttemptState = finalAttemptState;
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            ApplicationAttemptId appAttemptId = appAttempt.getAppAttemptId();
            appAttempt.masterService.unregisterAttempt(appAttemptId);
            ApplicationId applicationId = appAttemptId.getApplicationId();
            RMAppEvent appEvent = null;
            switch (this.finalAttemptState) {
                case FINISHED: {
                    appEvent = new RMAppFinishedAttemptEvent(applicationId, appAttempt.getDiagnostics());
                    break;
                }
                case KILLED: {
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_KILLED, "Application killed by user.");
                    break;
                }
                case FAILED: {
                    appEvent = new RMAppFailedAttemptEvent(applicationId, RMAppEventType.ATTEMPT_FAILED, appAttempt.getDiagnostics());
                    break;
                }
                default: {
                    LOG.error((Object)"Cannot get this state!! Error!!");
                }
            }
            appAttempt.eventHandler.handle((Event)appEvent);
            appAttempt.eventHandler.handle((Event)new AppRemovedSchedulerEvent(appAttemptId, this.finalAttemptState));
            appAttempt.rmContext.getApplicationTokenSecretManager().applicationMasterFinished(appAttemptId);
        }
    }

    private static final class AttemptStoredTransition
    extends BaseTransition {
        private AttemptStoredTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.checkAttemptStoreError(event);
            appAttempt.launchAttempt();
        }
    }

    private static final class AMContainerAllocatedTransition
    extends BaseTransition {
        private AMContainerAllocatedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, EMPTY_CONTAINER_REQUEST_LIST, EMPTY_CONTAINER_RELEASE_LIST);
            appAttempt.setMasterContainer(amContainerAllocation.getContainers().get(0));
            RMStateStore store = appAttempt.rmContext.getStateStore();
            appAttempt.storeAttempt(store);
        }
    }

    private static final class ScheduleTransition
    implements MultipleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent, RMAppAttemptState> {
        private ScheduleTransition() {
        }

        public RMAppAttemptState transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            if (!appAttempt.submissionContext.getUnmanagedAM()) {
                appAttempt.eventHandler.handle((Event)new RMAppEvent(event.getApplicationAttemptId().getApplicationId(), RMAppEventType.APP_ACCEPTED));
                ResourceRequest request = BuilderUtils.newResourceRequest((Priority)AM_CONTAINER_PRIORITY, (String)"*", (Resource)appAttempt.submissionContext.getAMContainerSpec().getResource(), (int)1);
                Allocation amContainerAllocation = appAttempt.scheduler.allocate(appAttempt.applicationAttemptId, Collections.singletonList(request), EMPTY_CONTAINER_RELEASE_LIST);
                if (amContainerAllocation != null && amContainerAllocation.getContainers() != null) assert (amContainerAllocation.getContainers().size() == 0);
                return RMAppAttemptState.SCHEDULED;
            }
            RMStateStore store = appAttempt.rmContext.getStateStore();
            appAttempt.storeAttempt(store);
            return RMAppAttemptState.LAUNCHED_UNMANAGED_SAVING;
        }
    }

    private static final class AppRejectedTransition
    extends BaseTransition {
        private AppRejectedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            RMAppAttemptRejectedEvent rejectedEvent = (RMAppAttemptRejectedEvent)event;
            appAttempt.masterService.unregisterAttempt(appAttempt.applicationAttemptId);
            String message = rejectedEvent.getMessage();
            appAttempt.setDiagnostics(message);
            appAttempt.eventHandler.handle((Event)new RMAppRejectedEvent(rejectedEvent.getApplicationAttemptId().getApplicationId(), message));
        }
    }

    private static final class AttemptStartedTransition
    extends BaseTransition {
        private AttemptStartedTransition() {
        }

        @Override
        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
            appAttempt.startTime = System.currentTimeMillis();
            appAttempt.masterService.registerAppAttempt(appAttempt.applicationAttemptId);
            appAttempt.eventHandler.handle((Event)new AppAddedSchedulerEvent(appAttempt.applicationAttemptId, appAttempt.submissionContext.getQueue(), appAttempt.submissionContext.getUser()));
        }
    }

    private static class BaseTransition
    implements SingleArcTransition<RMAppAttemptImpl, RMAppAttemptEvent> {
        private BaseTransition() {
        }

        public void transition(RMAppAttemptImpl appAttempt, RMAppAttemptEvent event) {
        }
    }
}

