/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.Clock;
import org.apache.hadoop.yarn.SystemClock;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerEventLog;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FifoAppComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingAlgorithms;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.WeightAdjuster;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class FairScheduler
implements ResourceScheduler {
    private boolean initialized;
    private FairSchedulerConfiguration conf;
    private RMContext rmContext;
    private Resource minimumAllocation;
    private Resource maximumAllocation;
    private QueueManager queueMgr;
    private Clock clock;
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    public static final Resource CONTAINER_RESERVED = Resources.createResource(-1);
    protected long UPDATE_INTERVAL = 500L;
    private volatile boolean userAsDefaultQueue = false;
    private static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    private static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource(0));
    QueueMetrics rootMetrics;
    protected long lastPreemptionUpdateTime;
    private long lastPreemptCheckTime;
    protected Map<ApplicationAttemptId, FSSchedulerApp> applications = new HashMap<ApplicationAttemptId, FSSchedulerApp>();
    private Map<NodeId, FSSchedulerNode> nodes = new ConcurrentHashMap<NodeId, FSSchedulerNode>();
    private Resource clusterCapacity = (Resource)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(Resource.class);
    protected long preemptionInterval = 15000L;
    protected boolean preemptionEnabled;
    protected boolean sizeBasedWeight;
    protected WeightAdjuster weightAdjuster;
    protected double nodeLocalityThreshold;
    protected double rackLocalityThreshold;
    private FairSchedulerEventLog eventLog;
    protected boolean assignMultiple;
    protected int maxAssign;

    public FairScheduler() {
        this.clock = new SystemClock();
        this.queueMgr = new QueueManager(this);
    }

    public FairSchedulerConfiguration getConf() {
        return this.conf;
    }

    public QueueManager getQueueManager() {
        return this.queueMgr;
    }

    private RMContainer getRMContainer(ContainerId containerId) {
        FSSchedulerApp application = this.applications.get(containerId.getApplicationAttemptId());
        return application == null ? null : application.getRMContainer(containerId);
    }

    protected synchronized void update() {
        this.queueMgr.reloadAllocsIfNecessary();
        this.updateRunnability();
        this.updatePreemptionVariables();
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        ((Schedulable)rootQueue).updateDemand();
        rootQueue.setFairShare(this.clusterCapacity);
        ((FSQueue)rootQueue).recomputeFairShares();
        this.rootMetrics.setAvailableResourcesToQueue(this.clusterCapacity);
    }

    private void updatePreemptionVariables() {
        long now;
        this.lastPreemptionUpdateTime = now = this.clock.getTime();
        for (FSLeafQueue sched : this.queueMgr.getLeafQueues()) {
            if (!this.isStarvedForMinShare(sched)) {
                sched.setLastTimeAtMinShare(now);
            }
            if (this.isStarvedForFairShare(sched)) continue;
            sched.setLastTimeAtHalfFairShare(now);
        }
    }

    boolean isStarvedForMinShare(FSLeafQueue sched) {
        Resource desiredShare = Resources.min(sched.getMinShare(), sched.getDemand());
        return Resources.lessThan(sched.getResourceUsage(), desiredShare);
    }

    boolean isStarvedForFairShare(FSLeafQueue sched) {
        Resource desiredFairShare = Resources.max(Resources.multiply(sched.getFairShare(), 0.5), sched.getDemand());
        return Resources.lessThan(sched.getResourceUsage(), desiredFairShare);
    }

    protected synchronized void preemptTasksIfNecessary() {
        if (!this.preemptionEnabled) {
            return;
        }
        long curTime = this.clock.getTime();
        if (curTime - this.lastPreemptCheckTime < this.preemptionInterval) {
            return;
        }
        this.lastPreemptCheckTime = curTime;
        Resource resToPreempt = Resources.none();
        for (FSLeafQueue sched : this.queueMgr.getLeafQueues()) {
            resToPreempt = Resources.add(resToPreempt, this.resToPreempt(sched, curTime));
        }
        if (Resources.greaterThan(resToPreempt, Resources.none())) {
            this.preemptResources(this.queueMgr.getLeafQueues(), resToPreempt);
        }
    }

    protected void preemptResources(Collection<FSLeafQueue> scheds, Resource toPreempt) {
        if (scheds.isEmpty() || Resources.equals(toPreempt, Resources.none())) {
            return;
        }
        HashMap<RMContainer, FSSchedulerApp> apps = new HashMap<RMContainer, FSSchedulerApp>();
        HashMap<RMContainer, FSLeafQueue> queues = new HashMap<RMContainer, FSLeafQueue>();
        ArrayList<RMContainer> runningContainers = new ArrayList<RMContainer>();
        for (FSLeafQueue sched : scheds) {
            if (!Resources.greaterThan(sched.getResourceUsage(), sched.getFairShare())) continue;
            for (AppSchedulable as : sched.getAppSchedulables()) {
                for (RMContainer c : as.getApp().getLiveContainers()) {
                    runningContainers.add(c);
                    apps.put(c, as.getApp());
                    queues.put(c, sched);
                }
            }
        }
        Collections.sort(runningContainers, new Comparator<RMContainer>(){

            @Override
            public int compare(RMContainer c1, RMContainer c2) {
                return c2.getContainer().getPriority().compareTo(c1.getContainer().getPriority());
            }
        });
        for (RMContainer container : runningContainers) {
            FSLeafQueue sched = (FSLeafQueue)queues.get(container);
            if (!Resources.greaterThan(sched.getResourceUsage(), sched.getFairShare())) continue;
            LOG.info((Object)("Preempting container (prio=" + container.getContainer().getPriority() + "res=" + container.getContainer().getResource() + ") from queue " + sched.getName()));
            ContainerStatus status = SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container preempted by scheduler");
            this.completedContainer(container, status, RMContainerEventType.KILL);
            if (!Resources.equals(toPreempt = Resources.subtract(toPreempt, container.getContainer().getResource()), Resources.none())) continue;
            break;
        }
    }

    protected Resource resToPreempt(FSLeafQueue sched, long curTime) {
        Resource resToPreempt;
        Resource target;
        String queue = sched.getName();
        long minShareTimeout = this.queueMgr.getMinSharePreemptionTimeout(queue);
        long fairShareTimeout = this.queueMgr.getFairSharePreemptionTimeout();
        Resource resDueToMinShare = Resources.none();
        Resource resDueToFairShare = Resources.none();
        if (curTime - sched.getLastTimeAtMinShare() > minShareTimeout) {
            target = Resources.min(sched.getMinShare(), sched.getDemand());
            resDueToMinShare = Resources.max(Resources.none(), Resources.subtract(target, sched.getResourceUsage()));
        }
        if (curTime - sched.getLastTimeAtHalfFairShare() > fairShareTimeout) {
            target = Resources.min(sched.getFairShare(), sched.getDemand());
            resDueToFairShare = Resources.max(Resources.none(), Resources.subtract(target, sched.getResourceUsage()));
        }
        if (Resources.greaterThan(resToPreempt = Resources.max(resDueToMinShare, resDueToFairShare), Resources.none())) {
            String message = "Should preempt " + resToPreempt + " res for queue " + sched.getName() + ": resDueToMinShare = " + resDueToMinShare + ", resDueToFairShare = " + resDueToFairShare;
            LOG.info((Object)message);
        }
        return resToPreempt;
    }

    private void updateRunnability() {
        ArrayList<AppSchedulable> apps = new ArrayList<AppSchedulable>();
        for (FSLeafQueue leafQueue : this.queueMgr.getLeafQueues()) {
            for (AppSchedulable a : leafQueue.getAppSchedulables()) {
                a.setRunnable(false);
                apps.add(a);
            }
        }
        Collections.sort(apps, new FifoAppComparator());
        HashMap<String, Integer> userApps = new HashMap<String, Integer>();
        HashMap<String, Integer> queueApps = new HashMap<String, Integer>();
        for (AppSchedulable app : apps) {
            int queueCount;
            String user = app.getApp().getUser();
            String queue = app.getApp().getQueueName();
            int userCount = userApps.containsKey(user) ? (Integer)userApps.get(user) : 0;
            int n = queueCount = queueApps.containsKey(queue) ? (Integer)queueApps.get(queue) : 0;
            if (userCount >= this.queueMgr.getUserMaxApps(user) || queueCount >= this.queueMgr.getQueueMaxApps(queue)) continue;
            userApps.put(user, userCount + 1);
            queueApps.put(queue, queueCount + 1);
            app.setRunnable(true);
        }
    }

    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public synchronized double getAppWeight(AppSchedulable app) {
        if (!app.getRunnable()) {
            return 1.0;
        }
        double weight = 1.0;
        if (this.sizeBasedWeight) {
            weight = Math.log1p(app.getDemand().getMemory()) / Math.log(2.0);
        }
        weight *= (double)app.getPriority().getPriority();
        if (this.weightAdjuster != null) {
            weight = this.weightAdjuster.adjustWeight(app, weight);
        }
        return weight;
    }

    @Override
    public Resource getMinimumResourceCapability() {
        return this.minimumAllocation;
    }

    @Override
    public Resource getMaximumResourceCapability() {
        return this.maximumAllocation;
    }

    public double getNodeLocalityThreshold() {
        return this.nodeLocalityThreshold;
    }

    public double getRackLocalityThreshold() {
        return this.rackLocalityThreshold;
    }

    public Resource getClusterCapacity() {
        return this.clusterCapacity;
    }

    public Clock getClock() {
        return this.clock;
    }

    protected void setClock(Clock clock) {
        this.clock = clock;
    }

    public FairSchedulerEventLog getEventLog() {
        return this.eventLog;
    }

    protected synchronized void addApplication(ApplicationAttemptId applicationAttemptId, String queueName, String user) {
        FSLeafQueue queue = this.queueMgr.getLeafQueue(queueName);
        if (queue == null) {
            queue = this.queueMgr.getLeafQueue("default");
        }
        FSSchedulerApp schedulerApp = new FSSchedulerApp(applicationAttemptId, user, queue, new ActiveUsersManager(this.getRootQueueMetrics()), this.rmContext);
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
        if (!queue.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi)) {
            LOG.info((Object)("User " + userUgi.getUserName() + " cannot submit applications to queue " + queue.getName()));
            return;
        }
        queue.addApp(schedulerApp);
        queue.getMetrics().submitApp(user, applicationAttemptId.getAttemptId());
        this.applications.put(applicationAttemptId, schedulerApp);
        LOG.info((Object)("Application Submission: " + applicationAttemptId + ", user: " + user + ", currently active: " + this.applications.size()));
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.APP_ACCEPTED));
    }

    private synchronized void removeApplication(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState) {
        LOG.info((Object)("Application " + applicationAttemptId + " is done." + " finalState=" + (Object)((Object)rmAppAttemptFinalState)));
        FSSchedulerApp application = this.applications.get(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        for (RMContainer rmContainer : application.getLiveContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : application.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
        }
        application.stop(rmAppAttemptFinalState);
        FSLeafQueue queue = this.queueMgr.getLeafQueue(application.getQueue().getQueueName());
        queue.removeApp(application);
        this.applications.remove(applicationAttemptId);
    }

    private synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        ApplicationAttemptId applicationAttemptId = container.getId().getApplicationAttemptId();
        FSSchedulerApp application = this.applications.get(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Container " + container + " of" + " unknown application " + applicationAttemptId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FSSchedulerNode node = this.nodes.get(container.getNodeId());
        if (rmContainer.getState() == RMContainerState.RESERVED) {
            application.unreserve(node, rmContainer.getReservedPriority());
            node.unreserveResource(application);
        } else {
            application.containerCompleted(rmContainer, containerStatus, event);
            node.releaseContainer(container);
        }
        LOG.info((Object)("Application " + applicationAttemptId + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void addNode(RMNode node) {
        this.nodes.put(node.getNodeID(), new FSSchedulerNode(node));
        Resources.addTo(this.clusterCapacity, node.getTotalCapability());
        LOG.info((Object)("Added node " + node.getNodeAddress() + " cluster capacity: " + this.clusterCapacity));
    }

    private synchronized void removeNode(RMNode rmNode) {
        FSSchedulerNode node = this.nodes.get(rmNode.getNodeID());
        Resources.subtractFrom(this.clusterCapacity, rmNode.getTotalCapability());
        List<RMContainer> runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(rmNode.getNodeID());
        LOG.info((Object)("Removed node " + rmNode.getNodeAddress() + " cluster capacity: " + this.clusterCapacity));
    }

    static void normalizeRequests(List<ResourceRequest> asks, int minMemory) {
        for (ResourceRequest ask : asks) {
            FairScheduler.normalizeRequest(ask, minMemory);
        }
    }

    static void normalizeRequest(ResourceRequest ask, int minMemory) {
        int memory = Math.max(ask.getCapability().getMemory(), minMemory);
        ask.getCapability().setMemory(minMemory * (memory / minMemory + (memory % minMemory > 0 ? 1 : 0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId appAttemptId, List<ResourceRequest> ask, List<ContainerId> release) {
        FSSchedulerApp application = this.applications.get(appAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + appAttemptId));
            return EMPTY_ALLOCATION;
        }
        FairScheduler.normalizeRequests(ask, this.minimumAllocation.getMemory());
        for (ContainerId releasedContainerId : release) {
            RMContainer rmContainer = this.getRMContainer(releasedContainerId);
            if (rmContainer == null) {
                RMAuditLogger.logFailure(application.getUser(), "AM Released Container", "Unauthorized access or invalid container", "FairScheduler", "Trying to release container not owned by app or with invalid id", application.getApplicationId(), releasedContainerId);
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(releasedContainerId, "Container released by application"), RMContainerEventType.RELEASED);
        }
        FSSchedulerApp fSSchedulerApp = application;
        synchronized (fSSchedulerApp) {
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + appAttemptId + " application=" + application.getApplicationId()));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                LOG.debug((Object)"allocate: post-update");
                application.showRequests();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: applicationAttemptId=" + appAttemptId + " #ask=" + ask.size()));
            }
            return new Allocation(application.pullNewlyAllocatedContainers(), application.getHeadroom());
        }
    }

    private void containerLaunchedOnNode(ContainerId containerId, FSSchedulerNode node) {
        ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
        FSSchedulerApp application = this.applications.get(applicationAttemptId);
        if (application == null) {
            LOG.info((Object)("Unknown application: " + applicationAttemptId + " launched container " + containerId + " on node: " + node));
            return;
        }
        application.containerLaunchedOnNode(containerId, node.getNodeID());
    }

    private synchronized void nodeUpdate(RMNode nm, List<ContainerStatus> newlyLaunchedContainers, List<ContainerStatus> completedContainers) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " cluster capacity: " + this.clusterCapacity));
        }
        this.eventLog.log("HEARTBEAT", nm.getHostName());
        FSSchedulerNode node = this.nodes.get(nm.getNodeID());
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            FSSchedulerApp reservedApplication = this.applications.get(reservedContainer.getApplicationAttemptId());
            LOG.info((Object)("Trying to fulfill reservation for application " + reservedApplication.getApplicationId() + " on node: " + nm));
            FSLeafQueue queue = this.queueMgr.getLeafQueue(reservedApplication.getQueueName());
            queue.assignContainer(node, true);
        } else {
            int assignedContainers = 0;
            while (node.getReservedContainer() == null) {
                ArrayList<FSLeafQueue> scheds = new ArrayList<FSLeafQueue>(this.queueMgr.getLeafQueues());
                Collections.sort(scheds, new SchedulingAlgorithms.FairShareComparator());
                boolean assignedContainer = false;
                for (FSLeafQueue sched : scheds) {
                    Resource assigned = sched.assignContainer(node, false);
                    if (!Resources.greaterThan(assigned, Resources.none()) && node.getReservedContainer() == null) continue;
                    this.eventLog.log("ASSIGN", nm.getHostName(), assigned);
                    ++assignedContainers;
                    assignedContainer = true;
                    break;
                }
                if (assignedContainer && this.assignMultiple && (assignedContainers < this.maxAssign || this.maxAssign <= 0)) continue;
                break;
            }
        }
    }

    @Override
    public SchedulerNodeReport getNodeReport(NodeId nodeId) {
        FSSchedulerNode node = this.nodes.get(nodeId);
        return node == null ? null : new SchedulerNodeReport(node);
    }

    public FSSchedulerApp getSchedulerApp(ApplicationAttemptId appAttemptId) {
        return this.applications.get(appAttemptId);
    }

    @Override
    public SchedulerAppReport getSchedulerAppInfo(ApplicationAttemptId appAttemptId) {
        if (!this.applications.containsKey(appAttemptId)) {
            LOG.error((Object)("Request for appInfo of unknown attempt" + appAttemptId));
            return null;
        }
        return new SchedulerAppReport(this.applications.get(appAttemptId));
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.rootMetrics;
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                if (!(event instanceof NodeAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                if (!(event instanceof NodeRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                if (!(event instanceof NodeUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode(), nodeUpdatedEvent.getNewlyLaunchedContainers(), nodeUpdatedEvent.getCompletedContainers());
                break;
            }
            case APP_ADDED: {
                String def;
                if (!(event instanceof AppAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                String queue = appAddedEvent.getQueue();
                if (queue.equals(def = "default") && this.userAsDefaultQueue) {
                    queue = appAddedEvent.getUser();
                }
                this.addApplication(appAddedEvent.getApplicationAttemptId(), queue, appAddedEvent.getUser());
                break;
            }
            case APP_REMOVED: {
                if (!(event instanceof AppRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.removeApplication(appRemovedEvent.getApplicationAttemptID(), appRemovedEvent.getFinalAttemptState());
                break;
            }
            case CONTAINER_EXPIRED: {
                if (!(event instanceof ContainerExpiredSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            default: {
                LOG.error((Object)("Unknown event arrived at FairScheduler: " + event.toString()));
            }
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public synchronized void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        if (!this.initialized) {
            this.conf = new FairSchedulerConfiguration(conf);
            this.rootMetrics = QueueMetrics.forQueue("root", null, true, conf);
            this.rmContext = rmContext;
            this.eventLog = new FairSchedulerEventLog();
            this.eventLog.init(this.conf);
            this.minimumAllocation = this.conf.getMinimumMemoryAllocation();
            this.maximumAllocation = this.conf.getMaximumMemoryAllocation();
            this.userAsDefaultQueue = this.conf.getUserAsDefaultQueue();
            this.nodeLocalityThreshold = this.conf.getLocalityThresholdNode();
            this.rackLocalityThreshold = this.conf.getLocalityThresholdRack();
            this.preemptionEnabled = this.conf.getPreemptionEnabled();
            this.assignMultiple = this.conf.getAssignMultiple();
            this.maxAssign = this.conf.getMaxAssign();
            this.initialized = true;
            this.sizeBasedWeight = this.conf.getSizeBasedWeight();
            try {
                this.queueMgr.initialize();
            }
            catch (Exception e) {
                throw new IOException("Failed to start FairScheduler", e);
            }
            Thread updateThread = new Thread(new UpdateThread());
            updateThread.setName("FairSchedulerUpdateThread");
            updateThread.setDaemon(true);
            updateThread.start();
        } else {
            this.conf = new FairSchedulerConfiguration(conf);
            this.userAsDefaultQueue = this.conf.getUserAsDefaultQueue();
            this.nodeLocalityThreshold = this.conf.getLocalityThresholdNode();
            this.rackLocalityThreshold = this.conf.getLocalityThresholdRack();
            this.preemptionEnabled = this.conf.getPreemptionEnabled();
            try {
                this.queueMgr.reloadAllocs();
            }
            catch (Exception e) {
                throw new IOException("Failed to initialize FairScheduler", e);
            }
        }
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        if (!this.queueMgr.exists(queueName)) {
            return null;
        }
        return this.queueMgr.getQueue(queueName).getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user = null;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.queueMgr.getRootQueue().getQueueUserAclInfo(user);
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodes.size();
    }

    private class UpdateThread
    implements Runnable {
        private UpdateThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(FairScheduler.this.UPDATE_INTERVAL);
                        FairScheduler.this.update();
                        FairScheduler.this.preemptTasksIfNecessary();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in fair scheduler UpdateThread", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

