/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryRMStateStore
extends RMStateStore {
    RMStateStore.RMState state = new RMStateStore.RMState();

    @VisibleForTesting
    public RMStateStore.RMState getState() {
        return this.state;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState returnState = new RMStateStore.RMState();
        returnState.appState.putAll(this.state.appState);
        returnState.rmSecretManagerState.getMasterKeyState().addAll(this.state.rmSecretManagerState.getMasterKeyState());
        returnState.rmSecretManagerState.getTokenState().putAll(this.state.rmSecretManagerState.getTokenState());
        returnState.rmSecretManagerState.dtSequenceNumber = this.state.rmSecretManagerState.dtSequenceNumber;
        return returnState;
    }

    @Override
    public synchronized void initInternal(Configuration conf) {
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
    }

    @Override
    public void storeApplicationState(String appId, ApplicationStateDataPBImpl appStateData) throws Exception {
        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser());
        if (this.state.appState.containsKey(appState.getAppId())) {
            IOException e = new IOException("App: " + appId + " is already stored.");
            LOG.info((Object)("Error storing info for app: " + appId), (Throwable)e);
            throw e;
        }
        this.state.appState.put(appState.getAppId(), appState);
    }

    @Override
    public synchronized void storeApplicationAttemptState(String attemptIdStr, ApplicationAttemptStateDataPBImpl attemptStateData) throws Exception {
        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)attemptIdStr);
        Credentials credentials = null;
        if (attemptStateData.getAppAttemptTokens() != null) {
            DataInputByteBuffer dibb = new DataInputByteBuffer();
            credentials = new Credentials();
            dibb.reset(new ByteBuffer[]{attemptStateData.getAppAttemptTokens()});
            credentials.readTokenStorageStream((DataInputStream)dibb);
        }
        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer(), credentials);
        RMStateStore.ApplicationState appState = this.state.getApplicationState().get(attemptState.getAttemptId().getApplicationId());
        assert (appState != null);
        if (appState.attempts.containsKey(attemptState.getAttemptId())) {
            IOException e = new IOException("Attempt: " + attemptState.getAttemptId() + " is already stored.");
            LOG.info((Object)("Error storing info for attempt: " + attemptState.getAttemptId()), (Throwable)e);
            throw e;
        }
        appState.attempts.put(attemptState.getAttemptId(), attemptState);
    }

    @Override
    public synchronized void removeApplicationState(RMStateStore.ApplicationState appState) throws Exception {
        ApplicationId appId = appState.getAppId();
        RMStateStore.ApplicationState removed = this.state.appState.remove(appId);
        assert (removed != null);
    }

    @Override
    public synchronized void storeRMDelegationTokenAndSequenceNumberState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate, int latestSequenceNumber) throws Exception {
        Map<RMDelegationTokenIdentifier, Long> rmDTState = this.state.rmSecretManagerState.getTokenState();
        if (rmDTState.containsKey(rmDTIdentifier)) {
            IOException e = new IOException("RMDelegationToken: " + rmDTIdentifier + "is already stored.");
            LOG.info((Object)("Error storing info for RMDelegationToken: " + rmDTIdentifier), (Throwable)e);
            throw e;
        }
        rmDTState.put(rmDTIdentifier, renewDate);
        this.state.rmSecretManagerState.dtSequenceNumber = latestSequenceNumber;
    }

    @Override
    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier) throws Exception {
        Map<RMDelegationTokenIdentifier, Long> rmDTState = this.state.rmSecretManagerState.getTokenState();
        rmDTState.remove(rmDTIdentifier);
    }

    @Override
    public synchronized void storeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        Set<DelegationKey> rmDTMasterKeyState = this.state.rmSecretManagerState.getMasterKeyState();
        if (rmDTMasterKeyState.contains(delegationKey)) {
            IOException e = new IOException("RMDTMasterKey with keyID: " + delegationKey.getKeyId() + " is already stored");
            LOG.info((Object)("Error storing info for RMDTMasterKey with keyID: " + delegationKey.getKeyId()), (Throwable)e);
            throw e;
        }
        this.state.getRMDTSecretManagerState().getMasterKeyState().add(delegationKey);
        LOG.info((Object)("rmDTMasterKeyState SIZE: " + rmDTMasterKeyState.size()));
    }

    @Override
    public synchronized void removeRMDTMasterKeyState(DelegationKey delegationKey) throws Exception {
        Set<DelegationKey> rmDTMasterKeyState = this.state.rmSecretManagerState.getMasterKeyState();
        rmDTMasterKeyState.remove(delegationKey);
    }
}

