/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.resource;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;

public class DefaultResourceCalculator
extends ResourceCalculator {
    Resource clusterResource;

    @Override
    public int compare(Resource unused, Resource lhs, Resource rhs) {
        return lhs.getMemory() - rhs.getMemory();
    }

    @Override
    public int computeAvailableContainers(Resource available, Resource required) {
        return available.getMemory() / required.getMemory();
    }

    @Override
    public float divide(Resource unused, Resource numerator, Resource denominator) {
        return this.ratio(numerator, denominator);
    }

    @Override
    public float ratio(Resource a, Resource b) {
        return (float)a.getMemory() / (float)b.getMemory();
    }

    @Override
    public Resource divideAndCeil(Resource numerator, int denominator) {
        return Resources.createResource(DefaultResourceCalculator.divideAndCeil(numerator.getMemory(), denominator));
    }

    @Override
    public Resource normalize(Resource r, Resource minimumResource, Resource maximumResource) {
        int normalizedMemory = Math.min(DefaultResourceCalculator.roundUp(Math.max(r.getMemory(), minimumResource.getMemory()), minimumResource.getMemory()), maximumResource.getMemory());
        return Resources.createResource(normalizedMemory);
    }

    @Override
    public Resource roundUp(Resource r, Resource minimumResource) {
        return Resources.createResource(DefaultResourceCalculator.roundUp(r.getMemory(), minimumResource.getMemory()));
    }

    @Override
    public Resource roundDown(Resource r, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown(r.getMemory(), stepFactor.getMemory()));
    }

    @Override
    public Resource multiplyAndNormalizeUp(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundUp((int)((double)r.getMemory() * by + 0.5), stepFactor.getMemory()));
    }

    @Override
    public Resource multiplyAndNormalizeDown(Resource r, double by, Resource stepFactor) {
        return Resources.createResource(DefaultResourceCalculator.roundDown((int)((double)r.getMemory() * by), stepFactor.getMemory()));
    }
}

