/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.rmapp;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ClientToken;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.client.ClientTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFailedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppFinishedAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppNodeUpdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppRejectedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppStoredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.state.InvalidStateTransitonException;
import org.apache.hadoop.yarn.state.MultipleArcTransition;
import org.apache.hadoop.yarn.state.SingleArcTransition;
import org.apache.hadoop.yarn.state.StateMachine;
import org.apache.hadoop.yarn.state.StateMachineFactory;
import org.apache.hadoop.yarn.util.BuilderUtils;

public class RMAppImpl
implements RMApp,
Recoverable {
    private static final Log LOG = LogFactory.getLog(RMAppImpl.class);
    private static final String UNAVAILABLE = "N/A";
    private final ApplicationId applicationId;
    private final RMContext rmContext;
    private final Configuration conf;
    private final String user;
    private final String queue;
    private final String name;
    private final ApplicationSubmissionContext submissionContext;
    private final Dispatcher dispatcher;
    private final YarnScheduler scheduler;
    private final ApplicationMasterService masterService;
    private final StringBuilder diagnostics = new StringBuilder();
    private final int maxAppAttempts;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Map<ApplicationAttemptId, RMAppAttempt> attempts = new LinkedHashMap<ApplicationAttemptId, RMAppAttempt>();
    private final long submitTime;
    private final Set<RMNode> updatedNodes = new HashSet<RMNode>();
    private final String applicationType;
    private long startTime;
    private long finishTime;
    private RMAppAttempt currentAttempt;
    private EventHandler handler;
    private static final FinalTransition FINAL_TRANSITION = new FinalTransition();
    private static final AppFinishedTransition FINISHED_TRANSITION = new AppFinishedTransition();
    private static final StateMachineFactory<RMAppImpl, RMAppState, RMAppEventType, RMAppEvent> stateMachineFactory = new StateMachineFactory((Enum)RMAppState.NEW).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.NEW, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.NEW_SAVING, (Enum)RMAppEventType.START, (SingleArcTransition)new RMAppSavingTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.RECOVER, (SingleArcTransition)new StartAppAttemptTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new AppKilledTransition()).addTransition((Enum)RMAppState.NEW, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.NEW_SAVING, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.APP_SAVED, (SingleArcTransition)new StartAppAttemptTransition()).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new AppKilledTransition()).addTransition((Enum)RMAppState.NEW_SAVING, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.SUBMITTED, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.APP_REJECTED, (SingleArcTransition)new AppRejectedTransition()).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.APP_ACCEPTED).addTransition((Enum)RMAppState.SUBMITTED, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAppAndAttemptTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.ACCEPTED, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.ATTEMPT_REGISTERED).addTransition((Enum)RMAppState.ACCEPTED, EnumSet.of(RMAppState.SUBMITTED, RMAppState.FAILED), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.SUBMITTED)).addTransition((Enum)RMAppState.ACCEPTED, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAppAndAttemptTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.RUNNING, (Enum)RMAppEventType.NODE_UPDATE, (SingleArcTransition)new RMAppNodeUpdateTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.FINISHING, (Enum)RMAppEventType.ATTEMPT_FINISHING, (SingleArcTransition)new RMAppFinishingTransition()).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINISHED_TRANSITION).addTransition((Enum)RMAppState.RUNNING, EnumSet.of(RMAppState.SUBMITTED, RMAppState.FAILED), (Enum)RMAppEventType.ATTEMPT_FAILED, (MultipleArcTransition)new AttemptFailedTransition(RMAppState.SUBMITTED)).addTransition((Enum)RMAppState.RUNNING, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAppAndAttemptTransition()).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.ATTEMPT_FINISHED, (SingleArcTransition)FINISHED_TRANSITION).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.KILL, (SingleArcTransition)new KillAppAndAttemptTransition()).addTransition((Enum)RMAppState.FINISHING, (Enum)RMAppState.FINISHING, (Enum)RMAppEventType.NODE_UPDATE).addTransition((Enum)RMAppState.FINISHED, (Enum)RMAppState.FINISHED, (Enum)RMAppEventType.KILL).addTransition((Enum)RMAppState.FINISHED, (Enum)RMAppState.FINISHED, EnumSet.of(RMAppEventType.NODE_UPDATE, RMAppEventType.ATTEMPT_FINISHING, RMAppEventType.ATTEMPT_FINISHED)).addTransition((Enum)RMAppState.FAILED, (Enum)RMAppState.FAILED, EnumSet.of(RMAppEventType.KILL, RMAppEventType.APP_SAVED)).addTransition((Enum)RMAppState.FAILED, (Enum)RMAppState.FAILED, (Enum)RMAppEventType.NODE_UPDATE).addTransition((Enum)RMAppState.KILLED, (Enum)RMAppState.KILLED, EnumSet.of(RMAppEventType.APP_ACCEPTED, new RMAppEventType[]{RMAppEventType.APP_REJECTED, RMAppEventType.KILL, RMAppEventType.ATTEMPT_FINISHED, RMAppEventType.ATTEMPT_FAILED, RMAppEventType.ATTEMPT_KILLED, RMAppEventType.APP_SAVED})).addTransition((Enum)RMAppState.KILLED, (Enum)RMAppState.KILLED, (Enum)RMAppEventType.NODE_UPDATE).installTopology();
    private final StateMachine<RMAppState, RMAppEventType, RMAppEvent> stateMachine;
    private static final ApplicationResourceUsageReport DUMMY_APPLICATION_RESOURCE_USAGE_REPORT = BuilderUtils.newApplicationResourceUsageReport((int)-1, (int)-1, (Resource)Resources.createResource(-1, -1), (Resource)Resources.createResource(-1, -1), (Resource)Resources.createResource(-1, -1));
    private static final int DUMMY_APPLICATION_ATTEMPT_NUMBER = -1;

    public RMAppImpl(ApplicationId applicationId, RMContext rmContext, Configuration config, String name, String user, String queue, ApplicationSubmissionContext submissionContext, YarnScheduler scheduler, ApplicationMasterService masterService, long submitTime, String applicationType) {
        this.applicationId = applicationId;
        this.name = name;
        this.rmContext = rmContext;
        this.dispatcher = rmContext.getDispatcher();
        this.handler = this.dispatcher.getEventHandler();
        this.conf = config;
        this.user = user;
        this.queue = queue;
        this.submissionContext = submissionContext;
        this.scheduler = scheduler;
        this.masterService = masterService;
        this.submitTime = submitTime;
        this.startTime = System.currentTimeMillis();
        this.applicationType = applicationType;
        int globalMaxAppAttempts = this.conf.getInt("yarn.resourcemanager.am.max-attempts", 2);
        int individualMaxAppAttempts = submissionContext.getMaxAppAttempts();
        if (individualMaxAppAttempts <= 0 || individualMaxAppAttempts > globalMaxAppAttempts) {
            this.maxAppAttempts = globalMaxAppAttempts;
            LOG.warn((Object)("The specific max attempts: " + individualMaxAppAttempts + " for application: " + applicationId.getId() + " is invalid, because it is out of the range [1, " + globalMaxAppAttempts + "]. Use the global max attempts instead."));
        } else {
            this.maxAppAttempts = individualMaxAppAttempts;
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.stateMachine = stateMachineFactory.make((Object)this);
    }

    @Override
    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    @Override
    public ApplicationSubmissionContext getApplicationSubmissionContext() {
        return this.submissionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinalApplicationStatus getFinalApplicationStatus() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null && this.currentAttempt.getFinalApplicationStatus() != null) {
                FinalApplicationStatus finalApplicationStatus = this.currentAttempt.getFinalApplicationStatus();
                return finalApplicationStatus;
            }
            FinalApplicationStatus finalApplicationStatus = this.createFinalApplicationStatus((RMAppState)this.stateMachine.getCurrentState());
            return finalApplicationStatus;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppState getState() {
        this.readLock.lock();
        try {
            RMAppState rMAppState = (RMAppState)this.stateMachine.getCurrentState();
            return rMAppState;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getUser() {
        return this.user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getProgress() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                float f = this.currentAttempt.getProgress();
                return f;
            }
            float f = 0.0f;
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttempt getRMAppAttempt(ApplicationAttemptId appAttemptId) {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.attempts.get(appAttemptId);
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMAppAttempt getCurrentAppAttempt() {
        this.readLock.lock();
        try {
            RMAppAttempt rMAppAttempt = this.currentAttempt;
            return rMAppAttempt;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ApplicationAttemptId, RMAppAttempt> getAppAttempts() {
        this.readLock.lock();
        try {
            Map<ApplicationAttemptId, RMAppAttempt> map = Collections.unmodifiableMap(this.attempts);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private YarnApplicationState createApplicationState(RMAppState rmAppState) {
        switch (rmAppState) {
            case NEW: {
                return YarnApplicationState.NEW;
            }
            case NEW_SAVING: {
                return YarnApplicationState.NEW_SAVING;
            }
            case SUBMITTED: {
                return YarnApplicationState.SUBMITTED;
            }
            case ACCEPTED: {
                return YarnApplicationState.ACCEPTED;
            }
            case RUNNING: {
                return YarnApplicationState.RUNNING;
            }
            case FINISHING: 
            case FINISHED: {
                return YarnApplicationState.FINISHED;
            }
            case KILLED: {
                return YarnApplicationState.KILLED;
            }
            case FAILED: {
                return YarnApplicationState.FAILED;
            }
        }
        throw new YarnException("Unknown state passed!");
    }

    private FinalApplicationStatus createFinalApplicationStatus(RMAppState state) {
        switch (state) {
            case NEW: 
            case NEW_SAVING: 
            case SUBMITTED: 
            case ACCEPTED: 
            case RUNNING: {
                return FinalApplicationStatus.UNDEFINED;
            }
            case FINISHING: 
            case FINISHED: 
            case FAILED: {
                return FinalApplicationStatus.FAILED;
            }
            case KILLED: {
                return FinalApplicationStatus.KILLED;
            }
        }
        throw new YarnException("Unknown state passed!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int pullRMNodeUpdates(Collection<RMNode> updatedNodes) {
        this.writeLock.lock();
        try {
            int updatedNodeCount = this.updatedNodes.size();
            updatedNodes.addAll(this.updatedNodes);
            this.updatedNodes.clear();
            int n = updatedNodeCount;
            return n;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationReport createAndGetApplicationReport(boolean allowAccess) {
        this.readLock.lock();
        try {
            ApplicationAttemptId currentApplicationAttemptId = null;
            ClientToken clientToken = null;
            String trackingUrl = UNAVAILABLE;
            String host = UNAVAILABLE;
            String origTrackingUrl = UNAVAILABLE;
            int rpcPort = -1;
            ApplicationResourceUsageReport appUsageReport = DUMMY_APPLICATION_RESOURCE_USAGE_REPORT;
            FinalApplicationStatus finishState = this.getFinalApplicationStatus();
            String diags = UNAVAILABLE;
            float progress = 0.0f;
            if (allowAccess) {
                if (this.currentAttempt != null) {
                    currentApplicationAttemptId = this.currentAttempt.getAppAttemptId();
                    trackingUrl = this.currentAttempt.getTrackingUrl();
                    origTrackingUrl = this.currentAttempt.getOriginalTrackingUrl();
                    Token<ClientTokenIdentifier> attemptClientToken = this.currentAttempt.getClientToken();
                    if (attemptClientToken != null) {
                        clientToken = BuilderUtils.newClientToken((byte[])attemptClientToken.getIdentifier(), (String)attemptClientToken.getKind().toString(), (byte[])attemptClientToken.getPassword(), (String)attemptClientToken.getService().toString());
                    }
                    host = this.currentAttempt.getHost();
                    rpcPort = this.currentAttempt.getRpcPort();
                    appUsageReport = this.currentAttempt.getApplicationResourceUsageReport();
                    progress = this.currentAttempt.getProgress();
                }
                diags = this.diagnostics.toString();
            }
            if (currentApplicationAttemptId == null) {
                currentApplicationAttemptId = BuilderUtils.newApplicationAttemptId((ApplicationId)this.applicationId, (int)-1);
            }
            ApplicationReport applicationReport = BuilderUtils.newApplicationReport((ApplicationId)this.applicationId, (ApplicationAttemptId)currentApplicationAttemptId, (String)this.user, (String)this.queue, (String)this.name, (String)host, (int)rpcPort, (ClientToken)clientToken, (YarnApplicationState)this.createApplicationState((RMAppState)this.stateMachine.getCurrentState()), (String)diags, (String)trackingUrl, (long)this.startTime, (long)this.finishTime, (FinalApplicationStatus)finishState, (ApplicationResourceUsageReport)appUsageReport, (String)origTrackingUrl, (float)progress, (String)this.applicationType);
            return applicationReport;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFinishTime() {
        this.readLock.lock();
        try {
            long l = this.finishTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getStartTime() {
        this.readLock.lock();
        try {
            long l = this.startTime;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public long getSubmitTime() {
        return this.submitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTrackingUrl() {
        this.readLock.lock();
        try {
            if (this.currentAttempt != null) {
                String string = this.currentAttempt.getTrackingUrl();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuilder getDiagnostics() {
        this.readLock.lock();
        try {
            StringBuilder stringBuilder = this.diagnostics;
            return stringBuilder;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int getMaxAppAttempts() {
        return this.maxAppAttempts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(RMAppEvent event) {
        this.writeLock.lock();
        try {
            ApplicationId appID = event.getApplicationId();
            LOG.debug((Object)("Processing event for " + appID + " of type " + event.getType()));
            RMAppState oldState = this.getState();
            try {
                this.stateMachine.doTransition(event.getType(), (Object)event);
            }
            catch (InvalidStateTransitonException e) {
                LOG.error((Object)"Can't handle this event at current state", (Throwable)e);
            }
            if (oldState != this.getState()) {
                LOG.info((Object)(appID + " State change from " + (Object)((Object)oldState) + " to " + (Object)((Object)this.getState())));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void recover(RMStateStore.RMState state) {
        RMStateStore.ApplicationState appState = state.getApplicationState().get(this.getApplicationId());
        LOG.info((Object)("Recovering app: " + this.getApplicationId() + " with " + appState.getAttemptCount() + " attempts"));
        for (int i = 0; i < appState.getAttemptCount(); ++i) {
            this.createNewAttempt(false);
            ((RMAppAttemptImpl)this.currentAttempt).recover(state);
        }
    }

    private void createNewAttempt(boolean startAttempt) {
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)this.applicationId, (int)(this.attempts.size() + 1));
        RMAppAttemptImpl attempt = new RMAppAttemptImpl(appAttemptId, this.rmContext, this.scheduler, this.masterService, this.submissionContext, this.conf, this.user);
        this.attempts.put(appAttemptId, attempt);
        this.currentAttempt = attempt;
        if (startAttempt) {
            this.handler.handle((Event)new RMAppAttemptEvent(appAttemptId, RMAppAttemptEventType.START));
        }
    }

    private void processNodeUpdate(RMAppNodeUpdateEvent.RMAppNodeUpdateType type, RMNode node) {
        NodeState nodeState = node.getState();
        this.updatedNodes.add(node);
        LOG.debug((Object)("Received node update event:" + (Object)((Object)type) + " for node:" + node + " with state:" + nodeState));
    }

    @Override
    public String getApplicationType() {
        return this.applicationType;
    }

    private static final class AttemptFailedTransition
    implements MultipleArcTransition<RMAppImpl, RMAppEvent, RMAppState> {
        private final RMAppState initialState;

        public AttemptFailedTransition(RMAppState initialState) {
            this.initialState = initialState;
        }

        public RMAppState transition(RMAppImpl app, RMAppEvent event) {
            RMAppFailedAttemptEvent failedEvent = (RMAppFailedAttemptEvent)event;
            boolean retryApp = true;
            String msg = null;
            if (app.submissionContext.getUnmanagedAM()) {
                retryApp = false;
                msg = "Unmanaged application " + app.getApplicationId() + " failed due to " + failedEvent.getDiagnostics() + ". Failing the application.";
            } else if (app.attempts.size() >= app.maxAppAttempts) {
                retryApp = false;
                msg = "Application " + app.getApplicationId() + " failed " + app.maxAppAttempts + " times due to " + failedEvent.getDiagnostics() + ". Failing the application.";
            }
            if (retryApp) {
                app.createNewAttempt(true);
                return this.initialState;
            }
            LOG.info(msg);
            app.diagnostics.append(msg);
            FINAL_TRANSITION.transition(app, event);
            return RMAppState.FAILED;
        }
    }

    private static class FinalTransition
    extends RMAppTransition {
        private FinalTransition() {
        }

        private Set<NodeId> getNodesOnWhichAttemptRan(RMAppImpl app) {
            HashSet<NodeId> nodes = new HashSet<NodeId>();
            for (RMAppAttempt attempt : app.attempts.values()) {
                nodes.addAll(attempt.getRanNodes());
            }
            return nodes;
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            Set<NodeId> nodes = this.getNodesOnWhichAttemptRan(app);
            for (NodeId nodeId : nodes) {
                app.handler.handle((Event)new RMNodeCleanAppEvent(nodeId, app.applicationId));
            }
            if (app.getState() != RMAppState.FINISHING) {
                app.finishTime = System.currentTimeMillis();
            }
            app.handler.handle((Event)new RMAppManagerEvent(app.applicationId, RMAppManagerEventType.APP_COMPLETED));
        }
    }

    private static final class AppRejectedTransition
    extends FinalTransition {
        private AppRejectedTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppRejectedEvent rejectedEvent = (RMAppRejectedEvent)event;
            app.diagnostics.append(rejectedEvent.getMessage());
            super.transition(app, event);
        }
    }

    private static class KillAppAndAttemptTransition
    extends AppKilledTransition {
        private KillAppAndAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.handler.handle((Event)new RMAppAttemptEvent(app.currentAttempt.getAppAttemptId(), RMAppAttemptEventType.KILL));
            super.transition(app, event);
        }
    }

    private static class AppKilledTransition
    extends FinalTransition {
        private AppKilledTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.diagnostics.append("Application killed by user.");
            super.transition(app, event);
        }
    }

    private static class AppFinishedTransition
    extends FinalTransition {
        private AppFinishedTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppFinishedAttemptEvent finishedEvent = (RMAppFinishedAttemptEvent)event;
            app.diagnostics.append(finishedEvent.getDiagnostics());
            super.transition(app, event);
        }
    }

    private static final class RMAppSavingTransition
    extends RMAppTransition {
        private RMAppSavingTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            LOG.info((Object)("Storing application with id " + app.applicationId));
            app.rmContext.getStateStore().storeApplication(app);
        }
    }

    private static final class RMAppFinishingTransition
    extends RMAppTransition {
        private RMAppFinishingTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            app.finishTime = System.currentTimeMillis();
        }
    }

    private static final class StartAppAttemptTransition
    extends RMAppTransition {
        private StartAppAttemptTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            if (((RMAppEventType)event.getType()).equals((Object)RMAppEventType.APP_SAVED)) {
                assert (app.getState().equals((Object)RMAppState.NEW_SAVING));
                RMAppStoredEvent storeEvent = (RMAppStoredEvent)event;
                if (storeEvent.getStoredException() != null) {
                    LOG.error((Object)("Failed to store application: " + storeEvent.getApplicationId()), (Throwable)storeEvent.getStoredException());
                    ExitUtil.terminate((int)1, (Throwable)storeEvent.getStoredException());
                }
            }
            app.createNewAttempt(true);
        }
    }

    private static final class RMAppNodeUpdateTransition
    extends RMAppTransition {
        private RMAppNodeUpdateTransition() {
        }

        @Override
        public void transition(RMAppImpl app, RMAppEvent event) {
            RMAppNodeUpdateEvent nodeUpdateEvent = (RMAppNodeUpdateEvent)event;
            app.processNodeUpdate(nodeUpdateEvent.getUpdateType(), nodeUpdateEvent.getNode());
        }
    }

    private static class RMAppTransition
    implements SingleArcTransition<RMAppImpl, RMAppEvent> {
        private RMAppTransition() {
        }

        public void transition(RMAppImpl app, RMAppEvent event) {
        }
    }
}

