/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.File;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FairSchedulerConfiguration
extends Configuration {
    public static final String FS_CONFIGURATION_FILE = "fair-scheduler.xml";
    private static final String CONF_PREFIX = "yarn.scheduler.fair.";
    protected static final String ALLOCATION_FILE = "yarn.scheduler.fair.allocation.file";
    protected static final String EVENT_LOG_DIR = "eventlog.dir";
    protected static final String USER_AS_DEFAULT_QUEUE = "yarn.scheduler.fair.user-as-default-queue";
    protected static final boolean DEFAULT_USER_AS_DEFAULT_QUEUE = true;
    protected static final float DEFAULT_LOCALITY_THRESHOLD = -1.0f;
    protected static final String LOCALITY_THRESHOLD_NODE = "yarn.scheduler.fair.locality.threshold.node";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_NODE = -1.0f;
    protected static final String LOCALITY_THRESHOLD_RACK = "yarn.scheduler.fair.locality.threshold.rack";
    protected static final float DEFAULT_LOCALITY_THRESHOLD_RACK = -1.0f;
    protected static final String PREEMPTION = "yarn.scheduler.fair.preemption";
    protected static final boolean DEFAULT_PREEMPTION = false;
    protected static final String PREEMPTION_INTERVAL = "yarn.scheduler.fair.preemptionInterval";
    protected static final int DEFAULT_PREEMPTION_INTERVAL = 5000;
    protected static final String WAIT_TIME_BEFORE_KILL = "yarn.scheduler.fair.waitTimeBeforeKill";
    protected static final int DEFAULT_WAIT_TIME_BEFORE_KILL = 15000;
    protected static final String ASSIGN_MULTIPLE = "yarn.scheduler.fair.assignmultiple";
    protected static final boolean DEFAULT_ASSIGN_MULTIPLE = false;
    protected static final String SIZE_BASED_WEIGHT = "yarn.scheduler.fair.sizebasedweight";
    protected static final boolean DEFAULT_SIZE_BASED_WEIGHT = false;
    protected static final String MAX_ASSIGN = "yarn.scheduler.fair.max.assign";
    protected static final int DEFAULT_MAX_ASSIGN = -1;

    public FairSchedulerConfiguration(Configuration conf) {
        super(conf);
        this.addResource(FS_CONFIGURATION_FILE);
    }

    public Resource getMinimumMemoryAllocation() {
        int mem = this.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        return Resources.createResource(mem);
    }

    public Resource getMaximumMemoryAllocation() {
        int mem = this.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        return Resources.createResource(mem);
    }

    public boolean getUserAsDefaultQueue() {
        return this.getBoolean(USER_AS_DEFAULT_QUEUE, true);
    }

    public float getLocalityThresholdNode() {
        return this.getFloat(LOCALITY_THRESHOLD_NODE, -1.0f);
    }

    public float getLocalityThresholdRack() {
        return this.getFloat(LOCALITY_THRESHOLD_RACK, -1.0f);
    }

    public boolean getPreemptionEnabled() {
        return this.getBoolean(PREEMPTION, false);
    }

    public boolean getAssignMultiple() {
        return this.getBoolean(ASSIGN_MULTIPLE, false);
    }

    public int getMaxAssign() {
        return this.getInt(MAX_ASSIGN, -1);
    }

    public boolean getSizeBasedWeight() {
        return this.getBoolean(SIZE_BASED_WEIGHT, false);
    }

    public String getAllocationFile() {
        return this.get(ALLOCATION_FILE);
    }

    public String getEventlogDir() {
        return this.get(EVENT_LOG_DIR, new File(System.getProperty("hadoop.log.dir", "/tmp/")).getAbsolutePath() + File.separator + "fairscheduler");
    }

    public int getPreemptionInterval() {
        return this.getInt(PREEMPTION_INTERVAL, 5000);
    }

    public int getWaitTimeBeforeKill() {
        return this.getInt(WAIT_TIME_BEFORE_KILL, 15000);
    }
}

