/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.resource.DefaultResourceCalculator;
import org.apache.hadoop.yarn.server.resourcemanager.resource.Resources;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FairSharePolicy
extends SchedulingPolicy {
    @VisibleForTesting
    public static final String NAME = "Fairshare";
    private static final DefaultResourceCalculator RESOURCE_CALCULATOR = new DefaultResourceCalculator();
    private FairShareComparator comparator = new FairShareComparator();
    private static final int COMPUTE_FAIR_SHARES_ITERATIONS = 25;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        return this.comparator;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        FairSharePolicy.computeFairShares(schedulables, totalResources);
    }

    public static void computeFairShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        Resource totalDemand = Resources.createResource(0);
        for (Schedulable schedulable : schedulables) {
            Resources.addTo(totalDemand, schedulable.getDemand());
        }
        Resource cap = Resources.min(RESOURCE_CALCULATOR, null, totalDemand, totalResources);
        double d = 1.0;
        while (Resources.lessThan(RESOURCE_CALCULATOR, null, FairSharePolicy.resUsedWithWeightToResRatio(d, schedulables), cap)) {
            d *= 2.0;
        }
        double left = 0.0;
        double right = d;
        for (int i = 0; i < 25; ++i) {
            double d2 = (left + right) / 2.0;
            if (Resources.lessThan(RESOURCE_CALCULATOR, null, FairSharePolicy.resUsedWithWeightToResRatio(d2, schedulables), cap)) {
                left = d2;
                continue;
            }
            right = d2;
        }
        for (Schedulable schedulable : schedulables) {
            schedulable.setFairShare(FairSharePolicy.computeShare(schedulable, right));
        }
    }

    private static Resource resUsedWithWeightToResRatio(double w2sRatio, Collection<? extends Schedulable> schedulables) {
        Resource slotsTaken = Resources.createResource(0);
        for (Schedulable schedulable : schedulables) {
            Resource share = FairSharePolicy.computeShare(schedulable, w2sRatio);
            Resources.addTo(slotsTaken, share);
        }
        return slotsTaken;
    }

    private static Resource computeShare(Schedulable sched, double r2sRatio) {
        double share = sched.getWeight() * r2sRatio;
        share = Math.max(share, (double)sched.getMinShare().getMemory());
        share = Math.min(share, (double)sched.getDemand().getMemory());
        return Resources.createResource((int)share);
    }

    @Override
    public byte getApplicableDepth() {
        return 7;
    }

    private static class FairShareComparator
    implements Comparator<Schedulable>,
    Serializable {
        private static final long serialVersionUID = 5564969375856699313L;

        private FairShareComparator() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            Resource minShare1 = Resources.min(RESOURCE_CALCULATOR, null, s1.getMinShare(), s1.getDemand());
            Resource minShare2 = Resources.min(RESOURCE_CALCULATOR, null, s2.getMinShare(), s2.getDemand());
            boolean s1Needy = Resources.lessThan(RESOURCE_CALCULATOR, null, s1.getResourceUsage(), minShare1);
            boolean s2Needy = Resources.lessThan(RESOURCE_CALCULATOR, null, s2.getResourceUsage(), minShare2);
            Resource one = Resources.createResource(1);
            double minShareRatio1 = (double)s1.getResourceUsage().getMemory() / (double)Resources.max(RESOURCE_CALCULATOR, null, minShare1, one).getMemory();
            double minShareRatio2 = (double)s2.getResourceUsage().getMemory() / (double)Resources.max(RESOURCE_CALCULATOR, null, minShare2, one).getMemory();
            double useToWeightRatio1 = (double)s1.getResourceUsage().getMemory() / s1.getWeight();
            double useToWeightRatio2 = (double)s2.getResourceUsage().getMemory() / s2.getWeight();
            int res = 0;
            res = s1Needy && !s2Needy ? -1 : (s2Needy && !s1Needy ? 1 : (s1Needy && s2Needy ? (int)Math.signum(minShareRatio1 - minShareRatio2) : (int)Math.signum(useToWeightRatio1 - useToWeightRatio2)));
            if (res == 0 && (res = (int)Math.signum(s1.getStartTime() - s2.getStartTime())) == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

