/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerFinishedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AppSchedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FSSchedulerApp
extends SchedulerApplication {
    private static final Log LOG = LogFactory.getLog(FSSchedulerApp.class);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final AppSchedulingInfo appSchedulingInfo;
    private AppSchedulable appSchedulable;
    private final Queue queue;
    private final Resource currentConsumption = (Resource)this.recordFactory.newRecordInstance(Resource.class);
    private Resource resourceLimit = (Resource)this.recordFactory.newRecordInstance(Resource.class);
    private Map<ContainerId, RMContainer> liveContainers = new HashMap<ContainerId, RMContainer>();
    private List<RMContainer> newlyAllocatedContainers = new ArrayList<RMContainer>();
    final Map<Priority, Map<NodeId, RMContainer>> reservedContainers = new HashMap<Priority, Map<NodeId, RMContainer>>();
    final Map<RMContainer, Long> preemptionMap = new HashMap<RMContainer, Long>();
    Multiset<Priority> schedulingOpportunities = HashMultiset.create();
    Multiset<Priority> reReservations = HashMultiset.create();
    Resource currentReservation = (Resource)this.recordFactory.newRecordInstance(Resource.class);
    private final RMContext rmContext;
    final Map<Priority, NodeType> allowedLocalityLevel = new HashMap<Priority, NodeType>();
    Map<Priority, Long> lastScheduledContainer = new HashMap<Priority, Long>();

    public FSSchedulerApp(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        this.rmContext = rmContext;
        this.appSchedulingInfo = new AppSchedulingInfo(applicationAttemptId, user, queue, activeUsersManager);
        this.queue = queue;
    }

    public ApplicationId getApplicationId() {
        return this.appSchedulingInfo.getApplicationId();
    }

    @Override
    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appSchedulingInfo.getApplicationAttemptId();
    }

    public void setAppSchedulable(AppSchedulable appSchedulable) {
        this.appSchedulable = appSchedulable;
    }

    public AppSchedulable getAppSchedulable() {
        return this.appSchedulable;
    }

    public String getUser() {
        return this.appSchedulingInfo.getUser();
    }

    public synchronized void updateResourceRequests(List<ResourceRequest> requests) {
        this.appSchedulingInfo.updateResourceRequests(requests, null, null);
    }

    public Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.appSchedulingInfo.getResourceRequests(priority);
    }

    public int getNewContainerId() {
        return this.appSchedulingInfo.getNewContainerId();
    }

    public Collection<Priority> getPriorities() {
        return this.appSchedulingInfo.getPriorities();
    }

    public ResourceRequest getResourceRequest(Priority priority, String nodeAddress) {
        return this.appSchedulingInfo.getResourceRequest(priority, nodeAddress);
    }

    public synchronized int getTotalRequiredResources(Priority priority) {
        return this.getResourceRequest(priority, "*").getNumContainers();
    }

    public Resource getResource(Priority priority) {
        return this.appSchedulingInfo.getResource(priority);
    }

    @Override
    public boolean isPending() {
        return this.appSchedulingInfo.isPending();
    }

    public String getQueueName() {
        return this.appSchedulingInfo.getQueueName();
    }

    @Override
    public synchronized Collection<RMContainer> getLiveContainers() {
        return new ArrayList<RMContainer>(this.liveContainers.values());
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        this.appSchedulingInfo.stop(rmAppAttemptFinalState);
    }

    public synchronized void containerLaunchedOnNode(ContainerId containerId, NodeId nodeId) {
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (rmContainer == null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(nodeId, containerId));
            return;
        }
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
    }

    public synchronized void containerCompleted(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        Container container = rmContainer.getContainer();
        ContainerId containerId = container.getId();
        rmContainer.handle((Event)new RMContainerFinishedEvent(containerId, containerStatus, event));
        LOG.info((Object)("Completed container: " + rmContainer.getContainerId() + " in state: " + (Object)((Object)rmContainer.getState()) + " event:" + (Object)((Object)event)));
        this.liveContainers.remove(rmContainer.getContainerId());
        RMAuditLogger.logSuccess(this.getUser(), "AM Released Container", "SchedulerApp", this.getApplicationId(), containerId);
        Resource containerResource = rmContainer.getContainer().getResource();
        this.queue.getMetrics().releaseResources(this.getUser(), 1, containerResource);
        Resources.subtractFrom((Resource)this.currentConsumption, (Resource)containerResource);
        this.preemptionMap.remove(rmContainer);
    }

    public synchronized List<Container> pullNewlyAllocatedContainers() {
        ArrayList<Container> returnContainerList = new ArrayList<Container>(this.newlyAllocatedContainers.size());
        for (RMContainer rmContainer : this.newlyAllocatedContainers) {
            rmContainer.handle((Event)new RMContainerEvent(rmContainer.getContainerId(), RMContainerEventType.ACQUIRED));
            returnContainerList.add(rmContainer.getContainer());
        }
        this.newlyAllocatedContainers.clear();
        return returnContainerList;
    }

    public Resource getCurrentConsumption() {
        return this.currentConsumption;
    }

    public synchronized void showRequests() {
        if (LOG.isDebugEnabled()) {
            for (Priority priority : this.getPriorities()) {
                Map<String, ResourceRequest> requests = this.getResourceRequests(priority);
                if (requests == null) continue;
                LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " headRoom=" + this.getHeadroom() + " currentConsumption=" + this.currentConsumption.getMemory()));
                for (ResourceRequest request : requests.values()) {
                    LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " request=" + request));
                }
            }
        }
    }

    public synchronized RMContainer getRMContainer(ContainerId id) {
        return this.liveContainers.get(id);
    }

    public synchronized void addSchedulingOpportunity(Priority priority) {
        this.schedulingOpportunities.setCount((Object)priority, this.schedulingOpportunities.count((Object)priority) + 1);
    }

    public synchronized int getSchedulingOpportunities(Priority priority) {
        return this.schedulingOpportunities.count((Object)priority);
    }

    synchronized void resetReReservations(Priority priority) {
        this.reReservations.setCount((Object)priority, 0);
    }

    synchronized void addReReservation(Priority priority) {
        this.reReservations.add((Object)priority);
    }

    public synchronized int getReReservations(Priority priority) {
        return this.reReservations.count((Object)priority);
    }

    public synchronized int getNumReservedContainers(Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        return reservedContainers == null ? 0 : reservedContainers.size();
    }

    @VisibleForTesting
    public synchronized Resource getCurrentReservation() {
        return this.currentReservation;
    }

    public synchronized RMContainer reserve(FSSchedulerNode node, Priority priority, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.rmContext.getDispatcher().getEventHandler(), this.rmContext.getContainerAllocationExpirer());
            Resources.addTo((Resource)this.currentReservation, (Resource)container.getResource());
            this.resetReReservations(priority);
        } else {
            this.addReReservation(priority);
        }
        rmContainer.handle((Event)new RMContainerReservedEvent(container.getId(), container.getResource(), node.getNodeID(), priority));
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers == null) {
            reservedContainers = new HashMap<NodeId, RMContainer>();
            this.reservedContainers.put(priority, reservedContainers);
        }
        reservedContainers.put(node.getNodeID(), rmContainer);
        LOG.info((Object)("Application " + this.getApplicationId() + " reserved container " + rmContainer + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation.getMemory()));
        return rmContainer;
    }

    public synchronized void unreserve(FSSchedulerNode node, Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        RMContainer reservedContainer = reservedContainers.remove(node.getNodeID());
        if (reservedContainers.isEmpty()) {
            this.reservedContainers.remove(priority);
        }
        this.resetReReservations(priority);
        Resource resource = reservedContainer.getContainer().getResource();
        Resources.subtractFrom((Resource)this.currentReservation, (Resource)resource);
        LOG.info((Object)("Application " + this.getApplicationId() + " unreserved " + " on node " + node + ", currently has " + reservedContainers.size() + " at priority " + priority + "; currentReservation " + this.currentReservation));
    }

    public synchronized boolean isReserved(FSSchedulerNode node, Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers != null) {
            return reservedContainers.containsKey(node.getNodeID());
        }
        return false;
    }

    public synchronized float getLocalityWaitFactor(Priority priority, int clusterNodes) {
        int requiredResources = Math.max(this.getResourceRequests(priority).size() - 1, 0);
        return Math.min((float)requiredResources / (float)clusterNodes, 1.0f);
    }

    public synchronized List<RMContainer> getReservedContainers() {
        ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>();
        for (Map.Entry<Priority, Map<NodeId, RMContainer>> e : this.reservedContainers.entrySet()) {
            reservedContainers.addAll(e.getValue().values());
        }
        return reservedContainers;
    }

    public synchronized void setHeadroom(Resource globalLimit) {
        this.resourceLimit = globalLimit;
    }

    public synchronized Resource getHeadroom() {
        if (this.resourceLimit.getMemory() < 0) {
            this.resourceLimit.setMemory(0);
        }
        return this.resourceLimit;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public synchronized void resetSchedulingOpportunities(Priority priority) {
        this.lastScheduledContainer.put(priority, System.currentTimeMillis());
        this.schedulingOpportunities.setCount((Object)priority, 0);
    }

    public synchronized NodeType getAllowedLocalityLevel(Priority priority, int numNodes, double nodeLocalityThreshold, double rackLocalityThreshold) {
        double threshold;
        if (nodeLocalityThreshold > 1.0) {
            nodeLocalityThreshold = 1.0;
        }
        if (rackLocalityThreshold > 1.0) {
            rackLocalityThreshold = 1.0;
        }
        if (nodeLocalityThreshold < 0.0 || rackLocalityThreshold < 0.0) {
            return NodeType.OFF_SWITCH;
        }
        if (!this.allowedLocalityLevel.containsKey(priority)) {
            this.allowedLocalityLevel.put(priority, NodeType.NODE_LOCAL);
            return NodeType.NODE_LOCAL;
        }
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed.equals((Object)NodeType.OFF_SWITCH)) {
            return NodeType.OFF_SWITCH;
        }
        double d = threshold = allowed.equals((Object)NodeType.NODE_LOCAL) ? nodeLocalityThreshold : rackLocalityThreshold;
        if ((double)this.getSchedulingOpportunities(priority) > (double)numNodes * threshold) {
            if (allowed.equals((Object)NodeType.NODE_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.RACK_LOCAL);
                this.resetSchedulingOpportunities(priority);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL)) {
                this.allowedLocalityLevel.put(priority, NodeType.OFF_SWITCH);
                this.resetSchedulingOpportunities(priority);
            }
        }
        return this.allowedLocalityLevel.get(priority);
    }

    public synchronized RMContainer allocate(NodeType type, FSSchedulerNode node, Priority priority, ResourceRequest request, Container container) {
        NodeType allowed = this.allowedLocalityLevel.get(priority);
        if (allowed != null) {
            if (allowed.equals((Object)NodeType.OFF_SWITCH) && (type.equals((Object)NodeType.NODE_LOCAL) || type.equals((Object)NodeType.RACK_LOCAL))) {
                this.resetAllowedLocalityLevel(priority, type);
            } else if (allowed.equals((Object)NodeType.RACK_LOCAL) && type.equals((Object)NodeType.NODE_LOCAL)) {
                this.resetAllowedLocalityLevel(priority, type);
            }
        }
        if (this.getTotalRequiredResources(priority) <= 0) {
            return null;
        }
        RMContainerImpl rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.rmContext.getDispatcher().getEventHandler(), this.rmContext.getContainerAllocationExpirer());
        this.newlyAllocatedContainers.add(rmContainer);
        this.liveContainers.put(container.getId(), rmContainer);
        this.appSchedulingInfo.allocate(type, node, priority, request, container);
        Resources.addTo((Resource)this.currentConsumption, (Resource)container.getResource());
        rmContainer.handle((Event)new RMContainerEvent(container.getId(), RMContainerEventType.START));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("allocate: applicationAttemptId=" + container.getId().getApplicationAttemptId() + " container=" + container.getId() + " host=" + container.getNodeId().getHost() + " type=" + (Object)((Object)type)));
        }
        RMAuditLogger.logSuccess(this.getUser(), "AM Allocated Container", "SchedulerApp", this.getApplicationId(), container.getId());
        return rmContainer;
    }

    public synchronized void resetAllowedLocalityLevel(Priority priority, NodeType level) {
        NodeType old = this.allowedLocalityLevel.get(priority);
        LOG.info((Object)("Raising locality level from " + (Object)((Object)old) + " to " + (Object)((Object)level) + " at " + " priority " + priority));
        this.allowedLocalityLevel.put(priority, level);
    }

    public void addPreemption(RMContainer container, long time) {
        assert (this.preemptionMap.get(container) == null);
        this.preemptionMap.put(container, time);
    }

    public Long getContainerPreemptionTime(RMContainer container) {
        return this.preemptionMap.get(container);
    }

    public Set<RMContainer> getPreemptionContainers() {
        return this.preemptionMap.keySet();
    }
}

