/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.server.resourcemanager.ClientRMService;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.NullRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.resourcemanager.security.NMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;

public class RMContextImpl
implements RMContext {
    private final Dispatcher rmDispatcher;
    private final ConcurrentMap<ApplicationId, RMApp> applications;
    private final ConcurrentMap<NodeId, RMNode> nodes;
    private final ConcurrentMap<String, RMNode> inactiveNodes;
    private AMLivelinessMonitor amLivelinessMonitor;
    private AMLivelinessMonitor amFinishingMonitor;
    private RMStateStore stateStore;
    private ContainerAllocationExpirer containerAllocationExpirer;
    private final DelegationTokenRenewer delegationTokenRenewer;
    private final AMRMTokenSecretManager amRMTokenSecretManager;
    private final RMContainerTokenSecretManager containerTokenSecretManager;
    private final NMTokenSecretManagerInRM nmTokenSecretManager;
    private final ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager;
    private ClientRMService clientRMService;
    private RMDelegationTokenSecretManager rmDelegationTokenSecretManager;

    public RMContextImpl(Dispatcher rmDispatcher, RMStateStore store, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager amRMTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        this.applications = new ConcurrentHashMap<ApplicationId, RMApp>();
        this.nodes = new ConcurrentHashMap<NodeId, RMNode>();
        this.inactiveNodes = new ConcurrentHashMap<String, RMNode>();
        this.stateStore = null;
        this.rmDispatcher = rmDispatcher;
        this.stateStore = store;
        this.containerAllocationExpirer = containerAllocationExpirer;
        this.amLivelinessMonitor = amLivelinessMonitor;
        this.amFinishingMonitor = amFinishingMonitor;
        this.delegationTokenRenewer = delegationTokenRenewer;
        this.amRMTokenSecretManager = amRMTokenSecretManager;
        this.containerTokenSecretManager = containerTokenSecretManager;
        this.nmTokenSecretManager = nmTokenSecretManager;
        this.clientToAMTokenSecretManager = clientToAMTokenSecretManager;
    }

    @VisibleForTesting
    public RMContextImpl(Dispatcher rmDispatcher, ContainerAllocationExpirer containerAllocationExpirer, AMLivelinessMonitor amLivelinessMonitor, AMLivelinessMonitor amFinishingMonitor, DelegationTokenRenewer delegationTokenRenewer, AMRMTokenSecretManager appTokenSecretManager, RMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInRM nmTokenSecretManager, ClientToAMTokenSecretManagerInRM clientToAMTokenSecretManager) {
        block2: {
            this(rmDispatcher, null, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, delegationTokenRenewer, appTokenSecretManager, containerTokenSecretManager, nmTokenSecretManager, clientToAMTokenSecretManager);
            NullRMStateStore nullStore = new NullRMStateStore();
            nullStore.setRMDispatcher(rmDispatcher);
            try {
                nullStore.init((Configuration)new YarnConfiguration());
                this.setStateStore(nullStore);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.rmDispatcher;
    }

    @Override
    public RMStateStore getStateStore() {
        return this.stateStore;
    }

    @Override
    public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
        return this.applications;
    }

    @Override
    public ConcurrentMap<NodeId, RMNode> getRMNodes() {
        return this.nodes;
    }

    @Override
    public ConcurrentMap<String, RMNode> getInactiveRMNodes() {
        return this.inactiveNodes;
    }

    @Override
    public ContainerAllocationExpirer getContainerAllocationExpirer() {
        return this.containerAllocationExpirer;
    }

    @Override
    public AMLivelinessMonitor getAMLivelinessMonitor() {
        return this.amLivelinessMonitor;
    }

    @Override
    public AMLivelinessMonitor getAMFinishingMonitor() {
        return this.amFinishingMonitor;
    }

    @Override
    public DelegationTokenRenewer getDelegationTokenRenewer() {
        return this.delegationTokenRenewer;
    }

    @Override
    public AMRMTokenSecretManager getAMRMTokenSecretManager() {
        return this.amRMTokenSecretManager;
    }

    @Override
    public RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.containerTokenSecretManager;
    }

    @Override
    public NMTokenSecretManagerInRM getNMTokenSecretManager() {
        return this.nmTokenSecretManager;
    }

    @Override
    public ClientToAMTokenSecretManagerInRM getClientToAMTokenSecretManager() {
        return this.clientToAMTokenSecretManager;
    }

    @VisibleForTesting
    public void setStateStore(RMStateStore store) {
        this.stateStore = store;
    }

    @Override
    public ClientRMService getClientRMService() {
        return this.clientRMService;
    }

    @Override
    public void setClientRMService(ClientRMService clientRMService) {
        this.clientRMService = clientRMService;
    }

    @Override
    public RMDelegationTokenSecretManager getRMDelegationTokenSecretManager() {
        return this.rmDelegationTokenSecretManager;
    }

    @Override
    public void setRMDelegationTokenSecretManager(RMDelegationTokenSecretManager delegationTokenSecretManager) {
        this.rmDelegationTokenSecretManager = delegationTokenSecretManager;
    }
}

