/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceContext;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceProcessor;
import org.apache.hadoop.yarn.ams.ApplicationMasterServiceUtils;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.PreemptionContainer;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.PreemptionResourceRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.StrictPreemptionContract;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStatusupdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ContainerUpdates;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

final class DefaultAMSProcessor
implements ApplicationMasterServiceProcessor {
    private static final Log LOG = LogFactory.getLog(DefaultAMSProcessor.class);
    private static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    protected static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0), null, null, null);
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private RMContext rmContext;
    private Set<String> exclusiveEnforcedPartitions;

    DefaultAMSProcessor() {
    }

    public void init(ApplicationMasterServiceContext amsContext, ApplicationMasterServiceProcessor nextProcessor) {
        this.rmContext = (RMContext)amsContext;
        this.exclusiveEnforcedPartitions = YarnConfiguration.getExclusiveEnforcedPartitions((Configuration)this.rmContext.getYarnConfiguration());
    }

    public void registerApplicationMaster(ApplicationAttemptId applicationAttemptId, RegisterApplicationMasterRequest request, RegisterApplicationMasterResponse response) throws IOException, YarnException {
        List<Container> transferredContainers;
        RMApp app = (RMApp)this.getRmContext().getRMApps().get(applicationAttemptId.getApplicationId());
        LOG.info((Object)("AM registration " + applicationAttemptId));
        this.getRmContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRegistrationEvent(applicationAttemptId, request.getHost(), request.getRpcPort(), request.getTrackingUrl()));
        RMAuditLogger.logSuccess(app.getUser(), "Register App Master", "ApplicationMasterService", app.getApplicationId(), applicationAttemptId);
        response.setMaximumResourceCapability(this.getScheduler().getMaximumResourceCapability(app.getQueue()));
        response.setApplicationACLs(app.getRMAppAttempt(applicationAttemptId).getSubmissionContext().getAMContainerSpec().getApplicationACLs());
        response.setQueue(app.getQueue());
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.info((Object)"Setting client token master key");
            response.setClientToAMTokenMasterKey(ByteBuffer.wrap(this.getRmContext().getClientToAMTokenSecretManager().getMasterKey(applicationAttemptId).getEncoded()));
        }
        if (app.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts() && !(transferredContainers = this.getScheduler().getTransferredContainers(applicationAttemptId)).isEmpty()) {
            response.setContainersFromPreviousAttempts(transferredContainers);
            this.rmContext.getNMTokenSecretManager().clearNodeSetForAttempt(applicationAttemptId);
            ArrayList<NMToken> nmTokens = new ArrayList<NMToken>();
            for (Container container : transferredContainers) {
                try {
                    NMToken token = this.getRmContext().getNMTokenSecretManager().createAndGetNMToken(app.getUser(), applicationAttemptId, container);
                    if (null == token) continue;
                    nmTokens.add(token);
                }
                catch (IllegalArgumentException e) {
                    if (!(e.getCause() instanceof UnknownHostException)) continue;
                    throw (UnknownHostException)e.getCause();
                }
            }
            response.setNMTokensFromPreviousAttempts(nmTokens);
            LOG.info((Object)("Application " + app.getApplicationId() + " retrieved " + transferredContainers.size() + " containers from previous" + " attempts and " + nmTokens.size() + " NM tokens."));
        }
        response.setSchedulerResourceTypes(this.getScheduler().getSchedulingResourceTypes());
    }

    public void allocate(ApplicationAttemptId appAttemptId, AllocateRequest request, AllocateResponse response) throws YarnException {
        CollectorInfo collectorInfo;
        Allocation allocation;
        this.handleProgress(appAttemptId, request);
        List ask = request.getAskList();
        List release = request.getReleaseList();
        ResourceBlacklistRequest blacklistRequest = request.getResourceBlacklistRequest();
        List blacklistAdditions = blacklistRequest != null ? blacklistRequest.getBlacklistAdditions() : Collections.EMPTY_LIST;
        List blacklistRemovals = blacklistRequest != null ? blacklistRequest.getBlacklistRemovals() : Collections.EMPTY_LIST;
        RMApp app = (RMApp)this.getRmContext().getRMApps().get(appAttemptId.getApplicationId());
        ApplicationSubmissionContext asc = app.getApplicationSubmissionContext();
        for (ResourceRequest req : ask) {
            if (null == req.getNodeLabelExpression() && "*".equals(req.getResourceName())) {
                req.setNodeLabelExpression(asc.getNodeLabelExpression());
            }
            if (!"*".equals(req.getResourceName())) continue;
            SchedulerUtils.enforcePartitionExclusivity(req, this.exclusiveEnforcedPartitions, asc.getNodeLabelExpression());
        }
        Resource maximumCapacity = this.getScheduler().getMaximumResourceCapability(app.getQueue());
        try {
            RMServerUtils.normalizeAndValidateRequests(ask, maximumCapacity, app.getQueue(), this.getScheduler(), this.getRmContext());
        }
        catch (InvalidResourceRequestException e) {
            LOG.warn((Object)("Invalid resource ask by application " + appAttemptId), (Throwable)e);
            throw e;
        }
        try {
            RMServerUtils.validateBlacklistRequest(blacklistRequest);
        }
        catch (InvalidResourceBlacklistRequestException e) {
            LOG.warn((Object)("Invalid blacklist request by application " + appAttemptId), (Throwable)e);
            throw e;
        }
        if (!app.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts()) {
            try {
                RMServerUtils.validateContainerReleaseRequest(release, appAttemptId);
            }
            catch (InvalidContainerReleaseException e) {
                LOG.warn((Object)("Invalid container release by application " + appAttemptId), (Throwable)e);
                throw e;
            }
        }
        ArrayList<UpdateContainerError> updateErrors = new ArrayList<UpdateContainerError>();
        ContainerUpdates containerUpdateRequests = RMServerUtils.validateAndSplitUpdateResourceRequests(this.getRmContext(), request, maximumCapacity, updateErrors);
        RMAppAttemptState state = app.getRMAppAttempt(appAttemptId).getAppAttemptState();
        if (state.equals((Object)RMAppAttemptState.FINAL_SAVING) || state.equals((Object)RMAppAttemptState.FINISHING) || app.isAppFinalStateStored()) {
            LOG.warn((Object)(appAttemptId + " is in " + (Object)((Object)state) + " state, ignore container allocate request."));
            allocation = EMPTY_ALLOCATION;
        } else {
            allocation = this.getScheduler().allocate(appAttemptId, ask, release, blacklistAdditions, blacklistRemovals, containerUpdateRequests);
        }
        if (!blacklistAdditions.isEmpty() || !blacklistRemovals.isEmpty()) {
            LOG.info((Object)("blacklist are updated in Scheduler.blacklistAdditions: " + blacklistAdditions + ", " + "blacklistRemovals: " + blacklistRemovals));
        }
        RMAppAttempt appAttempt = app.getRMAppAttempt(appAttemptId);
        if (allocation.getNMTokens() != null && !allocation.getNMTokens().isEmpty()) {
            response.setNMTokens(allocation.getNMTokens());
        }
        ApplicationMasterServiceUtils.addToUpdateContainerErrors((AllocateResponse)response, updateErrors);
        this.handleNodeUpdates(app, response);
        ApplicationMasterServiceUtils.addToAllocatedContainers((AllocateResponse)response, allocation.getContainers());
        response.setCompletedContainersStatuses(appAttempt.pullJustFinishedContainers());
        response.setAvailableResources(allocation.getResourceLimit());
        DefaultAMSProcessor.addToContainerUpdates(response, allocation, ((SchedulerApplicationAttempt)((AbstractYarnScheduler)this.getScheduler()).getApplicationAttempt(appAttemptId)).pullUpdateContainerErrors());
        response.setNumClusterNodes(this.getScheduler().getNumClusterNodes());
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)this.getRmContext().getYarnConfiguration()) && (collectorInfo = app.getCollectorInfo()) != null) {
            response.setCollectorInfo(collectorInfo);
        }
        response.setPreemptionMessage(this.generatePreemptionMessage(allocation));
        response.setApplicationPriority(app.getApplicationPriority());
    }

    private void handleNodeUpdates(RMApp app, AllocateResponse allocateResponse) {
        ArrayList<RMNode> updatedNodes = new ArrayList<RMNode>();
        if (app.pullRMNodeUpdates(updatedNodes) > 0) {
            ArrayList<NodeReport> updatedNodeReports = new ArrayList<NodeReport>();
            for (RMNode rmNode : updatedNodes) {
                SchedulerNodeReport schedulerNodeReport = this.getScheduler().getNodeReport(rmNode.getNodeID());
                Resource used = BuilderUtils.newResource((long)0L, (int)0);
                int numContainers = 0;
                if (schedulerNodeReport != null) {
                    used = schedulerNodeReport.getUsedResource();
                    numContainers = schedulerNodeReport.getNumContainers();
                }
                NodeId nodeId = rmNode.getNodeID();
                NodeReport report = BuilderUtils.newNodeReport((NodeId)nodeId, (NodeState)rmNode.getState(), (String)rmNode.getHttpAddress(), (String)rmNode.getRackName(), (Resource)used, (Resource)rmNode.getTotalCapability(), (int)numContainers, (String)rmNode.getHealthReport(), (long)rmNode.getLastHealthReportTime(), rmNode.getNodeLabels());
                updatedNodeReports.add(report);
            }
            allocateResponse.setUpdatedNodes(updatedNodeReports);
        }
    }

    private void handleProgress(ApplicationAttemptId appAttemptId, AllocateRequest request) {
        float filteredProgress = request.getProgress();
        if (Float.isNaN(filteredProgress) || filteredProgress == Float.NEGATIVE_INFINITY || filteredProgress < 0.0f) {
            request.setProgress(0.0f);
        } else if (filteredProgress > 1.0f || filteredProgress == Float.POSITIVE_INFINITY) {
            request.setProgress(1.0f);
        }
        this.getRmContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptStatusupdateEvent(appAttemptId, request.getProgress(), request.getTrackingUrl()));
    }

    public void finishApplicationMaster(ApplicationAttemptId applicationAttemptId, FinishApplicationMasterRequest request, FinishApplicationMasterResponse response) {
        RMApp app = (RMApp)this.getRmContext().getRMApps().get(applicationAttemptId.getApplicationId());
        response.setIsUnregistered(app.getApplicationSubmissionContext().getUnmanagedAM());
        this.getRmContext().getDispatcher().getEventHandler().handle((Event)new RMAppAttemptUnregistrationEvent(applicationAttemptId, request.getTrackingUrl(), request.getFinalApplicationStatus(), request.getDiagnostics()));
    }

    private PreemptionMessage generatePreemptionMessage(Allocation allocation) {
        PreemptionContainer pc;
        HashSet<PreemptionContainer> pCont;
        PreemptionMessage pMsg = null;
        if (allocation.getStrictContainerPreemptions() != null) {
            pMsg = (PreemptionMessage)this.recordFactory.newRecordInstance(PreemptionMessage.class);
            StrictPreemptionContract pStrict = (StrictPreemptionContract)this.recordFactory.newRecordInstance(StrictPreemptionContract.class);
            pCont = new HashSet<PreemptionContainer>();
            for (ContainerId cId : allocation.getStrictContainerPreemptions()) {
                pc = (PreemptionContainer)this.recordFactory.newRecordInstance(PreemptionContainer.class);
                pc.setId(cId);
                pCont.add(pc);
            }
            pStrict.setContainers(pCont);
            pMsg.setStrictContract(pStrict);
        }
        if (allocation.getResourcePreemptions() != null && allocation.getResourcePreemptions().size() > 0 && allocation.getContainerPreemptions() != null && allocation.getContainerPreemptions().size() > 0) {
            if (pMsg == null) {
                pMsg = (PreemptionMessage)this.recordFactory.newRecordInstance(PreemptionMessage.class);
            }
            PreemptionContract contract = (PreemptionContract)this.recordFactory.newRecordInstance(PreemptionContract.class);
            pCont = new HashSet();
            for (ContainerId cId : allocation.getContainerPreemptions()) {
                pc = (PreemptionContainer)this.recordFactory.newRecordInstance(PreemptionContainer.class);
                pc.setId(cId);
                pCont.add(pc);
            }
            ArrayList<PreemptionResourceRequest> pRes = new ArrayList<PreemptionResourceRequest>();
            for (ResourceRequest crr : allocation.getResourcePreemptions()) {
                PreemptionResourceRequest prr = (PreemptionResourceRequest)this.recordFactory.newRecordInstance(PreemptionResourceRequest.class);
                prr.setResourceRequest(crr);
                pRes.add(prr);
            }
            contract.setContainers(pCont);
            contract.setResourceRequest(pRes);
            pMsg.setContract(contract);
        }
        return pMsg;
    }

    protected RMContext getRmContext() {
        return this.rmContext;
    }

    protected YarnScheduler getScheduler() {
        return this.rmContext.getScheduler();
    }

    private static void addToContainerUpdates(AllocateResponse allocateResponse, Allocation allocation, List<UpdateContainerError> updateContainerErrors) {
        ApplicationMasterServiceUtils.addToUpdatedContainers((AllocateResponse)allocateResponse, (ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, allocation.getIncreasedContainers());
        ApplicationMasterServiceUtils.addToUpdatedContainers((AllocateResponse)allocateResponse, (ContainerUpdateType)ContainerUpdateType.DECREASE_RESOURCE, allocation.getDecreasedContainers());
        ApplicationMasterServiceUtils.addToUpdatedContainers((AllocateResponse)allocateResponse, (ContainerUpdateType)ContainerUpdateType.PROMOTE_EXECUTION_TYPE, allocation.getPromotedContainers());
        ApplicationMasterServiceUtils.addToUpdatedContainers((AllocateResponse)allocateResponse, (ContainerUpdateType)ContainerUpdateType.DEMOTE_EXECUTION_TYPE, allocation.getDemotedContainers());
        ApplicationMasterServiceUtils.addToUpdateContainerErrors((AllocateResponse)allocateResponse, updateContainerErrors);
    }
}

