/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ZKUtil;
import org.apache.zookeeper.data.ACL;

@InterfaceAudience.Private
public class RMZKUtils {
    private static final Log LOG = LogFactory.getLog(RMZKUtils.class);

    public static List<ACL> getZKAcls(Configuration conf) throws Exception {
        String zkAclConf = conf.get("yarn.resourcemanager.zk-acl", "world:anyone:rwcda");
        try {
            zkAclConf = ZKUtil.resolveConfIndirection((String)zkAclConf);
            return ZKUtil.parseACLs((String)zkAclConf);
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't read ACLs based on yarn.resourcemanager.zk-acl");
            throw e;
        }
    }

    public static List<ZKUtil.ZKAuthInfo> getZKAuths(Configuration conf) throws Exception {
        String zkAuthConf = conf.get("yarn.resourcemanager.zk-auth");
        try {
            zkAuthConf = ZKUtil.resolveConfIndirection((String)zkAuthConf);
            if (zkAuthConf != null) {
                return ZKUtil.parseAuth((String)zkAuthConf);
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            LOG.error((Object)"Couldn't read Auth based on yarn.resourcemanager.zk-auth");
            throw e;
        }
    }
}

