/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.PreemptionContainer;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.PreemptionResourceRequest;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.StrictPreemptionContract;
import org.apache.hadoop.yarn.api.records.UpdateContainerError;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptRegistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptStatusupdateEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.event.RMAppAttemptUnregistrationEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.security.MasterKeyData;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
public class ApplicationMasterService
extends AbstractService
implements ApplicationMasterProtocol {
    private static final Log LOG = LogFactory.getLog(ApplicationMasterService.class);
    private final AMLivelinessMonitor amLivelinessMonitor;
    private YarnScheduler rScheduler;
    private InetSocketAddress masterServiceAddress;
    private Server server;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private final ConcurrentMap<ApplicationAttemptId, AllocateResponseLock> responseMap = new ConcurrentHashMap<ApplicationAttemptId, AllocateResponseLock>();
    private final RMContext rmContext;
    protected static final List<Container> EMPTY_CONTAINER_LIST = new ArrayList<Container>();
    protected static final Allocation EMPTY_ALLOCATION = new Allocation(EMPTY_CONTAINER_LIST, Resources.createResource((int)0), null, null, null);

    public ApplicationMasterService(RMContext rmContext, YarnScheduler scheduler) {
        super(ApplicationMasterService.class.getName());
        this.amLivelinessMonitor = rmContext.getAMLivelinessMonitor();
        this.rScheduler = scheduler;
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.masterServiceAddress = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", 8030);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        Configuration serverConf = conf;
        serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.TOKEN.toString());
        this.server = rpc.getServer(ApplicationMasterProtocol.class, (Object)this, this.masterServiceAddress, serverConf, (SecretManager)this.rmContext.getAMRMTokenSecretManager(), serverConf.getInt("yarn.resourcemanager.scheduler.client.thread-count", 50));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.server.start();
        this.masterServiceAddress = conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.scheduler.address", "0.0.0.0:8030", this.server.getListenerAddress());
        super.serviceStart();
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.masterServiceAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        AMRMTokenIdentifier amrmTokenIdentifier = YarnServerSecurityUtils.authorizeRequest();
        ApplicationAttemptId applicationAttemptId = amrmTokenIdentifier.getApplicationAttemptId();
        ApplicationId appID = applicationAttemptId.getApplicationId();
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(applicationAttemptId);
        if (lock == null) {
            RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appID)).getUser(), "Register App Master", "Application doesn't exist in cache " + applicationAttemptId, "ApplicationMasterService", "Error in registering application master", appID, applicationAttemptId);
            this.throwApplicationDoesNotExistInCacheException(applicationAttemptId);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            List<Container> transferredContainers;
            AllocateResponse lastResponse = lock.getAllocateResponse();
            if (this.hasApplicationMasterRegistered(applicationAttemptId)) {
                String message = "Application Master is already registered : " + appID;
                LOG.warn((Object)message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appID)).getUser(), "Register App Master", "", "ApplicationMasterService", message, appID, applicationAttemptId);
                throw new InvalidApplicationMasterRequestException(message);
            }
            this.amLivelinessMonitor.receivedPing(applicationAttemptId);
            RMApp app = (RMApp)this.rmContext.getRMApps().get(appID);
            lastResponse.setResponseId(0);
            lock.setAllocateResponse(lastResponse);
            LOG.info((Object)("AM registration " + applicationAttemptId));
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptRegistrationEvent(applicationAttemptId, request.getHost(), request.getRpcPort(), request.getTrackingUrl()));
            RMAuditLogger.logSuccess(app.getUser(), "Register App Master", "ApplicationMasterService", appID, applicationAttemptId);
            RegisterApplicationMasterResponse response = (RegisterApplicationMasterResponse)this.recordFactory.newRecordInstance(RegisterApplicationMasterResponse.class);
            response.setMaximumResourceCapability(this.rScheduler.getMaximumResourceCapability(app.getQueue()));
            response.setApplicationACLs(app.getRMAppAttempt(applicationAttemptId).getSubmissionContext().getAMContainerSpec().getApplicationACLs());
            response.setQueue(app.getQueue());
            if (UserGroupInformation.isSecurityEnabled()) {
                LOG.info((Object)"Setting client token master key");
                response.setClientToAMTokenMasterKey(ByteBuffer.wrap(this.rmContext.getClientToAMTokenSecretManager().getMasterKey(applicationAttemptId).getEncoded()));
            }
            if (app.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts() && !(transferredContainers = this.rScheduler.getTransferredContainers(applicationAttemptId)).isEmpty()) {
                response.setContainersFromPreviousAttempts(transferredContainers);
                ArrayList<NMToken> nmTokens = new ArrayList<NMToken>();
                for (Container container : transferredContainers) {
                    try {
                        NMToken token = this.rmContext.getNMTokenSecretManager().createAndGetNMToken(app.getUser(), applicationAttemptId, container);
                        if (null == token) continue;
                        nmTokens.add(token);
                    }
                    catch (IllegalArgumentException e) {
                        if (!(e.getCause() instanceof UnknownHostException)) continue;
                        throw (UnknownHostException)e.getCause();
                    }
                }
                response.setNMTokensFromPreviousAttempts(nmTokens);
                LOG.info((Object)("Application " + appID + " retrieved " + transferredContainers.size() + " containers from previous" + " attempts and " + nmTokens.size() + " NM tokens."));
            }
            response.setSchedulerResourceTypes(this.rScheduler.getSchedulingResourceTypes());
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        ApplicationAttemptId applicationAttemptId = YarnServerSecurityUtils.authorizeRequest().getApplicationAttemptId();
        ApplicationId appId = applicationAttemptId.getApplicationId();
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationAttemptId.getApplicationId());
        if (rmApp.isAppFinalStateStored()) {
            LOG.info((Object)(rmApp.getApplicationId() + " unregistered successfully. "));
            return FinishApplicationMasterResponse.newInstance((boolean)true);
        }
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(applicationAttemptId);
        if (lock == null) {
            this.throwApplicationDoesNotExistInCacheException(applicationAttemptId);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            if (!this.hasApplicationMasterRegistered(applicationAttemptId)) {
                String message = "Application Master is trying to unregister before registering for: " + appId;
                LOG.error((Object)message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appId)).getUser(), "Unregister App Master", "", "ApplicationMasterService", message, appId, applicationAttemptId);
                throw new ApplicationMasterNotRegisteredException(message);
            }
            this.amLivelinessMonitor.receivedPing(applicationAttemptId);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptUnregistrationEvent(applicationAttemptId, request.getTrackingUrl(), request.getFinalApplicationStatus(), request.getDiagnostics()));
            return FinishApplicationMasterResponse.newInstance((boolean)rmApp.getApplicationSubmissionContext().getUnmanagedAM());
        }
    }

    private void throwApplicationDoesNotExistInCacheException(ApplicationAttemptId appAttemptId) throws InvalidApplicationMasterRequestException {
        String message = "Application doesn't exist in cache " + appAttemptId;
        LOG.error((Object)message);
        throw new InvalidApplicationMasterRequestException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasApplicationMasterRegistered(ApplicationAttemptId appAttemptId) {
        boolean hasApplicationMasterRegistered = false;
        AllocateResponseLock lastResponse = (AllocateResponseLock)this.responseMap.get(appAttemptId);
        if (lastResponse != null) {
            AllocateResponseLock allocateResponseLock = lastResponse;
            synchronized (allocateResponseLock) {
                if (lastResponse.getAllocateResponse() != null && lastResponse.getAllocateResponse().getResponseId() >= 0) {
                    hasApplicationMasterRegistered = true;
                }
            }
        }
        return hasApplicationMasterRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        AMRMTokenIdentifier amrmTokenIdentifier = YarnServerSecurityUtils.authorizeRequest();
        ApplicationAttemptId appAttemptId = amrmTokenIdentifier.getApplicationAttemptId();
        ApplicationId applicationId = appAttemptId.getApplicationId();
        this.amLivelinessMonitor.receivedPing(appAttemptId);
        AllocateResponseLock lock = (AllocateResponseLock)this.responseMap.get(appAttemptId);
        if (lock == null) {
            String message = "Application attempt " + appAttemptId + " doesn't exist in ApplicationMasterService cache.";
            LOG.error((Object)message);
            throw new ApplicationAttemptNotFoundException(message);
        }
        AllocateResponseLock allocateResponseLock = lock;
        synchronized (allocateResponseLock) {
            ArrayList<RMNode> updatedNodes;
            Allocation allocation;
            AllocateResponse lastResponse = lock.getAllocateResponse();
            if (!this.hasApplicationMasterRegistered(appAttemptId)) {
                String message = "AM is not registered for known application attempt: " + appAttemptId + " or RM had restarted after AM registered . AM should re-register.";
                LOG.info((Object)message);
                RMAuditLogger.logFailure(((RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId())).getUser(), "App Master Heartbeats", "", "ApplicationMasterService", message, applicationId, appAttemptId);
                throw new ApplicationMasterNotRegisteredException(message);
            }
            if (request.getResponseId() + 1 == lastResponse.getResponseId()) {
                return lastResponse;
            }
            if (request.getResponseId() + 1 < lastResponse.getResponseId()) {
                String message = "Invalid responseId in AllocateRequest from application attempt: " + appAttemptId + ", expect responseId to be " + (lastResponse.getResponseId() + 1);
                throw new InvalidApplicationMasterRequestException(message);
            }
            float filteredProgress = request.getProgress();
            if (Float.isNaN(filteredProgress) || filteredProgress == Float.NEGATIVE_INFINITY || filteredProgress < 0.0f) {
                request.setProgress(0.0f);
            } else if (filteredProgress > 1.0f || filteredProgress == Float.POSITIVE_INFINITY) {
                request.setProgress(1.0f);
            }
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptStatusupdateEvent(appAttemptId, request.getProgress()));
            List ask = request.getAskList();
            List release = request.getReleaseList();
            ResourceBlacklistRequest blacklistRequest = request.getResourceBlacklistRequest();
            List blacklistAdditions = blacklistRequest != null ? blacklistRequest.getBlacklistAdditions() : Collections.EMPTY_LIST;
            List blacklistRemovals = blacklistRequest != null ? blacklistRequest.getBlacklistRemovals() : Collections.EMPTY_LIST;
            RMApp app = (RMApp)this.rmContext.getRMApps().get(applicationId);
            ApplicationSubmissionContext asc = app.getApplicationSubmissionContext();
            for (ResourceRequest req : ask) {
                if (null != req.getNodeLabelExpression() || !"*".equals(req.getResourceName())) continue;
                req.setNodeLabelExpression(asc.getNodeLabelExpression());
            }
            Resource maximumCapacity = this.rScheduler.getMaximumResourceCapability();
            try {
                RMServerUtils.normalizeAndValidateRequests(ask, maximumCapacity, app.getQueue(), this.rScheduler, this.rmContext);
            }
            catch (InvalidResourceRequestException e) {
                LOG.warn((Object)("Invalid resource ask by application " + appAttemptId), (Throwable)e);
                throw e;
            }
            try {
                RMServerUtils.validateBlacklistRequest(blacklistRequest);
            }
            catch (InvalidResourceBlacklistRequestException e) {
                LOG.warn((Object)("Invalid blacklist request by application " + appAttemptId), (Throwable)e);
                throw e;
            }
            if (!app.getApplicationSubmissionContext().getKeepContainersAcrossApplicationAttempts()) {
                try {
                    RMServerUtils.validateContainerReleaseRequest(release, appAttemptId);
                }
                catch (InvalidContainerReleaseException e) {
                    LOG.warn((Object)("Invalid container release by application " + appAttemptId), (Throwable)e);
                    throw e;
                }
            }
            ArrayList<UpdateContainerRequest> increaseResourceReqs = new ArrayList<UpdateContainerRequest>();
            ArrayList<UpdateContainerRequest> decreaseResourceReqs = new ArrayList<UpdateContainerRequest>();
            List<UpdateContainerError> updateContainerErrors = RMServerUtils.validateAndSplitUpdateResourceRequests(this.rmContext, request, maximumCapacity, increaseResourceReqs, decreaseResourceReqs);
            RMAppAttemptState state = app.getRMAppAttempt(appAttemptId).getAppAttemptState();
            if (state.equals((Object)RMAppAttemptState.FINAL_SAVING) || state.equals((Object)RMAppAttemptState.FINISHING) || app.isAppFinalStateStored()) {
                LOG.warn((Object)(appAttemptId + " is in " + (Object)((Object)state) + " state, ignore container allocate request."));
                allocation = EMPTY_ALLOCATION;
            } else {
                allocation = this.rScheduler.allocate(appAttemptId, ask, release, blacklistAdditions, blacklistRemovals, increaseResourceReqs, decreaseResourceReqs);
            }
            if (!blacklistAdditions.isEmpty() || !blacklistRemovals.isEmpty()) {
                LOG.info((Object)("blacklist are updated in Scheduler.blacklistAdditions: " + blacklistAdditions + ", " + "blacklistRemovals: " + blacklistRemovals));
            }
            RMAppAttempt appAttempt = app.getRMAppAttempt(appAttemptId);
            AllocateResponse allocateResponse = (AllocateResponse)this.recordFactory.newRecordInstance(AllocateResponse.class);
            if (!allocation.getContainers().isEmpty()) {
                allocateResponse.setNMTokens(allocation.getNMTokens());
            }
            if (!updateContainerErrors.isEmpty()) {
                allocateResponse.setUpdateErrors(updateContainerErrors);
            }
            if (app.pullRMNodeUpdates(updatedNodes = new ArrayList<RMNode>()) > 0) {
                ArrayList<NodeReport> updatedNodeReports = new ArrayList<NodeReport>();
                for (RMNode rmNode : updatedNodes) {
                    SchedulerNodeReport schedulerNodeReport = this.rScheduler.getNodeReport(rmNode.getNodeID());
                    Resource used = BuilderUtils.newResource((long)0L, (int)0);
                    int numContainers = 0;
                    if (schedulerNodeReport != null) {
                        used = schedulerNodeReport.getUsedResource();
                        numContainers = schedulerNodeReport.getNumContainers();
                    }
                    NodeId nodeId = rmNode.getNodeID();
                    NodeReport report = BuilderUtils.newNodeReport((NodeId)nodeId, (NodeState)rmNode.getState(), (String)rmNode.getHttpAddress(), (String)rmNode.getRackName(), (Resource)used, (Resource)rmNode.getTotalCapability(), (int)numContainers, (String)rmNode.getHealthReport(), (long)rmNode.getLastHealthReportTime(), rmNode.getNodeLabels());
                    updatedNodeReports.add(report);
                }
                allocateResponse.setUpdatedNodes(updatedNodeReports);
            }
            allocateResponse.setAllocatedContainers(allocation.getContainers());
            allocateResponse.setCompletedContainersStatuses(appAttempt.pullJustFinishedContainers());
            allocateResponse.setResponseId(lastResponse.getResponseId() + 1);
            allocateResponse.setAvailableResources(allocation.getResourceLimit());
            ArrayList<UpdatedContainer> updatedContainers = new ArrayList<UpdatedContainer>();
            if (allocation.getIncreasedContainers() != null) {
                for (Container c : allocation.getIncreasedContainers()) {
                    updatedContainers.add(UpdatedContainer.newInstance((ContainerUpdateType)ContainerUpdateType.INCREASE_RESOURCE, (Container)c));
                }
            }
            if (allocation.getDecreasedContainers() != null) {
                for (Container c : allocation.getDecreasedContainers()) {
                    updatedContainers.add(UpdatedContainer.newInstance((ContainerUpdateType)ContainerUpdateType.DECREASE_RESOURCE, (Container)c));
                }
            }
            allocateResponse.setUpdatedContainers(updatedContainers);
            allocateResponse.setNumClusterNodes(this.rScheduler.getNumClusterNodes());
            allocateResponse.setPreemptionMessage(this.generatePreemptionMessage(allocation));
            allocateResponse.setApplicationPriority(app.getApplicationSubmissionContext().getPriority());
            MasterKeyData nextMasterKey = this.rmContext.getAMRMTokenSecretManager().getNextMasterKeyData();
            if (nextMasterKey != null && nextMasterKey.getMasterKey().getKeyId() != amrmTokenIdentifier.getKeyId()) {
                RMAppAttemptImpl appAttemptImpl = (RMAppAttemptImpl)appAttempt;
                Token<AMRMTokenIdentifier> amrmToken = appAttempt.getAMRMToken();
                if (nextMasterKey.getMasterKey().getKeyId() != appAttemptImpl.getAMRMTokenKeyId()) {
                    LOG.info((Object)("The AMRMToken has been rolled-over. Send new AMRMToken back to application: " + applicationId));
                    amrmToken = this.rmContext.getAMRMTokenSecretManager().createAndGetAMRMToken(appAttemptId);
                    appAttemptImpl.setAMRMToken(amrmToken);
                }
                allocateResponse.setAMRMToken(org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])amrmToken.getIdentifier(), (String)amrmToken.getKind().toString(), (byte[])amrmToken.getPassword(), (String)amrmToken.getService().toString()));
            }
            lock.setAllocateResponse(allocateResponse);
            return allocateResponse;
        }
    }

    private PreemptionMessage generatePreemptionMessage(Allocation allocation) {
        PreemptionContainer pc;
        HashSet<PreemptionContainer> pCont;
        PreemptionMessage pMsg = null;
        if (allocation.getStrictContainerPreemptions() != null) {
            pMsg = (PreemptionMessage)this.recordFactory.newRecordInstance(PreemptionMessage.class);
            StrictPreemptionContract pStrict = (StrictPreemptionContract)this.recordFactory.newRecordInstance(StrictPreemptionContract.class);
            pCont = new HashSet<PreemptionContainer>();
            for (ContainerId cId : allocation.getStrictContainerPreemptions()) {
                pc = (PreemptionContainer)this.recordFactory.newRecordInstance(PreemptionContainer.class);
                pc.setId(cId);
                pCont.add(pc);
            }
            pStrict.setContainers(pCont);
            pMsg.setStrictContract(pStrict);
        }
        if (allocation.getResourcePreemptions() != null && allocation.getResourcePreemptions().size() > 0 && allocation.getContainerPreemptions() != null && allocation.getContainerPreemptions().size() > 0) {
            if (pMsg == null) {
                pMsg = (PreemptionMessage)this.recordFactory.newRecordInstance(PreemptionMessage.class);
            }
            PreemptionContract contract = (PreemptionContract)this.recordFactory.newRecordInstance(PreemptionContract.class);
            pCont = new HashSet();
            for (ContainerId cId : allocation.getContainerPreemptions()) {
                pc = (PreemptionContainer)this.recordFactory.newRecordInstance(PreemptionContainer.class);
                pc.setId(cId);
                pCont.add(pc);
            }
            ArrayList<PreemptionResourceRequest> pRes = new ArrayList<PreemptionResourceRequest>();
            for (ResourceRequest crr : allocation.getResourcePreemptions()) {
                PreemptionResourceRequest prr = (PreemptionResourceRequest)this.recordFactory.newRecordInstance(PreemptionResourceRequest.class);
                prr.setResourceRequest(crr);
                pRes.add(prr);
            }
            contract.setContainers(pCont);
            contract.setResourceRequest(pRes);
            pMsg.setContract(contract);
        }
        return pMsg;
    }

    public void registerAppAttempt(ApplicationAttemptId attemptId) {
        AllocateResponse response = (AllocateResponse)this.recordFactory.newRecordInstance(AllocateResponse.class);
        response.setResponseId(-1);
        LOG.info((Object)("Registering app attempt : " + attemptId));
        this.responseMap.put(attemptId, new AllocateResponseLock(response));
        this.rmContext.getNMTokenSecretManager().registerApplicationAttempt(attemptId);
    }

    public void unregisterAttempt(ApplicationAttemptId attemptId) {
        LOG.info((Object)("Unregistering app attempt : " + attemptId));
        this.responseMap.remove(attemptId);
        this.rmContext.getNMTokenSecretManager().unregisterApplicationAttempt(attemptId);
    }

    public void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    public static class AllocateResponseLock {
        private AllocateResponse response;

        public AllocateResponseLock(AllocateResponse response) {
            this.response = response;
        }

        public synchronized AllocateResponse getAllocateResponse() {
            return this.response;
        }

        public synchronized void setAllocateResponse(AllocateResponse response) {
            this.response = response;
        }
    }
}

