/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.CapacitySchedulerPreemptionContext;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.IntraQueueCandidatesSelector;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.IntraQueuePreemptionComputePlugin;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempAppPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempQueuePerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class FifoIntraQueuePreemptionPlugin
implements IntraQueuePreemptionComputePlugin {
    protected final CapacitySchedulerPreemptionContext context;
    protected final ResourceCalculator rc;
    private static final Log LOG = LogFactory.getLog(FifoIntraQueuePreemptionPlugin.class);

    public FifoIntraQueuePreemptionPlugin(ResourceCalculator rc, CapacitySchedulerPreemptionContext preemptionContext) {
        this.context = preemptionContext;
        this.rc = rc;
    }

    @Override
    public Map<String, Resource> getResourceDemandFromAppsPerQueue(String queueName, String partition) {
        HashMap<String, Resource> resToObtainByPartition = new HashMap<String, Resource>();
        TempQueuePerPartition tq = this.context.getQueueByPartition(queueName, partition);
        Collection<TempAppPerPartition> appsOrderedByPriority = tq.getApps();
        Resource actualPreemptNeeded = (Resource)resToObtainByPartition.get(partition);
        if (actualPreemptNeeded == null) {
            actualPreemptNeeded = Resources.createResource((int)0, (int)0);
            resToObtainByPartition.put(partition, actualPreemptNeeded);
        }
        for (TempAppPerPartition a1 : appsOrderedByPriority) {
            Resources.addTo((Resource)actualPreemptNeeded, (Resource)a1.getActuallyToBePreempted());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Selected to preempt " + actualPreemptNeeded + " resource from partition:" + partition));
        }
        return resToObtainByPartition;
    }

    @Override
    public void computeAppsIdealAllocation(Resource clusterResource, Resource partitionBasedResource, TempQueuePerPartition tq, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource totalPreemptedResourceAllowed, Resource queueReassignableResource, float maxAllowablePreemptLimit) {
        HashMap<String, Resource> perUserAMUsed = new HashMap<String, Resource>();
        Resource amUsed = this.calculateUsedAMResourcesPerQueue(tq.partition, tq.leafQueue, perUserAMUsed);
        Resources.subtractFrom((Resource)queueReassignableResource, (Resource)amUsed);
        Collection<FiCaSchedulerApp> apps = tq.leafQueue.getAllApplications();
        if (apps.size() == 1) {
            return;
        }
        IntraQueueCandidatesSelector.TAPriorityComparator taComparator = new IntraQueueCandidatesSelector.TAPriorityComparator();
        PriorityQueue<TempAppPerPartition> orderedByPriority = this.createTempAppForResCalculation(tq.partition, apps, taComparator);
        TreeSet<TempAppPerPartition> orderedApps = this.calculateIdealAssignedResourcePerApp(clusterResource, partitionBasedResource, tq, selectedCandidates, queueReassignableResource, orderedByPriority, perUserAMUsed);
        Resource maxIntraQueuePreemptable = Resources.multiply((Resource)tq.getGuaranteed(), (double)maxAllowablePreemptLimit);
        if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)maxIntraQueuePreemptable, (Resource)tq.getActuallyToBePreempted())) {
            Resources.subtractFrom((Resource)maxIntraQueuePreemptable, (Resource)tq.getActuallyToBePreempted());
        } else {
            maxIntraQueuePreemptable = Resource.newInstance((int)0, (int)0);
        }
        Resource preemptionLimit = Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)maxIntraQueuePreemptable, (Resource)totalPreemptedResourceAllowed);
        this.calculateToBePreemptedResourcePerApp(clusterResource, orderedApps, preemptionLimit);
        tq.addAllApps(orderedApps);
        this.validateOutSameAppPriorityFromDemand(clusterResource, (TreeSet)tq.getApps());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Queue Name:" + tq.queueName + ", partition:" + tq.partition));
            for (TempAppPerPartition tmpApp : tq.getApps()) {
                LOG.debug((Object)tmpApp);
            }
        }
    }

    private void calculateToBePreemptedResourcePerApp(Resource clusterResource, TreeSet<TempAppPerPartition> orderedApps, Resource preemptionLimit) {
        for (TempAppPerPartition tmpApp : orderedApps) {
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)preemptionLimit, (Resource)Resources.none()) || Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)tmpApp.getUsed(), (Resource)Resources.none())) continue;
            Resource preemtableFromApp = Resources.subtract((Resource)tmpApp.getUsed(), (Resource)tmpApp.idealAssigned);
            Resources.subtractFrom((Resource)preemtableFromApp, (Resource)tmpApp.selected);
            Resources.subtractFrom((Resource)preemtableFromApp, (Resource)tmpApp.getAMUsed());
            tmpApp.toBePreempted = Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)Resources.max((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)preemtableFromApp, (Resource)Resources.none()), (Resource)preemptionLimit);
            preemptionLimit = Resources.subtract((Resource)preemptionLimit, (Resource)tmpApp.toBePreempted);
        }
    }

    private TreeSet<TempAppPerPartition> calculateIdealAssignedResourcePerApp(Resource clusterResource, Resource partitionBasedResource, TempQueuePerPartition tq, Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, Resource queueReassignableResource, PriorityQueue<TempAppPerPartition> orderedByPriority, Map<String, Resource> perUserAMUsed) {
        Comparator<TempAppPerPartition> reverseComp = Collections.reverseOrder(new IntraQueueCandidatesSelector.TAPriorityComparator());
        TreeSet<TempAppPerPartition> orderedApps = new TreeSet<TempAppPerPartition>(reverseComp);
        HashMap<String, Resource> userIdealAssignedMapping = new HashMap<String, Resource>();
        String partition = tq.partition;
        HashMap<String, Resource> preCalculatedUserLimit = new HashMap<String, Resource>();
        while (!orderedByPriority.isEmpty()) {
            Resource idealAssignedForUser;
            TempAppPerPartition tmpApp = (TempAppPerPartition)orderedByPriority.remove();
            orderedApps.add(tmpApp);
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)queueReassignableResource, (Resource)Resources.none())) continue;
            String userName = tmpApp.app.getUser();
            Resource userLimitResource = (Resource)preCalculatedUserLimit.get(userName);
            if (userLimitResource == null) {
                userLimitResource = Resources.clone((Resource)tq.leafQueue.getUserLimitPerUser(userName, partitionBasedResource, partition));
                Resource amUsed = perUserAMUsed.get(userName);
                if (null == amUsed) {
                    amUsed = Resources.createResource((int)0, (int)0);
                }
                userLimitResource = Resources.subtract((Resource)userLimitResource, (Resource)amUsed);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Userlimit for user '" + userName + "' is :" + userLimitResource + ", and amUsed is:" + amUsed));
                }
                preCalculatedUserLimit.put(userName, userLimitResource);
            }
            if ((idealAssignedForUser = (Resource)userIdealAssignedMapping.get(userName)) == null) {
                idealAssignedForUser = Resources.createResource((int)0, (int)0);
                userIdealAssignedMapping.put(userName, idealAssignedForUser);
            }
            this.getAlreadySelectedPreemptionCandidatesResource(selectedCandidates, tmpApp, partition);
            Resource appIdealAssigned = Resources.add((Resource)tmpApp.getUsedDeductAM(), (Resource)tmpApp.getPending());
            Resources.subtractFrom((Resource)appIdealAssigned, (Resource)tmpApp.selected);
            if (!Resources.lessThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)idealAssignedForUser, (Resource)userLimitResource)) continue;
            appIdealAssigned = Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)appIdealAssigned, (Resource)Resources.subtract((Resource)userLimitResource, (Resource)idealAssignedForUser));
            tmpApp.idealAssigned = Resources.clone((Resource)Resources.min((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)queueReassignableResource, (Resource)appIdealAssigned));
            Resources.addTo((Resource)idealAssignedForUser, (Resource)tmpApp.idealAssigned);
            Resource appUsedExcludedSelected = Resources.subtract((Resource)tmpApp.getUsedDeductAM(), (Resource)tmpApp.selected);
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)clusterResource, (Resource)tmpApp.idealAssigned, (Resource)appUsedExcludedSelected)) {
                tmpApp.setToBePreemptFromOther(Resources.subtract((Resource)tmpApp.idealAssigned, (Resource)appUsedExcludedSelected));
            }
            Resources.subtractFrom((Resource)queueReassignableResource, (Resource)tmpApp.idealAssigned);
        }
        return orderedApps;
    }

    private void getAlreadySelectedPreemptionCandidatesResource(Map<ApplicationAttemptId, Set<RMContainer>> selectedCandidates, TempAppPerPartition tmpApp, String partition) {
        tmpApp.selected = Resources.createResource((int)0, (int)0);
        Set<RMContainer> containers = selectedCandidates.get(tmpApp.app.getApplicationAttemptId());
        if (containers == null) {
            return;
        }
        for (RMContainer cont : containers) {
            if (!partition.equals(cont.getNodeLabelExpression())) continue;
            Resources.addTo((Resource)tmpApp.selected, (Resource)cont.getAllocatedResource());
        }
    }

    private PriorityQueue<TempAppPerPartition> createTempAppForResCalculation(String partition, Collection<FiCaSchedulerApp> apps, IntraQueueCandidatesSelector.TAPriorityComparator taComparator) {
        PriorityQueue<TempAppPerPartition> orderedByPriority = new PriorityQueue<TempAppPerPartition>(100, taComparator);
        for (FiCaSchedulerApp app : apps) {
            Resource used = app.getAppAttemptResourceUsage().getUsed(partition);
            Resource amUsed = null;
            if (!app.isWaitingForAMContainer()) {
                amUsed = app.getAMResource(partition);
            }
            Resource pending = app.getTotalPendingRequestsPerPartition().get(partition);
            Resource reserved = app.getAppAttemptResourceUsage().getReserved(partition);
            used = used == null ? Resources.createResource((int)0, (int)0) : used;
            amUsed = amUsed == null ? Resources.createResource((int)0, (int)0) : amUsed;
            pending = pending == null ? Resources.createResource((int)0, (int)0) : pending;
            reserved = reserved == null ? Resources.createResource((int)0, (int)0) : reserved;
            HashSet<String> partitions = new HashSet<String>(app.getAppAttemptResourceUsage().getNodePartitionsSet());
            partitions.addAll(app.getTotalPendingRequestsPerPartition().keySet());
            TempAppPerPartition tmpApp = new TempAppPerPartition(app, Resources.clone((Resource)used), Resources.clone((Resource)amUsed), Resources.clone((Resource)reserved), Resources.clone((Resource)pending));
            tmpApp.idealAssigned = Resources.createResource((int)0, (int)0);
            orderedByPriority.add(tmpApp);
        }
        return orderedByPriority;
    }

    public void validateOutSameAppPriorityFromDemand(Resource cluster, TreeSet<TempAppPerPartition> appsOrderedfromLowerPriority) {
        TempAppPerPartition[] apps = appsOrderedfromLowerPriority.toArray(new TempAppPerPartition[appsOrderedfromLowerPriority.size()]);
        if (apps.length <= 0) {
            return;
        }
        int lPriority = 0;
        int hPriority = apps.length - 1;
        while (lPriority < hPriority && !apps[lPriority].equals(apps[hPriority]) && apps[lPriority].getPriority() < apps[hPriority].getPriority()) {
            Resource toPreemptFromOther = apps[hPriority].getToBePreemptFromOther();
            Resource actuallyToPreempt = apps[lPriority].getActuallyToBePreempted();
            Resource delta = Resources.subtract((Resource)apps[lPriority].toBePreempted, (Resource)actuallyToPreempt);
            if (Resources.greaterThan((ResourceCalculator)this.rc, (Resource)cluster, (Resource)delta, (Resource)Resources.none())) {
                Resource toPreempt = Resources.min((ResourceCalculator)this.rc, (Resource)cluster, (Resource)toPreemptFromOther, (Resource)delta);
                apps[hPriority].setToBePreemptFromOther(Resources.subtract((Resource)toPreemptFromOther, (Resource)toPreempt));
                apps[lPriority].setActuallyToBePreempted(Resources.add((Resource)actuallyToPreempt, (Resource)toPreempt));
            }
            if (Resources.lessThanOrEqual((ResourceCalculator)this.rc, (Resource)cluster, (Resource)apps[lPriority].toBePreempted, (Resource)apps[lPriority].getActuallyToBePreempted())) {
                ++lPriority;
                continue;
            }
            if (!Resources.equals((Resource)apps[hPriority].getToBePreemptFromOther(), (Resource)Resources.none())) continue;
            --hPriority;
        }
    }

    private Resource calculateUsedAMResourcesPerQueue(String partition, LeafQueue leafQueue, Map<String, Resource> perUserAMUsed) {
        Collection<FiCaSchedulerApp> runningApps = leafQueue.getApplications();
        Resource amUsed = Resources.createResource((int)0, (int)0);
        for (FiCaSchedulerApp app : runningApps) {
            Resource userAMResource = perUserAMUsed.get(app.getUser());
            if (null == userAMResource) {
                userAMResource = Resources.createResource((int)0, (int)0);
                perUserAMUsed.put(app.getUser(), userAMResource);
            }
            Resources.addTo((Resource)userAMResource, (Resource)app.getAMResource(partition));
            Resources.addTo((Resource)amUsed, (Resource)app.getAMResource(partition));
        }
        return amUsed;
    }
}

