/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestCleanupCompactedFileOnRegionClose {
    private static HBaseTestingUtility util;

    @BeforeClass
    public static void beforeClass() throws Exception {
        util = new HBaseTestingUtility();
        util.getConfiguration().setInt("hbase.hstore.compaction.min", 100);
        util.getConfiguration().set("dfs.blocksize", "64000");
        util.getConfiguration().set("dfs.namenode.fs-limits.min-block-size", "1024");
        util.getConfiguration().set("hbase.master.hfilecleaner.ttl", "0");
        util.startMiniCluster(2);
    }

    @AfterClass
    public static void afterclass() throws Exception {
        util.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanupOnClose() throws Exception {
        TableName tableName = TableName.valueOf((String)"testCleanupOnClose");
        String familyName = "f";
        byte[] familyNameBytes = Bytes.toBytes((String)familyName);
        util.createTable(tableName, familyName);
        HBaseAdmin hBaseAdmin = util.getHBaseAdmin();
        Table table = util.getConnection().getTable(tableName);
        HRegionServer rs = util.getRSForFirstRegionInTable(tableName);
        Region region = (Region)rs.getOnlineRegions(tableName).get(0);
        int refSFCount = 4;
        for (int i = 0; i < refSFCount; ++i) {
            for (int j = 0; j < refSFCount; ++j) {
                Put put = new Put(Bytes.toBytes((int)j));
                put.addColumn(familyNameBytes, Bytes.toBytes((int)i), Bytes.toBytes((int)j));
                table.put(put);
            }
            util.flush(tableName);
        }
        Assert.assertEquals((long)refSFCount, (long)region.getStoreFileList((byte[][])new byte[][]{familyNameBytes}).size());
        Delete delete = new Delete(Bytes.toBytes((int)(refSFCount - 1)));
        table.delete(delete);
        util.flush(tableName);
        Assert.assertFalse((boolean)table.exists(new Get(Bytes.toBytes((int)(refSFCount - 1)))));
        Scan scan = new Scan();
        scan.setStopRow(Bytes.toBytes((int)(refSFCount - 2)));
        scan.setCaching(1);
        ResultScanner scanner = table.getScanner(scan);
        Result res = scanner.next();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((long)refSFCount, (long)res.getFamilyMap(familyNameBytes).size());
        int count = 0;
        Iterator i$ = region.getStore(familyNameBytes).getStorefiles().iterator();
        while (i$.hasNext()) {
            StoreFile sf;
            StoreFile storeFile = sf = (StoreFile)i$.next();
            synchronized (storeFile) {
                if (count < refSFCount) {
                    Assert.assertTrue((boolean)sf.getReader().isReferencedInReads());
                } else {
                    Assert.assertFalse((boolean)sf.getReader().isReferencedInReads());
                }
            }
            ++count;
        }
        util.compact(tableName, true);
        Assert.assertEquals((long)1L, (long)region.getStoreFileList((byte[][])new byte[][]{familyNameBytes}).size());
        Assert.assertEquals((long)(refSFCount + 1), (long)((HStore)region.getStore(familyNameBytes)).getStoreEngine().getStoreFileManager().getCompactedfiles().size());
        hBaseAdmin.unassign(region.getRegionInfo().getRegionName(), false);
        hBaseAdmin.assign(region.getRegionInfo().getRegionName());
        util.waitUntilNoRegionsInTransition(10000L);
        Assert.assertFalse((String)"Deleted row should not exist", (boolean)table.exists(new Get(Bytes.toBytes((int)(refSFCount - 1)))));
        rs = util.getRSForFirstRegionInTable(tableName);
        region = (Region)rs.getOnlineRegions(tableName).get(0);
        Assert.assertEquals((long)1L, (long)region.getStoreFileList((byte[][])new byte[][]{familyNameBytes}).size());
        TestCase.assertNull((Object)((HStore)region.getStore(familyNameBytes)).getStoreEngine().getStoreFileManager().getCompactedfiles());
    }

    @Test
    public void testIOExceptionThrownOnClose() throws Exception {
        byte[] filler = new byte[128000];
        TableName tableName = TableName.valueOf((String)"testIOExceptionThrownOnClose");
        String familyName = "f";
        byte[] familyNameBytes = Bytes.toBytes((String)familyName);
        util.createTable(tableName, familyName);
        Table table = util.getConnection().getTable(tableName);
        HRegionServer rs = util.getRSForFirstRegionInTable(tableName);
        Region region = (Region)rs.getOnlineRegions(tableName).get(0);
        int refSFCount = 4;
        for (int i = 0; i < refSFCount; ++i) {
            for (int j = 0; j < refSFCount; ++j) {
                Put put = new Put(Bytes.toBytes((int)j));
                put.addColumn(familyNameBytes, Bytes.toBytes((int)i), filler);
                table.put(put);
            }
            util.flush(tableName);
        }
        Assert.assertEquals((long)refSFCount, (long)region.getStoreFileList((byte[][])new byte[][]{familyNameBytes}).size());
        HStore store = (HStore)region.getStore(familyNameBytes);
        StoreFile hsf = (StoreFile)region.getStore(familyNameBytes).getStorefiles().iterator().next();
        long readPt = region.getReadpoint(IsolationLevel.READ_COMMITTED);
        StoreFileScanner preadScanner = hsf.getReader().getStoreFileScanner(false, true, false, readPt, 0L, false);
        preadScanner.seek((Cell)KeyValue.LOWESTKEY);
        util.compact(tableName, true);
        Assert.assertNotNull((Object)preadScanner.next());
        store.closeAndArchiveCompactedFiles(true);
        try {
            Assert.assertNotNull((Object)preadScanner.next());
            Assert.fail((String)"Expected IOException");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

