/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRegionServerMetrics {
    private static MetricsAssertHelper metricsHelper;
    private static MiniHBaseCluster cluster;
    private static HRegionServer rs;
    private static Configuration conf;
    private static HBaseTestingUtility TEST_UTIL;
    private static MetricsRegionServer metricsRegionServer;
    private static MetricsRegionServerSource serverSource;
    private static final int NUM_SCAN_NEXT = 30;
    private static int numScanNext;

    @BeforeClass
    public static void startCluster() throws Exception {
        metricsHelper = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.getLong("hbase.splitlog.max.resubmit", 0L);
        conf.setInt("zookeeper.recovery.retry", 0);
        conf.setInt("hbase.regionserver.periodicmemstoreflusher.rangeofdelayseconds", 240);
        conf.setInt("hbase.regionserver.info.port", -1);
        TEST_UTIL.startMiniCluster(1, 1);
        cluster = TEST_UTIL.getHBaseCluster();
        cluster.waitForActiveAndReadyMaster();
        while (cluster.getLiveRegionServerThreads().size() < 1) {
            Threads.sleep((long)100L);
        }
        rs = cluster.getRegionServer(0);
        metricsRegionServer = rs.getRegionServerMetrics();
        serverSource = metricsRegionServer.getMetricsSource();
    }

    @AfterClass
    public static void after() throws Exception {
        if (TEST_UTIL != null) {
            TEST_UTIL.shutdownMiniCluster();
        }
    }

    @Test(timeout=300000L)
    public void testRegionCount() throws Exception {
        String regionMetricsKey = "regionCount";
        long regions = metricsHelper.getGaugeLong(regionMetricsKey, (BaseSource)serverSource);
        TEST_UTIL.createTable(TableName.valueOf((String)"table"), Bytes.toBytes((String)"cf"));
        metricsHelper.assertGaugeGt(regionMetricsKey, regions, (BaseSource)serverSource);
    }

    @Test
    public void testLocalFiles() throws Exception {
        metricsHelper.assertGauge("percentFilesLocal", 0L, (BaseSource)serverSource);
        metricsHelper.assertGauge("percentFilesLocalSecondaryRegions", 0L, (BaseSource)serverSource);
    }

    @Test
    public void testRequestCount() throws Exception {
        String tableNameString = "testRequestCount";
        TableName tName = TableName.valueOf((String)tableNameString);
        byte[] cfName = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] initValue = Bytes.toBytes((String)"Value");
        TEST_UTIL.createTable(tName, cfName);
        Connection connection = TEST_UTIL.getConnection();
        connection.getTable(tName).close();
        Table table = connection.getTable(tName);
        Put p = new Put(row);
        p.add(cfName, qualifier, initValue);
        table.put(p);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long requests = metricsHelper.getCounter("totalRequestCount", (BaseSource)serverSource);
        long rowActionRequests = metricsHelper.getCounter("totalRowActionRequestCount", (BaseSource)serverSource);
        long readRequests = metricsHelper.getCounter("readRequestCount", (BaseSource)serverSource);
        long writeRequests = metricsHelper.getCounter("writeRequestCount", (BaseSource)serverSource);
        for (int i = 0; i < 30; ++i) {
            table.put(p);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 30L, (BaseSource)serverSource);
        metricsHelper.assertCounter("totalRowActionRequestCount", rowActionRequests + 30L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        Get g = new Get(row);
        for (int i = 0; i < 10; ++i) {
            table.get(g);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 40L, (BaseSource)serverSource);
        metricsHelper.assertCounter("totalRowActionRequestCount", rowActionRequests + 40L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 10L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        try (RegionLocator locator = connection.getRegionLocator(tName);){
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_getCount", 10L, (BaseSource)agg);
                metricsHelper.assertCounter(prefix + "_putCount", 31L, (BaseSource)agg);
            }
        }
        ArrayList<Get> gets = new ArrayList<Get>();
        for (int i = 0; i < 10; ++i) {
            gets.add(new Get(row));
        }
        table.get(gets);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", ++requests + 41L, (BaseSource)serverSource);
        metricsHelper.assertCounter("totalRowActionRequestCount", ++rowActionRequests + 50L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", ++readRequests + 20L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 30L, (BaseSource)serverSource);
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int i = 0; i < 30; ++i) {
            Put put = new Put(Bytes.toBytes((String)("" + i + "row"))).addColumn(cfName, qualifier, initValue);
            puts.add(put);
        }
        table.put(puts);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 42L, (BaseSource)serverSource);
        metricsHelper.assertCounter("totalRowActionRequestCount", rowActionRequests + 80L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 20L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 60L, (BaseSource)serverSource);
        this.doScan(table, 10, false);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 52L, (BaseSource)serverSource);
        metricsHelper.assertCounter("totalRowActionRequestCount", rowActionRequests + 90L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 30L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 60L, (BaseSource)serverSource);
        this.doScan(table, 10, true);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("totalRequestCount", requests + 53L, (BaseSource)serverSource);
        metricsHelper.assertCounter("totalRowActionRequestCount", rowActionRequests + 100L, (BaseSource)serverSource);
        metricsHelper.assertCounter("readRequestCount", readRequests + 40L, (BaseSource)serverSource);
        metricsHelper.assertCounter("writeRequestCount", writeRequests + 60L, (BaseSource)serverSource);
        table.close();
    }

    public void doScan(Table table, int n, boolean caching) throws IOException {
        Scan scan = new Scan();
        if (caching) {
            scan.setCaching(n);
        } else {
            scan.setCaching(1);
        }
        ResultScanner scanner = table.getScanner(scan);
        for (int i = 0; i < n; ++i) {
            scanner.next();
        }
    }

    @Test
    public void testGet() throws Exception {
        String tableNameString = "testGet";
        TableName tName = TableName.valueOf((String)tableNameString);
        byte[] cfName = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] initValue = Bytes.toBytes((String)"Value");
        TEST_UTIL.createTable(tName, cfName);
        Connection connection = TEST_UTIL.getConnection();
        connection.getTable(tName).close();
        Table table = connection.getTable(tName);
        Put p = new Put(row);
        p.addColumn(cfName, qualifier, initValue);
        table.put(p);
        Get g = new Get(row);
        for (int i = 0; i < 10; ++i) {
            table.get(g);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        try (RegionLocator locator = connection.getRegionLocator(tName);){
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_getCount", 10L, (BaseSource)agg);
                metricsHelper.assertCounter(prefix + "_getCount", 10L, (BaseSource)agg);
            }
            metricsHelper.assertCounterGt("Get_num_ops", 10L, (BaseSource)serverSource);
        }
        table.close();
    }

    @Test
    public void testMutationsWithoutWal() throws Exception {
        TableName tableName = TableName.valueOf((String)"testMutationsWithoutWal");
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        p.setDurability(Durability.SKIP_WAL);
        t.put(p);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("mutationsWithoutWALCount", 1L, (BaseSource)serverSource);
        long minLength = row.length + cf.length + qualifier.length + val.length;
        metricsHelper.assertGaugeGt("mutationsWithoutWALSize", minLength, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testStoreCount() throws Exception {
        TableName tableName = TableName.valueOf((String)"testStoreCount");
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"Value");
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long stores = metricsHelper.getGaugeLong("storeCount", (BaseSource)serverSource);
        long storeFiles = metricsHelper.getGaugeLong("storeFileCount", (BaseSource)serverSource);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertGauge("storeCount", stores + 1L, (BaseSource)serverSource);
        metricsHelper.assertGauge("storeFileCount", storeFiles + 1L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testStoreFileAge() throws Exception {
        TableName tableName = TableName.valueOf((String)"testStoreFileAge");
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"Value");
        HTable t = TEST_UTIL.createTable(tableName, cf);
        Put p = new Put(row);
        p.addColumn(cf, qualifier, val);
        t.put(p);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        Assert.assertTrue((metricsHelper.getGaugeLong("maxStoreFileAge", (BaseSource)serverSource) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((metricsHelper.getGaugeLong("minStoreFileAge", (BaseSource)serverSource) > 0L ? 1 : 0) != 0);
        Assert.assertTrue((metricsHelper.getGaugeLong("avgStoreFileAge", (BaseSource)serverSource) > 0L ? 1 : 0) != 0);
        t.close();
    }

    @Test
    public void testCheckAndPutCount() throws Exception {
        String tableNameString = "testCheckAndPutCount";
        TableName tableName = TableName.valueOf((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] valOne = Bytes.toBytes((String)"Value");
        byte[] valTwo = Bytes.toBytes((String)"ValueTwo");
        byte[] valThree = Bytes.toBytes((String)"ValueThree");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, valOne);
        t.put(p);
        Put pTwo = new Put(row);
        pTwo.add(cf, qualifier, valTwo);
        t.checkAndPut(row, cf, qualifier, valOne, pTwo);
        Put pThree = new Put(row);
        pThree.add(cf, qualifier, valThree);
        t.checkAndPut(row, cf, qualifier, valOne, pThree);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("checkMutateFailedCount", 1L, (BaseSource)serverSource);
        metricsHelper.assertCounter("checkMutatePassedCount", 1L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testIncrement() throws Exception {
        String tableNameString = "testIncrement";
        TableName tableName = TableName.valueOf((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((long)0L);
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        for (int count = 0; count < 13; ++count) {
            Increment inc = new Increment(row);
            inc.addColumn(cf, qualifier, 100L);
            t.increment(inc);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("incrementNumOps", 13L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testAppend() throws Exception {
        String tableNameString = "testAppend";
        TableName tableName = TableName.valueOf((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"One");
        TEST_UTIL.createTable(tableName, cf);
        HTable t = new HTable(conf, tableName);
        Put p = new Put(row);
        p.add(cf, qualifier, val);
        t.put(p);
        for (int count = 0; count < 73; ++count) {
            Append append = new Append(row);
            append.add(cf, qualifier, Bytes.toBytes((String)",Test"));
            t.append(append);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        metricsHelper.assertCounter("appendNumOps", 73L, (BaseSource)serverSource);
        t.close();
    }

    @Test
    public void testScanSize() throws IOException {
        String tableNameString = "testScanSize";
        TableName tableName = TableName.valueOf((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"One");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int insertCount = 0; insertCount < 100; ++insertCount) {
            Put p = new Put(Bytes.toBytes((String)("" + insertCount + "row")));
            p.add(cf, qualifier, val);
            puts.add(p);
        }
        try (HTable t = TEST_UTIL.createTable(tableName, cf);){
            t.put(puts);
            Scan s = new Scan();
            s.setBatch(1);
            s.setCaching(1);
            ResultScanner resultScanners = t.getScanner(s);
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
            }
        }
        numScanNext += 30;
        var8_9 = null;
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_scanCount", 30L, (BaseSource)agg);
            }
            metricsHelper.assertCounterGt("ScanSize_num_ops", (long)numScanNext, (BaseSource)serverSource);
        }
        catch (Throwable x2) {
            var8_9 = x2;
            throw x2;
        }
        var8_9 = null;
        try (HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();){
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testScanTime() throws IOException {
        String tableNameString = "testScanTime";
        TableName tableName = TableName.valueOf((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"One");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int insertCount = 0; insertCount < 100; ++insertCount) {
            Put p = new Put(Bytes.toBytes((String)("" + insertCount + "row")));
            p.addColumn(cf, qualifier, val);
            puts.add(p);
        }
        try (HTable t = TEST_UTIL.createTable(tableName, cf);){
            t.put(puts);
            Scan s = new Scan();
            s.setBatch(1);
            s.setCaching(1);
            ResultScanner resultScanners = t.getScanner(s);
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
            }
        }
        numScanNext += 30;
        var8_9 = null;
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_scanCount", 30L, (BaseSource)agg);
            }
            metricsHelper.assertCounterGt("ScanTime_num_ops", (long)numScanNext, (BaseSource)serverSource);
        }
        catch (Throwable x2) {
            var8_9 = x2;
            throw x2;
        }
        var8_9 = null;
        try (HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();){
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testScanSizeForSmallScan() throws IOException {
        String tableNameString = "testScanSizeSmall";
        TableName tableName = TableName.valueOf((String)tableNameString);
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"One");
        ArrayList<Put> puts = new ArrayList<Put>();
        for (int insertCount = 0; insertCount < 100; ++insertCount) {
            Put p = new Put(Bytes.toBytes((String)("" + insertCount + "row")));
            p.add(cf, qualifier, val);
            puts.add(p);
        }
        try (HTable t = TEST_UTIL.createTable(tableName, cf);){
            t.put(puts);
            Scan s = new Scan();
            s.setSmall(true);
            s.setCaching(1);
            ResultScanner resultScanners = t.getScanner(s);
            for (int nextCount = 0; nextCount < 30; ++nextCount) {
                Result result = resultScanners.next();
                Assert.assertNotNull((Object)result);
                Assert.assertEquals((long)1L, (long)result.size());
            }
        }
        numScanNext += 30;
        var8_9 = null;
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            int cnt = 0;
            for (HRegionLocation location : locator.getAllRegionLocations()) {
                ++cnt;
                HRegionInfo i = location.getRegionInfo();
                MetricsRegionAggregateSource agg = rs.getRegion(i.getRegionName()).getMetrics().getSource().getAggregateSource();
                String prefix = "namespace_" + NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR + "_table_" + tableNameString + "_region_" + i.getEncodedName() + "_metric";
                metricsHelper.assertCounter(prefix + "_scanCount", 30L, (BaseSource)agg);
            }
            metricsHelper.assertCounterGt("ScanSize_num_ops", (long)numScanNext, (BaseSource)serverSource);
        }
        catch (Throwable x2) {
            var8_9 = x2;
            throw x2;
        }
        var8_9 = null;
        try (HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();){
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
    }

    @Test
    @Ignore
    public void testRangeCountMetrics() throws Exception {
        long count;
        String dynamicMetricName;
        String tableNameString = "testRangeCountMetrics";
        long[] timeranges = new long[]{1L, 3L, 10L, 30L, 100L, 300L, 1000L, 3000L, 10000L, 30000L, 60000L, 120000L, 300000L, 600000L};
        String timeRangeType = "TimeRangeCount";
        String timeRangeMetricName = "Mutate";
        boolean timeRangeCountUpdated = false;
        TableName tName = TableName.valueOf((String)tableNameString);
        byte[] cfName = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] initValue = Bytes.toBytes((String)"Value");
        TEST_UTIL.createTable(tName, cfName);
        Connection connection = TEST_UTIL.getConnection();
        connection.getTable(tName).close();
        Table table = connection.getTable(tName);
        Put p = new Put(row);
        p.addColumn(cfName, qualifier, initValue);
        table.put(p);
        for (int i = 0; i < 10; ++i) {
            table.put(p);
        }
        Get g = new Get(row);
        for (int i = 0; i < 10; ++i) {
            table.get(g);
        }
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        long prior = 0L;
        for (int i = 0; i < timeranges.length; ++i) {
            long count2;
            dynamicMetricName = "Mutate_TimeRangeCount_" + prior + "-" + timeranges[i];
            if (metricsHelper.checkCounterExists(dynamicMetricName, (BaseSource)serverSource) && (count2 = metricsHelper.getGaugeLong(dynamicMetricName, (BaseSource)serverSource)) > 0L) {
                timeRangeCountUpdated = true;
                break;
            }
            prior = timeranges[i];
        }
        if (metricsHelper.checkCounterExists(dynamicMetricName = "Mutate_TimeRangeCount_" + timeranges[timeranges.length - 1] + "-inf", (BaseSource)serverSource) && (count = metricsHelper.getCounter(dynamicMetricName, (BaseSource)serverSource)) > 0L) {
            timeRangeCountUpdated = true;
        }
        Assert.assertEquals((Object)true, (Object)timeRangeCountUpdated);
        table.close();
    }

    @Test
    public void testAverageRegionSize() throws Exception {
        TableName tableName = TableName.valueOf((String)"testAverageRegionSize");
        byte[] cf = Bytes.toBytes((String)"d");
        byte[] row = Bytes.toBytes((String)"rk");
        byte[] qualifier = Bytes.toBytes((String)"qual");
        byte[] val = Bytes.toBytes((String)"Value");
        HTable t = TEST_UTIL.createTable(tableName, cf);
        Put p = new Put(row);
        p.addColumn(cf, qualifier, val);
        t.put(p);
        TEST_UTIL.getHBaseAdmin().flush(tableName);
        metricsRegionServer.getRegionServerWrapper().forceRecompute();
        Assert.assertTrue((metricsHelper.getGaugeDouble("averageRegionSize", (BaseSource)serverSource) > 0.0 ? 1 : 0) != 0);
        t.close();
    }

    static {
        Logger.getLogger((String)"org.apache.hadoop.hbase").setLevel(Level.DEBUG);
        numScanNext = 0;
    }
}

