/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSecureBulkLoadEndpoint {
    @Test
    public void testFileSystemsWithoutPermissionSupport() {
        Configuration emptyConf = new Configuration(false);
        Configuration defaultConf = HBaseConfiguration.create();
        HashSet<String> expectedDefaultIgnoredSchemes = new HashSet<String>(Arrays.asList(StringUtils.split((String)"s3,s3a,s3n,wasb,wasbs,swift,adfs,abfs,viewfs", (char)',')));
        SecureBulkLoadEndpoint endpoint = new SecureBulkLoadEndpoint();
        Set defaultIgnoredSchemes = endpoint.getFileSystemSchemesWithoutPermissionSupport(emptyConf);
        Assert.assertEquals((Object)defaultIgnoredSchemes, expectedDefaultIgnoredSchemes);
        defaultIgnoredSchemes = endpoint.getFileSystemSchemesWithoutPermissionSupport(defaultConf);
        Assert.assertEquals((Object)defaultIgnoredSchemes, expectedDefaultIgnoredSchemes);
        defaultConf.set("hbase.secure.bulkload.fs.permission.lacking", "foo,bar");
        defaultIgnoredSchemes = endpoint.getFileSystemSchemesWithoutPermissionSupport(defaultConf);
        Assert.assertEquals((Object)defaultIgnoredSchemes, new HashSet<String>(Arrays.asList("foo", "bar")));
    }
}

