/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeterogeneousRegionCountCostFunction
extends StochasticLoadBalancer.CostFunction {
    static final String HBASE_MASTER_BALANCER_HETEROGENEOUS_RULES_FILE = "hbase.master.balancer.heterogeneousRegionCountRulesFile";
    private static final Logger LOG = LoggerFactory.getLogger(HeterogeneousRegionCountCostFunction.class);
    private static final String HBASE_MASTER_BALANCER_HETEROGENEOUS_RULES_DEFAULT = "hbase.master.balancer.heterogeneousRegionCountDefault";
    private static final String REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.heterogeneousRegionCountCost";
    private static final float DEFAULT_REGION_COUNT_SKEW_COST = 500.0f;
    private final String rulesPath;
    private final Map<Pattern, Integer> limitPerRule;
    private final Map<ServerName, Integer> limitPerRS;
    private final Configuration conf;
    private int defaultNumberOfRegions;
    private int totalCapacity = 0;
    double overallUsage;

    public HeterogeneousRegionCountCostFunction(Configuration conf) {
        super(conf);
        this.conf = conf;
        this.limitPerRS = new HashMap<ServerName, Integer>();
        this.limitPerRule = new HashMap<Pattern, Integer>();
        this.setMultiplier(conf.getFloat(REGION_COUNT_SKEW_COST_KEY, 500.0f));
        this.rulesPath = conf.get(HBASE_MASTER_BALANCER_HETEROGENEOUS_RULES_FILE);
        this.defaultNumberOfRegions = conf.getInt(HBASE_MASTER_BALANCER_HETEROGENEOUS_RULES_DEFAULT, 200);
        if (this.defaultNumberOfRegions < 0) {
            LOG.warn("invalid configuration 'hbase.master.balancer.heterogeneousRegionCountDefault'. Setting default to 200");
            this.defaultNumberOfRegions = 200;
        }
        if (conf.getFloat("hbase.master.balancer.stochastic.regionCountCost", 500.0f) > 0.0f) {
            LOG.warn("regionCountCost is not set to 0,  this will interfere with the HeterogeneousRegionCountCostFunction!");
        }
    }

    @Override
    void init(BaseLoadBalancer.Cluster cluster) {
        this.cluster = cluster;
        this.loadRules();
    }

    @Override
    protected double cost() {
        double cost = 0.0;
        double targetUsage = (double)this.cluster.numRegions / (double)this.totalCapacity;
        for (int i = 0; i < this.cluster.numServers; ++i) {
            double nbrRegions = this.cluster.regionsPerServer[i].length;
            ServerName sn = this.cluster.servers[i];
            double limit = this.limitPerRS.containsKey(sn) ? (double)this.limitPerRS.get(sn).intValue() : (double)this.defaultNumberOfRegions;
            double usage = nbrRegions / limit;
            if (!(usage > targetUsage)) continue;
            double localCost = (nbrRegions - (double)Math.round(limit * targetUsage)) / limit;
            cost += localCost;
        }
        return cost / (double)this.cluster.numServers;
    }

    void loadRules() {
        List<String> lines = this.readFile(this.rulesPath);
        if (null == lines) {
            LOG.warn("cannot load rules file, keeping latest rules file which has " + this.limitPerRule.size() + " rules");
            return;
        }
        LOG.info("loading rules file '" + this.rulesPath + "'");
        this.limitPerRule.clear();
        for (String line : lines) {
            try {
                if (line.length() == 0 || line.startsWith("#")) continue;
                String[] splits = line.split(" ");
                if (splits.length != 2) {
                    throw new IOException("line '" + line + "' is malformated, " + "expected [regexp] [limit]. Skipping line");
                }
                Pattern pattern = Pattern.compile(splits[0]);
                Integer limit = Integer.parseInt(splits[1]);
                this.limitPerRule.put(pattern, limit);
            }
            catch (IOException | NumberFormatException | PatternSyntaxException e) {
                LOG.error("error on line: " + e);
            }
        }
        this.rebuildCache();
    }

    private List<String> readFile(String filename) {
        if (null == filename) {
            return null;
        }
        try {
            if (filename.startsWith("file:")) {
                return this.readFileFromLocalFS(filename);
            }
            return this.readFileFromHDFS(filename);
        }
        catch (IOException e) {
            LOG.error("cannot read rules file located at ' " + filename + " ':" + e.getMessage());
            return null;
        }
    }

    private List<String> readFileFromHDFS(String filename) throws IOException {
        Path path = new Path(filename);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
        return this.readLines(reader);
    }

    private List<String> readFileFromLocalFS(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        return this.readLines(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(BufferedReader reader) throws IOException {
        ArrayList<String> records = new ArrayList<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                records.add(line);
            }
        }
        finally {
            reader.close();
        }
        return records;
    }

    private void rebuildCache() {
        LOG.debug("Rebuilding cache of capacity for each RS");
        this.limitPerRS.clear();
        this.totalCapacity = 0;
        if (null == this.cluster) {
            return;
        }
        for (int i = 0; i < this.cluster.numServers; ++i) {
            ServerName sn = this.cluster.servers[i];
            int capacity = this.findLimitForRS(sn);
            LOG.debug(sn.getHostname() + " can hold " + capacity + " regions");
            this.totalCapacity += capacity;
        }
        this.overallUsage = (double)this.cluster.numRegions / (double)this.totalCapacity;
        LOG.info("Cluster can hold " + this.cluster.numRegions + "/" + this.totalCapacity + " regions (" + Math.round(this.overallUsage * 100.0) + "%)");
        if (this.overallUsage >= 1.0) {
            LOG.warn("Cluster is overused");
        }
    }

    int findLimitForRS(ServerName serverName) {
        boolean matched = false;
        int limit = -1;
        for (Map.Entry<Pattern, Integer> entry : this.limitPerRule.entrySet()) {
            if (!entry.getKey().matcher(serverName.getHostname()).matches()) continue;
            matched = true;
            limit = entry.getValue();
            break;
        }
        if (!matched) {
            limit = this.defaultNumberOfRegions;
        }
        this.limitPerRS.put(serverName, limit);
        return limit;
    }

    int getNumberOfRulesLoaded() {
        return this.limitPerRule.size();
    }
}

