/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
public class FailedServers {
    private final LinkedList<Pair<Long, Address>> failedServers = new LinkedList();
    private final int recheckServersTimeout;
    private static final Log LOG = LogFactory.getLog(FailedServers.class);

    public FailedServers(Configuration conf) {
        this.recheckServersTimeout = conf.getInt("hbase.ipc.client.failed.servers.expiry", 2000);
    }

    public synchronized void addToFailedServers(Address address, Throwable throwable) {
        long expiry = EnvironmentEdgeManager.currentTime() + (long)this.recheckServersTimeout;
        this.failedServers.addFirst(new Pair<Long, Address>(expiry, address));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added failed server with address " + address + " to list caused by " + throwable.toString()));
        }
    }

    public synchronized boolean isFailedServer(Address address) {
        if (this.failedServers.isEmpty()) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTime();
        Iterator it = this.failedServers.iterator();
        while (it.hasNext()) {
            Pair cur = (Pair)it.next();
            if ((Long)cur.getFirst() < now) {
                it.remove();
                continue;
            }
            if (!address.equals(cur.getSecond())) continue;
            return true;
        }
        return false;
    }
}

