/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2;

import org.apache.hadoop.hbase.shaded.io.netty.buffer.ByteBuf;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Error;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2HeadersDecoder;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.internal.hpack.Decoder;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.ObjectUtil;

public class DefaultHttp2HeadersDecoder
implements Http2HeadersDecoder,
Http2HeadersDecoder.Configuration {
    private static final float HEADERS_COUNT_WEIGHT_NEW = 0.2f;
    private static final float HEADERS_COUNT_WEIGHT_HISTORICAL = 0.8f;
    private final Decoder decoder;
    private final boolean validateHeaders;
    private float headerArraySizeAccumulator = 8.0f;

    public DefaultHttp2HeadersDecoder() {
        this(true);
    }

    public DefaultHttp2HeadersDecoder(boolean validateHeaders) {
        this(validateHeaders, 8192L);
    }

    public DefaultHttp2HeadersDecoder(boolean validateHeaders, long maxHeaderListSize) {
        this(validateHeaders, maxHeaderListSize, 32);
    }

    public DefaultHttp2HeadersDecoder(boolean validateHeaders, long maxHeaderListSize, int initialHuffmanDecodeCapacity) {
        this(validateHeaders, new Decoder(maxHeaderListSize, initialHuffmanDecodeCapacity));
    }

    DefaultHttp2HeadersDecoder(boolean validateHeaders, Decoder decoder) {
        this.decoder = ObjectUtil.checkNotNull(decoder, "decoder");
        this.validateHeaders = validateHeaders;
    }

    @Override
    public void maxHeaderTableSize(long max) throws Http2Exception {
        this.decoder.setMaxHeaderTableSize(max);
    }

    @Override
    public long maxHeaderTableSize() {
        return this.decoder.getMaxHeaderTableSize();
    }

    @Override
    public void maxHeaderListSize(long max, long goAwayMax) throws Http2Exception {
        this.decoder.setMaxHeaderListSize(max, goAwayMax);
    }

    @Override
    public long maxHeaderListSize() {
        return this.decoder.getMaxHeaderListSize();
    }

    @Override
    public long maxHeaderListSizeGoAway() {
        return this.decoder.getMaxHeaderListSizeGoAway();
    }

    @Override
    public Http2HeadersDecoder.Configuration configuration() {
        return this;
    }

    @Override
    public Http2Headers decodeHeaders(int streamId, ByteBuf headerBlock) throws Http2Exception {
        try {
            DefaultHttp2Headers headers = new DefaultHttp2Headers(this.validateHeaders, (int)this.headerArraySizeAccumulator);
            this.decoder.decode(streamId, headerBlock, headers);
            this.headerArraySizeAccumulator = 0.2f * (float)headers.size() + 0.8f * this.headerArraySizeAccumulator;
            return headers;
        }
        catch (Http2Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw Http2Exception.connectionError(Http2Error.COMPRESSION_ERROR, e, e.getMessage(), new Object[0]);
        }
    }
}

