/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MasterMaintenanceModeTracker
extends ZKListener {
    private boolean hasChildren = false;

    public MasterMaintenanceModeTracker(ZKWatcher watcher) {
        super(watcher);
    }

    public boolean isInMaintenanceMode() {
        return this.hasChildren;
    }

    private void update(String path) {
        if (path.startsWith(this.watcher.znodePaths.masterMaintZNode)) {
            this.update();
        }
    }

    private void update() {
        try {
            List<String> children = ZKUtil.listChildrenAndWatchForNewChildren(this.watcher, this.watcher.znodePaths.masterMaintZNode);
            this.hasChildren = children != null && children.size() > 0;
        }
        catch (KeeperException e) {
            this.hasChildren = false;
        }
    }

    public void start() {
        this.watcher.registerListener(this);
        this.update();
    }

    @Override
    public void nodeCreated(String path) {
        this.update(path);
    }

    @Override
    public void nodeDeleted(String path) {
        this.update(path);
    }

    @Override
    public void nodeChildrenChanged(String path) {
        this.update(path);
    }
}

