/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.healthcheck.ParticipantHealthReportCollectorImpl;
import org.apache.log4j.Logger;

public class ParticipantHealthReportTask
extends HelixTimerTask {
    private static final Logger LOG = Logger.getLogger(ParticipantHealthReportTask.class);
    public static final int DEFAULT_REPORT_LATENCY = 60000;
    Timer _timer;
    final ParticipantHealthReportCollectorImpl _healthReportCollector;

    public ParticipantHealthReportTask(ParticipantHealthReportCollectorImpl healthReportCollector) {
        this._healthReportCollector = healthReportCollector;
    }

    @Override
    public void start() {
        if (this._timer == null) {
            LOG.info((Object)"Start HealthCheckInfoReportingTask");
            this._timer = new Timer("ParticipantHealthReportTimerTask", true);
            this._timer.scheduleAtFixedRate((TimerTask)new ParticipantHealthReportTimerTask(), new Random().nextInt(60000), 60000L);
        } else {
            LOG.warn((Object)"ParticipantHealthReportTimerTask already started");
        }
    }

    @Override
    public void stop() {
        if (this._timer != null) {
            LOG.info((Object)"Stop ParticipantHealthReportTimerTask");
            this._timer.cancel();
            this._timer = null;
        } else {
            LOG.warn((Object)"ParticipantHealthReportTimerTask already stopped");
        }
    }

    class ParticipantHealthReportTimerTask
    extends TimerTask {
        ParticipantHealthReportTimerTask() {
        }

        @Override
        public void run() {
            ParticipantHealthReportTask.this._healthReportCollector.transmitHealthReports();
        }
    }
}

