/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.helix.monitoring.StatCollector;
import org.apache.helix.monitoring.StateTransitionContext;
import org.apache.helix.monitoring.StateTransitionDataPoint;
import org.apache.helix.monitoring.mbeans.StateTransitionStatMonitorMBean;

public class StateTransitionStatMonitor
implements StateTransitionStatMonitorMBean {
    private static final int DEFAULT_WINDOW_SIZE = 4000;
    private long _numDataPoints;
    private long _successCount;
    private TimeUnit _unit;
    private ConcurrentHashMap<LATENCY_TYPE, StatCollector> _monitorMap = new ConcurrentHashMap();
    StateTransitionContext _context;

    public StateTransitionStatMonitor(StateTransitionContext context, TimeUnit unit) {
        this._context = context;
        this._monitorMap.put(LATENCY_TYPE.TOTAL, new StatCollector());
        this._monitorMap.put(LATENCY_TYPE.EXECUTION, new StatCollector());
        this.reset();
    }

    public StateTransitionContext getContext() {
        return this._context;
    }

    public String getBeanName() {
        return this._context.getClusterName() + " " + this._context.getResourceName() + " " + this._context.getTransition();
    }

    public void addDataPoint(StateTransitionDataPoint data) {
        ++this._numDataPoints;
        if (data.getSuccess()) {
            ++this._successCount;
        }
        this.addLatency(LATENCY_TYPE.TOTAL, data.getTotalDelay());
        this.addLatency(LATENCY_TYPE.EXECUTION, data.getExecutionDelay());
    }

    void addLatency(LATENCY_TYPE type, double latency) {
        assert (this._monitorMap.containsKey((Object)type));
        this._monitorMap.get((Object)type).addData(latency);
    }

    public long getNumDataPoints() {
        return this._numDataPoints;
    }

    @Override
    public void reset() {
        this._numDataPoints = 0L;
        this._successCount = 0L;
        for (StatCollector monitor : this._monitorMap.values()) {
            monitor.reset();
        }
    }

    @Override
    public long getTotalStateTransitionGauge() {
        return this._numDataPoints;
    }

    @Override
    public long getTotalFailedTransitionGauge() {
        return this._numDataPoints - this._successCount;
    }

    @Override
    public long getTotalSuccessTransitionGauge() {
        return this._successCount;
    }

    @Override
    public double getMeanTransitionLatency() {
        return this._monitorMap.get((Object)LATENCY_TYPE.TOTAL).getMean();
    }

    @Override
    public double getMaxTransitionLatency() {
        return this._monitorMap.get((Object)LATENCY_TYPE.TOTAL).getMax();
    }

    @Override
    public double getMinTransitionLatency() {
        return this._monitorMap.get((Object)LATENCY_TYPE.TOTAL).getMin();
    }

    @Override
    public double getPercentileTransitionLatency(int percentage) {
        return this._monitorMap.get((Object)LATENCY_TYPE.TOTAL).getPercentile(percentage);
    }

    @Override
    public double getMeanTransitionExecuteLatency() {
        return this._monitorMap.get((Object)LATENCY_TYPE.EXECUTION).getMean();
    }

    @Override
    public double getMaxTransitionExecuteLatency() {
        return this._monitorMap.get((Object)LATENCY_TYPE.EXECUTION).getMax();
    }

    @Override
    public double getMinTransitionExecuteLatency() {
        return this._monitorMap.get((Object)LATENCY_TYPE.EXECUTION).getMin();
    }

    @Override
    public double getPercentileTransitionExecuteLatency(int percentage) {
        return this._monitorMap.get((Object)LATENCY_TYPE.EXECUTION).getPercentile(percentage);
    }

    public static enum LATENCY_TYPE {
        TOTAL,
        EXECUTION;

    }
}

