/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobContext;
import org.apache.helix.task.TaskRebalancer;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;

public class FixedTargetTaskRebalancer
extends TaskRebalancer {
    @Override
    public Set<Integer> getAllTaskPartitions(JobConfig jobCfg, JobContext jobCtx, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, ClusterDataCache cache) {
        return FixedTargetTaskRebalancer.getAllTaskPartitions(FixedTargetTaskRebalancer.getTgtIdealState(jobCfg, cache), jobCfg, jobCtx);
    }

    @Override
    public Map<String, SortedSet<Integer>> getTaskAssignment(CurrentStateOutput currStateOutput, ResourceAssignment prevAssignment, Collection<String> instances, JobConfig jobCfg, JobContext jobContext, WorkflowConfig workflowCfg, WorkflowContext workflowCtx, Set<Integer> partitionSet, ClusterDataCache cache) {
        IdealState tgtIs = FixedTargetTaskRebalancer.getTgtIdealState(jobCfg, cache);
        if (tgtIs == null) {
            return Collections.emptyMap();
        }
        Set<String> tgtStates = jobCfg.getTargetPartitionStates();
        return FixedTargetTaskRebalancer.getTgtPartitionAssignment(currStateOutput, instances, tgtIs, tgtStates, partitionSet, jobContext);
    }

    private static IdealState getTgtIdealState(JobConfig jobCfg, ClusterDataCache cache) {
        String tgtResourceId = jobCfg.getTargetResource();
        return cache.getIdealState(tgtResourceId);
    }

    private static Set<Integer> getAllTaskPartitions(IdealState tgtResourceIs, JobConfig jobCfg, JobContext taskCtx) {
        if (tgtResourceIs == null) {
            return null;
        }
        Map<String, List<Integer>> currentTargets = taskCtx.getPartitionsByTarget();
        TreeSet targetPartitions = Sets.newTreeSet();
        if (jobCfg.getTargetPartitions() != null) {
            targetPartitions.addAll(jobCfg.getTargetPartitions());
        } else {
            targetPartitions.addAll(tgtResourceIs.getPartitionSet());
        }
        TreeSet taskPartitions = Sets.newTreeSet();
        for (String pName : targetPartitions) {
            taskPartitions.addAll(FixedTargetTaskRebalancer.getPartitionsForTargetPartition(pName, currentTargets, taskCtx));
        }
        return taskPartitions;
    }

    private static List<Integer> getPartitionsForTargetPartition(String targetPartition, Map<String, List<Integer>> currentTargets, JobContext jobCtx) {
        if (!currentTargets.containsKey(targetPartition)) {
            int nextId = jobCtx.getPartitionSet().size();
            jobCtx.setPartitionTarget(nextId, targetPartition);
            return Lists.newArrayList((Object[])new Integer[]{nextId});
        }
        return currentTargets.get(targetPartition);
    }

    private static Map<String, SortedSet<Integer>> getTgtPartitionAssignment(CurrentStateOutput currStateOutput, Iterable<String> instances, IdealState tgtIs, Set<String> tgtStates, Set<Integer> includeSet, JobContext jobCtx) {
        HashMap<String, SortedSet<Integer>> result = new HashMap<String, SortedSet<Integer>>();
        for (String instance : instances) {
            result.put(instance, new TreeSet());
        }
        Map<String, List<Integer>> partitionsByTarget = jobCtx.getPartitionsByTarget();
        for (String pName : tgtIs.getPartitionSet()) {
            int pId;
            List<Integer> partitions = partitionsByTarget.get(pName);
            if (partitions == null || partitions.size() < 1 || !includeSet.contains(pId = partitions.get(0).intValue())) continue;
            for (String instance : instances) {
                String state;
                Message pendingMessage = currStateOutput.getPendingState(tgtIs.getResourceName(), new Partition(pName), instance);
                if (pendingMessage != null) continue;
                String s = currStateOutput.getCurrentState(tgtIs.getResourceName(), new Partition(pName), instance);
                String string = state = s == null ? null : s.toString();
                if (tgtStates != null && !tgtStates.contains(state)) continue;
                ((SortedSet)result.get(instance)).add(pId);
            }
        }
        return result;
    }
}

