/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.builder.HelixConfigScopeBuilder;
import org.apache.helix.tools.StateModelConfigGenerator;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

public class YAMLClusterSetup {
    private static final Logger LOG = Logger.getLogger(YAMLClusterSetup.class);
    private final String _zkAddress;

    public YAMLClusterSetup(String zkAddress) {
        this._zkAddress = zkAddress;
    }

    public YAMLClusterConfig setupCluster(InputStream input) {
        Yaml yaml = new Yaml();
        YAMLClusterConfig cfg = (YAMLClusterConfig)yaml.loadAs(input, YAMLClusterConfig.class);
        ZKHelixAdmin helixAdmin = new ZKHelixAdmin(this._zkAddress);
        if (cfg.clusterName == null) {
            throw new HelixException("Cluster name is required!");
        }
        helixAdmin.addCluster(cfg.clusterName);
        if (cfg.participants != null) {
            for (YAMLClusterConfig.ParticipantConfig participant : cfg.participants) {
                helixAdmin.addInstance(cfg.clusterName, YAMLClusterSetup.getInstanceCfg(participant));
            }
        }
        if (cfg.resources != null) {
            for (YAMLClusterConfig.ResourceConfig resource : cfg.resources) {
                StateModelDefinition stateModelDef;
                if (resource.name == null) {
                    throw new HelixException("Resources must be named!");
                }
                if (resource.stateModel == null || resource.stateModel.name == null) {
                    throw new HelixException("Resource must specify a named state model!");
                }
                if (resource.stateModel.states != null) {
                    stateModelDef = YAMLClusterSetup.getStateModelDef(resource.stateModel, resource.constraints);
                    helixAdmin.addStateModelDef(cfg.clusterName, resource.stateModel.name, stateModelDef);
                } else {
                    stateModelDef = null;
                    if (resource.stateModel.name.equals("MasterSlave")) {
                        stateModelDef = new StateModelDefinition(StateModelConfigGenerator.generateConfigForMasterSlave());
                    } else if (resource.stateModel.name.equals("OnlineOffline")) {
                        stateModelDef = new StateModelDefinition(StateModelConfigGenerator.generateConfigForOnlineOffline());
                    } else if (resource.stateModel.name.equals("LeaderStandby")) {
                        stateModelDef = new StateModelDefinition(StateModelConfigGenerator.generateConfigForLeaderStandby());
                    }
                    if (stateModelDef != null) {
                        try {
                            helixAdmin.addStateModelDef(cfg.clusterName, resource.stateModel.name, stateModelDef);
                        }
                        catch (HelixException e) {
                            LOG.warn((Object)("State model definition " + resource.stateModel.name + " could not be added."));
                        }
                    }
                }
                int partitions = 1;
                int replicas = 1;
                if (resource.partitions != null) {
                    if (resource.partitions.containsKey("count")) {
                        partitions = resource.partitions.get("count");
                    }
                    if (resource.partitions.containsKey("replicas")) {
                        replicas = resource.partitions.get("replicas");
                    }
                }
                if (resource.rebalancer == null || !resource.rebalancer.containsKey("mode")) {
                    throw new HelixException("Rebalance mode is required!");
                }
                helixAdmin.addResource(cfg.clusterName, resource.name, partitions, resource.stateModel.name, resource.rebalancer.get("mode"));
                if (resource.rebalancer.containsKey("class") && resource.rebalancer.get("mode").equals(IdealState.RebalanceMode.USER_DEFINED.toString())) {
                    IdealState idealState = helixAdmin.getResourceIdealState(cfg.clusterName, resource.name);
                    idealState.setRebalancerClassName(resource.rebalancer.get("class"));
                    helixAdmin.setResourceIdealState(cfg.clusterName, resource.name, idealState);
                }
                helixAdmin.rebalance(cfg.clusterName, resource.name, replicas);
            }
        }
        if (cfg.autoJoinAllowed != null && cfg.autoJoinAllowed.booleanValue()) {
            HelixConfigScope scope = new HelixConfigScopeBuilder(HelixConfigScope.ConfigScopeProperty.CLUSTER).forCluster(cfg.clusterName).build();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("allowParticipantAutoJoin", cfg.autoJoinAllowed.toString());
            helixAdmin.setConfig(scope, properties);
        }
        return cfg;
    }

    private static InstanceConfig getInstanceCfg(YAMLClusterConfig.ParticipantConfig participant) {
        if (participant == null || participant.name == null || participant.host == null || participant.port == null) {
            throw new HelixException("Participant must have a specified name, host, and port!");
        }
        InstanceConfig instanceCfg = new InstanceConfig(participant.name);
        instanceCfg.setHostName(participant.host);
        instanceCfg.setPort(participant.port.toString());
        return instanceCfg;
    }

    /*
     * WARNING - void declaration
     */
    private static StateModelDefinition getStateModelDef(YAMLClusterConfig.ResourceConfig.StateModelConfig stateModel, YAMLClusterConfig.ResourceConfig.ConstraintsConfig constraints) {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(stateModel.name);
        if (stateModel.states == null || stateModel.states.size() == 0) {
            throw new HelixException("List of states are required in a state model!");
        }
        HashSet<String> stateSet = new HashSet<String>(stateModel.states);
        if (stateModel.initialState == null) {
            throw new HelixException("Initial state is required in a state model!");
        }
        if (!stateSet.contains(stateModel.initialState)) {
            throw new HelixException("Initial state is not a valid state");
        }
        builder.initialState(stateModel.initialState);
        HashMap<String, Integer> statePriorities = new HashMap<String, Integer>();
        if (constraints != null && constraints.state != null && constraints.state.priorityList != null) {
            int statePriority = 0;
            for (String string : constraints.state.priorityList) {
                if (!stateSet.contains(string)) {
                    throw new HelixException("State " + string + " in the state priority list is not in the state list!");
                }
                statePriorities.put(string, statePriority);
                ++statePriority;
            }
        }
        for (String string : stateModel.states) {
            if (statePriorities.containsKey(string)) {
                builder.addState(string, (Integer)statePriorities.get(string));
                continue;
            }
            builder.addState(string);
        }
        for (Map map : constraints.state.counts) {
            String string = (String)map.get("name");
            if (!stateSet.contains(string)) {
                throw new HelixException("State " + string + " has a count, but not in the state list!");
            }
            builder.dynamicUpperBound(string, (String)map.get("count"));
        }
        HashMap<String, Integer> transitionPriorities = new HashMap<String, Integer>();
        if (constraints != null && constraints.transition != null && constraints.transition.priorityList != null) {
            boolean bl = false;
            for (String transition : constraints.transition.priorityList) {
                void var6_13;
                transitionPriorities.put(transition, (int)var6_13);
                ++var6_13;
            }
        }
        if (stateModel.transitions == null || stateModel.transitions.size() == 0) {
            throw new HelixException("Transitions are required!");
        }
        for (Map<String, String> map : stateModel.transitions) {
            String name = map.get("name");
            String from = map.get("from");
            String to = map.get("to");
            if (name == null || from == null || to == null) {
                throw new HelixException("All transitions must have a name, a from state, and a to state");
            }
            if (transitionPriorities.containsKey(name)) {
                builder.addTransition(from, to, (Integer)transitionPriorities.get(name));
                continue;
            }
            builder.addTransition(from, to);
        }
        return builder.build();
    }

    public static void main(String[] args) {
        FileInputStream input;
        if (args.length < 2) {
            LOG.error((Object)"USAGE: YAMLClusterSetup zkAddr yamlFile");
            return;
        }
        String zkAddress = args[0];
        String yamlFile = args[1];
        try {
            input = new FileInputStream(new File(yamlFile));
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Could not open " + yamlFile));
            return;
        }
        new YAMLClusterSetup(zkAddress).setupCluster(input);
    }

    public static class YAMLClusterConfig {
        public String clusterName;
        public List<ResourceConfig> resources;
        public List<ParticipantConfig> participants;
        public Boolean autoJoinAllowed;

        public static class ParticipantConfig {
            public String name;
            public String host;
            public Integer port;
        }

        public static class ResourceConfig {
            public String name;
            public Map<String, String> rebalancer;
            public Map<String, Integer> partitions;
            public StateModelConfig stateModel;
            public ConstraintsConfig constraints;

            public static class ConstraintsConfig {
                public StateConstraintsConfig state;
                public TransitionConstraintsConfig transition;

                public static class TransitionConstraintsConfig {
                    public List<String> priorityList;
                }

                public static class StateConstraintsConfig {
                    public List<Map<String, String>> counts;
                    public List<String> priorityList;
                }
            }

            public static class StateModelConfig {
                public String name;
                public List<String> states;
                public List<Map<String, String>> transitions;
                public String initialState;
            }
        }
    }
}

