/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.jsonexplain.Vertex;

public class DagJsonParserUtils {
    private static final List<String> operatorNoStats = Arrays.asList("File Output Operator", "Reduce Output Operator");

    public static List<String> getOperatorNoStats() {
        return operatorNoStats;
    }

    public static String renameReduceOutputOperator(String operatorName, Vertex vertex) {
        if (operatorName.equals("Reduce Output Operator") && vertex.edgeType != null) {
            return vertex.edgeType;
        }
        return operatorName;
    }

    public static String attrsToString(Map<String, String> attrs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(entry.getKey() + entry.getValue());
        }
        return sb.toString();
    }
}

