/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;

public class ColumnStatsUpdateTask
extends Task<ColumnStatsUpdateWork> {
    private static final long serialVersionUID = 1L;
    private static final transient Log LOG = LogFactory.getLog(ColumnStatsUpdateTask.class);

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
    }

    private ColumnStatistics constructColumnStatsFromInput() throws SemanticException, MetaException {
        Map<String, String> mapProp;
        String dbName = SessionState.get().getCurrentDatabase();
        ColumnStatsDesc desc = ((ColumnStatsUpdateWork)this.work).getColStats();
        String tableName = desc.getTableName();
        String partName = ((ColumnStatsUpdateWork)this.work).getPartName();
        List<String> colName = desc.getColName();
        List<String> colType = desc.getColType();
        ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
        statsObj.setColName(colName.get(0));
        statsObj.setColType(colType.get(0));
        ColumnStatisticsData statsData = new ColumnStatisticsData();
        String columnType = colType.get(0);
        if (columnType.equalsIgnoreCase("long")) {
            LongColumnStatsData longStats = new LongColumnStatsData();
            longStats.setNumNullsIsSet(false);
            longStats.setNumDVsIsSet(false);
            longStats.setLowValueIsSet(false);
            longStats.setHighValueIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    longStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    longStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    longStats.setLowValue(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("highValue")) {
                    longStats.setHighValue(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setLongStats(longStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("double")) {
            DoubleColumnStatsData doubleStats = new DoubleColumnStatsData();
            doubleStats.setNumNullsIsSet(false);
            doubleStats.setNumDVsIsSet(false);
            doubleStats.setLowValueIsSet(false);
            doubleStats.setHighValueIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    doubleStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    doubleStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    doubleStats.setLowValue(Double.parseDouble(value));
                    continue;
                }
                if (fName.equals("highValue")) {
                    doubleStats.setHighValue(Double.parseDouble(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setDoubleStats(doubleStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("string")) {
            StringColumnStatsData stringStats = new StringColumnStatsData();
            stringStats.setMaxColLenIsSet(false);
            stringStats.setAvgColLenIsSet(false);
            stringStats.setNumNullsIsSet(false);
            stringStats.setNumDVsIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    stringStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    stringStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("avgColLen")) {
                    stringStats.setAvgColLen(Double.parseDouble(value));
                    continue;
                }
                if (fName.equals("maxColLen")) {
                    stringStats.setMaxColLen(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setStringStats(stringStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("boolean")) {
            BooleanColumnStatsData booleanStats = new BooleanColumnStatsData();
            booleanStats.setNumNullsIsSet(false);
            booleanStats.setNumTruesIsSet(false);
            booleanStats.setNumFalsesIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    booleanStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numTrues")) {
                    booleanStats.setNumTrues(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numFalses")) {
                    booleanStats.setNumFalses(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setBooleanStats(booleanStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("binary")) {
            BinaryColumnStatsData binaryStats = new BinaryColumnStatsData();
            binaryStats.setNumNullsIsSet(false);
            binaryStats.setAvgColLenIsSet(false);
            binaryStats.setMaxColLenIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    binaryStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("avgColLen")) {
                    binaryStats.setAvgColLen(Double.parseDouble(value));
                    continue;
                }
                if (fName.equals("maxColLen")) {
                    binaryStats.setMaxColLen(Long.parseLong(value));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setBinaryStats(binaryStats);
            statsObj.setStatsData(statsData);
        } else if (columnType.equalsIgnoreCase("decimal")) {
            DecimalColumnStatsData decimalStats = new DecimalColumnStatsData();
            decimalStats.setNumNullsIsSet(false);
            decimalStats.setNumDVsIsSet(false);
            decimalStats.setLowValueIsSet(false);
            decimalStats.setHighValueIsSet(false);
            mapProp = ((ColumnStatsUpdateWork)this.work).getMapProp();
            for (Map.Entry<String, String> entry : mapProp.entrySet()) {
                BigDecimal d;
                String fName = entry.getKey();
                String value = entry.getValue();
                if (fName.equals("numNulls")) {
                    decimalStats.setNumNulls(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("numDVs")) {
                    decimalStats.setNumDVs(Long.parseLong(value));
                    continue;
                }
                if (fName.equals("lowValue")) {
                    d = new BigDecimal(value);
                    decimalStats.setLowValue(new Decimal(ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)d.scale()));
                    continue;
                }
                if (fName.equals("highValue")) {
                    d = new BigDecimal(value);
                    decimalStats.setHighValue(new Decimal(ByteBuffer.wrap(d.unscaledValue().toByteArray()), (short)d.scale()));
                    continue;
                }
                throw new SemanticException("Unknown stat");
            }
            statsData.setDecimalStats(decimalStats);
            statsObj.setStatsData(statsData);
        } else {
            throw new SemanticException("Unsupported type");
        }
        ColumnStatisticsDesc statsDesc = this.getColumnStatsDesc(dbName, tableName, partName, partName == null);
        ColumnStatistics colStat = new ColumnStatistics();
        colStat.setStatsDesc(statsDesc);
        colStat.addToStatsObj(statsObj);
        return colStat;
    }

    private ColumnStatisticsDesc getColumnStatsDesc(String dbName, String tableName, String partName, boolean isTblLevel) {
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setDbName(dbName);
        statsDesc.setTableName(tableName);
        statsDesc.setIsTblLevel(isTblLevel);
        if (!isTblLevel) {
            statsDesc.setPartName(partName);
        } else {
            statsDesc.setPartName(null);
        }
        return statsDesc;
    }

    private int persistTableStats() throws HiveException, MetaException, IOException {
        ColumnStatistics colStats = this.constructColumnStatsFromInput();
        this.db.updateTableColumnStatistics(colStats);
        return 0;
    }

    private int persistPartitionStats() throws HiveException, MetaException, IOException {
        ColumnStatistics colStats = this.constructColumnStatsFromInput();
        this.db.updatePartitionColumnStatistics(colStats);
        return 0;
    }

    @Override
    public int execute(DriverContext driverContext) {
        try {
            if (((ColumnStatsUpdateWork)this.work).getColStats().isTblLevel()) {
                return this.persistTableStats();
            }
            return this.persistPartitionStats();
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return 1;
        }
    }

    @Override
    public StageType getType() {
        return StageType.COLUMNSTATS;
    }

    @Override
    public String getName() {
        return "COLUMNSTATS UPDATE TASK";
    }
}

