/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.ql.exec.tez.RecordSource;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.CommonMergeJoinDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class CommonMergeJoinOperator
extends AbstractMapJoinOperator<CommonMergeJoinDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isBigTableWork;
    private static final Log LOG = LogFactory.getLog((String)CommonMergeJoinOperator.class.getName());
    transient List<Object>[] keyWritables;
    transient List<Object>[] nextKeyWritables;
    transient RowContainer<List<Object>>[] nextGroupStorage;
    transient RowContainer<List<Object>>[] candidateStorage;
    transient String[] tagToAlias;
    private transient boolean[] fetchDone;
    private transient boolean[] foundNextKeyGroup;
    transient boolean firstFetchHappened = false;
    transient boolean localWorkInited = false;
    transient boolean initDone = false;
    transient List<Object> otherKey = null;
    transient List<Object> values = null;
    transient RecordSource[] sources;
    transient List<Operator<? extends OperatorDesc>> originalParents = new ArrayList<Operator<? extends OperatorDesc>>();

    @Override
    public void initializeOp(Configuration hconf) throws HiveException {
        byte pos;
        super.initializeOp(hconf);
        this.firstFetchHappened = false;
        this.initializeChildren(hconf);
        int maxAlias = 0;
        for (int pos2 = 0; pos2 < this.order.length; pos2 = (int)((byte)(pos2 + 1))) {
            if (pos2 <= maxAlias) continue;
            maxAlias = pos2;
        }
        this.nextGroupStorage = new RowContainer[++maxAlias];
        this.candidateStorage = new RowContainer[maxAlias];
        this.keyWritables = new ArrayList[maxAlias];
        this.nextKeyWritables = new ArrayList[maxAlias];
        this.fetchDone = new boolean[maxAlias];
        this.foundNextKeyGroup = new boolean[maxAlias];
        int oldVar = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEMAPJOINBUCKETCACHESIZE);
        int bucketSize = oldVar != 100 ? oldVar : HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVESMBJOINCACHEROWS);
        for (pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
            RowContainer<List<Object>> rc = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[pos], pos, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(pos), this.reporter);
            this.nextGroupStorage[pos] = rc;
            RowContainer<List<Object>> candidateRC = JoinUtil.getRowContainer(hconf, this.rowContainerStandardObjectInspectors[pos], pos, bucketSize, this.spillTableDesc, (JoinDesc)this.conf, !this.hasFilter(pos), this.reporter);
            this.candidateStorage[pos] = candidateRC;
        }
        for (pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
            if (pos != this.posBigTable) {
                this.fetchDone[pos] = false;
            }
            this.foundNextKeyGroup[pos] = false;
        }
        this.sources = ((TezContext)MapredContext.get()).getRecordSources();
    }

    @Override
    public void endGroup() throws HiveException {
        this.defaultEndGroup();
    }

    @Override
    public void startGroup() throws HiveException {
        this.defaultStartGroup();
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        boolean nextKeyGroup;
        this.posBigTable = (byte)((CommonMergeJoinDesc)this.conf).getBigTablePosition();
        byte alias = (byte)tag;
        List<Object> value = this.getFilteredValue(alias, row);
        List<Object> key = this.mergeJoinComputeKeys(row, alias);
        if (!this.firstFetchHappened) {
            this.firstFetchHappened = true;
            for (byte pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
                if (pos == this.posBigTable) continue;
                this.fetchNextGroup(pos);
            }
        }
        if (nextKeyGroup = this.processKey(alias, key)) {
            this.nextGroupStorage[alias].addRow(value);
            this.foundNextKeyGroup[tag] = true;
            if (tag != this.posBigTable) {
                return;
            }
        }
        this.reportProgress();
        ++this.numMapRowsRead;
        if (nextKeyGroup) {
            assert (tag == this.posBigTable);
            List<Byte> smallestPos = null;
            while ((smallestPos = this.joinOneGroup()) != null && smallestPos.size() > 0 && !smallestPos.contains(this.posBigTable)) {
            }
            return;
        }
        assert (!nextKeyGroup);
        this.candidateStorage[tag].addRow(value);
    }

    private List<Byte> joinOneGroup() throws HiveException {
        int[] smallestPos = this.findSmallestKey();
        List<Byte> listOfNeedFetchNext = null;
        if (smallestPos != null && (listOfNeedFetchNext = this.joinObject(smallestPos)).size() > 0) {
            for (Byte b : listOfNeedFetchNext) {
                try {
                    this.fetchNextGroup(b);
                }
                catch (Exception e) {
                    throw new HiveException(e);
                }
            }
        }
        return listOfNeedFetchNext;
    }

    private List<Byte> joinObject(int[] smallestPos) throws HiveException {
        byte index;
        ArrayList<Byte> needFetchList = new ArrayList<Byte>();
        for (index = (byte)(smallestPos.length - 1); index >= 0; index = (byte)(index - 1)) {
            if (smallestPos[index] > 0 || this.keyWritables[index] == null) {
                this.putDummyOrEmpty(index);
                continue;
            }
            this.storage[index] = this.candidateStorage[index];
            needFetchList.add(index);
            if (smallestPos[index] < 0) break;
        }
        for (index = (byte)(index - 1); index >= 0; index = (byte)(index - 1)) {
            this.putDummyOrEmpty(index);
        }
        this.checkAndGenObject();
        for (Byte pos : needFetchList) {
            this.candidateStorage[pos].clearRows();
            this.keyWritables[pos.byteValue()] = null;
        }
        return needFetchList;
    }

    private void putDummyOrEmpty(Byte i) {
        this.storage[i.byteValue()] = this.noOuterJoin ? this.emptyList : this.dummyObjVectors[i];
    }

    private int[] findSmallestKey() {
        int[] result = new int[this.order.length];
        List<Object> smallestOne = null;
        for (int pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
            List<Object> key = this.keyWritables[pos];
            if (key == null) continue;
            if (smallestOne == null) {
                smallestOne = key;
                result[pos] = -1;
                continue;
            }
            result[pos] = this.compareKeys(key, smallestOne);
            if (result[pos] >= 0) continue;
            smallestOne = key;
        }
        return smallestOne == null ? null : result;
    }

    private void fetchNextGroup(Byte t) throws HiveException {
        if (this.foundNextKeyGroup[t]) {
            if (this.nextKeyWritables[t] != null) {
                this.promoteNextGroupToCandidate(t);
            } else {
                this.keyWritables[t.byteValue()] = null;
                this.candidateStorage[t.byteValue()] = null;
                this.nextGroupStorage[t.byteValue()] = null;
            }
            this.foundNextKeyGroup[t.byteValue()] = false;
        }
        if (t == this.posBigTable) {
            return;
        }
        while (!this.foundNextKeyGroup[t] && !this.fetchDone[t]) {
            this.fetchOneRow(t);
        }
        if (!this.foundNextKeyGroup[t] && this.fetchDone[t]) {
            this.nextKeyWritables[t.byteValue()] = null;
        }
    }

    @Override
    public void closeOp(boolean abort) throws HiveException {
        this.joinFinalLeftData();
        super.closeOp(abort);
        for (int pos = 0; pos < this.order.length; ++pos) {
            if (pos != this.posBigTable) {
                this.fetchDone[pos] = false;
            }
            this.foundNextKeyGroup[pos] = false;
        }
    }

    private void fetchOneRow(byte tag) throws HiveException {
        try {
            boolean bl = this.fetchDone[tag] = !this.sources[tag].pushRecord();
            if (this.sources[tag].isGrouped()) {
                this.foundNextKeyGroup[tag] = true;
            }
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    private void joinFinalLeftData() throws HiveException {
        List<Byte> ret;
        RowContainer<List<Object>> bigTblRowContainer = this.candidateStorage[this.posBigTable];
        boolean allFetchDone = this.allFetchDone();
        while (bigTblRowContainer != null && bigTblRowContainer.rowCount() > 0 && !allFetchDone) {
            this.joinOneGroup();
            bigTblRowContainer = this.candidateStorage[this.posBigTable];
            allFetchDone = this.allFetchDone();
        }
        while (!allFetchDone && (ret = this.joinOneGroup()) != null && ret.size() != 0) {
            this.reportProgress();
            ++this.numMapRowsRead;
            allFetchDone = this.allFetchDone();
        }
        boolean dataInCache = true;
        block2: while (dataInCache) {
            byte pos;
            for (pos = 0; pos < this.order.length; pos = (byte)((byte)(pos + 1))) {
                if (!this.foundNextKeyGroup[pos] || this.nextKeyWritables[pos] == null) continue;
                this.promoteNextGroupToCandidate(pos);
            }
            this.joinOneGroup();
            dataInCache = false;
            for (pos = 0; pos < this.order.length; pos = (byte)(pos + 1)) {
                if (this.candidateStorage[pos] == null || this.candidateStorage[pos].rowCount() <= 0) continue;
                dataInCache = true;
                continue block2;
            }
        }
    }

    private boolean allFetchDone() {
        boolean allFetchDone = true;
        for (int pos = 0; pos < this.order.length; pos = (int)((byte)(pos + 1))) {
            if (pos == this.posBigTable) continue;
            allFetchDone = allFetchDone && this.fetchDone[pos];
        }
        return allFetchDone;
    }

    private void promoteNextGroupToCandidate(Byte t) throws HiveException {
        this.keyWritables[t.byteValue()] = this.nextKeyWritables[t];
        this.nextKeyWritables[t.byteValue()] = null;
        RowContainer<List<Object>> oldRowContainer = this.candidateStorage[t];
        oldRowContainer.clearRows();
        this.candidateStorage[t.byteValue()] = this.nextGroupStorage[t];
        this.nextGroupStorage[t.byteValue()] = oldRowContainer;
    }

    private boolean processKey(byte alias, List<Object> key) throws HiveException {
        List<Object> keyWritable = this.keyWritables[alias];
        if (keyWritable == null) {
            this.keyWritables[alias] = key;
            return false;
        }
        int cmp = this.compareKeys(key, keyWritable);
        if (cmp != 0) {
            this.nextKeyWritables[alias] = key;
            return true;
        }
        return false;
    }

    private int compareKeys(List<Object> k1, List<Object> k2) {
        int ret = 0;
        ret = k1.size() - k2.size();
        if (ret != 0) {
            return ret;
        }
        for (int i = 0; i < k1.size(); ++i) {
            WritableComparable key_1 = (WritableComparable)k1.get(i);
            WritableComparable key_2 = (WritableComparable)k2.get(i);
            if (key_1 == null && key_2 == null) {
                if (this.nullsafes != null && this.nullsafes[i]) continue;
                return -1;
            }
            if (key_1 == null) {
                return -1;
            }
            if (key_2 == null) {
                return 1;
            }
            ret = WritableComparator.get(key_1.getClass()).compare(key_1, key_2);
            if (ret == 0) continue;
            return ret;
        }
        return ret;
    }

    private List<Object> mergeJoinComputeKeys(Object row, Byte alias) throws HiveException {
        if (this.joinKeysObjectInspectors != null && this.joinKeysObjectInspectors[alias] != null) {
            return JoinUtil.computeKeys(row, this.joinKeys[alias], this.joinKeysObjectInspectors[alias]);
        }
        row = ObjectInspectorUtils.copyToStandardObject(row, this.inputObjInspectors[alias], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        StructObjectInspector soi = (StructObjectInspector)this.inputObjInspectors[alias];
        StructField sf = soi.getStructFieldRef(Utilities.ReduceField.KEY.toString());
        return (List)soi.getStructFieldData(row, sf);
    }

    @Override
    public String getName() {
        return CommonMergeJoinOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "MERGEJOIN";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.MERGEJOIN;
    }

    @Override
    public void initializeLocalWork(Configuration hconf) throws HiveException {
        Operator parent = null;
        for (Operator parentOp : this.parentOperators) {
            if (parentOp == null) continue;
            parent = parentOp;
            break;
        }
        if (parent == null) {
            throw new HiveException("No valid parents.");
        }
        Map<Integer, DummyStoreOperator> dummyOps = parent.getTagToOperatorTree();
        for (Map.Entry<Integer, DummyStoreOperator> connectOp : dummyOps.entrySet()) {
            this.parentOperators.add(connectOp.getKey(), connectOp.getValue());
            connectOp.getValue().getChildOperators().add(this);
        }
        super.initializeLocalWork(hconf);
    }

    public boolean isBigTableWork() {
        return this.isBigTableWork;
    }

    public void setIsBigTableWork(boolean bigTableWork) {
        this.isBigTableWork = bigTableWork;
    }

    public int getTagForOperator(Operator<? extends OperatorDesc> op) {
        return this.originalParents.indexOf(op);
    }

    public void cloneOriginalParentsList(List<Operator<? extends OperatorDesc>> opList) {
        this.originalParents.addAll(opList);
    }
}

