/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.util.StringUtils;

public final class RewriteParseContextGenerator {
    private static final Log LOG = LogFactory.getLog((String)RewriteParseContextGenerator.class.getName());

    private RewriteParseContextGenerator() {
    }

    public static ParseContext generateOperatorTree(HiveConf conf, String command) throws SemanticException {
        ParseContext subPCtx = null;
        try {
            Context ctx = new Context(conf);
            ParseDriver pd = new ParseDriver();
            ASTNode tree = pd.parse(command, ctx);
            tree = ParseUtils.findRootNonNullToken(tree);
            BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(conf, tree);
            assert (sem instanceof SemanticAnalyzer);
            RewriteParseContextGenerator.doSemanticAnalysis((SemanticAnalyzer)sem, tree, ctx);
            subPCtx = ((SemanticAnalyzer)sem).getParseContext();
            LOG.info((Object)"Sub-query Semantic Analysis Completed");
        }
        catch (IOException e) {
            LOG.error((Object)("IOException in generating the operator tree for input command - " + command + " "), (Throwable)e);
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        catch (ParseException e) {
            LOG.error((Object)("ParseException in generating the operator tree for input command - " + command + " "), (Throwable)e);
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        catch (SemanticException e) {
            LOG.error((Object)("SemanticException in generating the operator tree for input command - " + command + " "), (Throwable)e);
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        return subPCtx;
    }

    private static void doSemanticAnalysis(SemanticAnalyzer sem, ASTNode ast, Context ctx) throws SemanticException {
        QB qb = new QB(null, null, false);
        ASTNode child = ast;
        ParseContext subPCtx = sem.getParseContext();
        subPCtx.setContext(ctx);
        sem.initParseCtx(subPCtx);
        LOG.info((Object)"Starting Sub-query Semantic Analysis");
        sem.doPhase1(child, qb, sem.initPhase1Ctx(), null);
        LOG.info((Object)"Completed phase 1 of Sub-query Semantic Analysis");
        sem.getMetaData(qb);
        LOG.info((Object)"Completed getting MetaData in Sub-query Semantic Analysis");
        LOG.info((Object)("Sub-query Abstract syntax tree: " + ast.toStringTree()));
        sem.genPlan(qb);
        LOG.info((Object)"Sub-query Completed plan generation");
    }
}

