/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.tez.HashTableLoader;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinTableContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastTableContainer
implements VectorMapJoinTableContainer {
    private static final Logger LOG = LoggerFactory.getLogger((String)HashTableLoader.class.getName());
    private final MapJoinDesc desc;
    private final Configuration hconf;
    private final float keyCountAdj;
    private final int threshold;
    private final float loadFactor;
    private final int wbSize;
    private final long keyCount;
    private final VectorMapJoinFastHashTable vectorMapJoinFastHashTable;

    public VectorMapJoinFastTableContainer(MapJoinDesc desc, Configuration hconf, long keyCount) throws SerDeException {
        this.desc = desc;
        this.hconf = hconf;
        this.keyCountAdj = HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEKEYCOUNTADJUSTMENT);
        this.threshold = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD);
        this.loadFactor = HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR);
        this.wbSize = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEWBSIZE);
        this.keyCount = keyCount;
        int newThreshold = HashMapWrapper.calculateTableSize(this.keyCountAdj, this.threshold, this.loadFactor, keyCount);
        this.vectorMapJoinFastHashTable = this.createHashTable(newThreshold);
    }

    @Override
    public VectorMapJoinHashTable vectorMapJoinHashTable() {
        return this.vectorMapJoinFastHashTable;
    }

    private VectorMapJoinFastHashTable createHashTable(int newThreshold) {
        boolean isOuterJoin = !this.desc.isNoOuterJoin();
        VectorMapJoinDesc vectorDesc = this.desc.getVectorDesc();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = vectorDesc.hashTableImplementationType();
        VectorMapJoinDesc.HashTableKind hashTableKind = vectorDesc.hashTableKind();
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = vectorDesc.hashTableKeyType();
        boolean minMaxEnabled = vectorDesc.minMaxEnabled();
        int writeBufferSize = HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.HIVEHASHTABLEWBSIZE);
        VectorMapJoinFastHashTable hashTable = null;
        block0 : switch (hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        hashTable = new VectorMapJoinFastLongHashMap(minMaxEnabled, isOuterJoin, hashTableKeyType, newThreshold, this.loadFactor, writeBufferSize);
                        break;
                    }
                    case HASH_MULTISET: {
                        hashTable = new VectorMapJoinFastLongHashMultiSet(minMaxEnabled, isOuterJoin, hashTableKeyType, newThreshold, this.loadFactor, writeBufferSize);
                        break;
                    }
                    case HASH_SET: {
                        hashTable = new VectorMapJoinFastLongHashSet(minMaxEnabled, isOuterJoin, hashTableKeyType, newThreshold, this.loadFactor, writeBufferSize);
                    }
                }
                break;
            }
            case STRING: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        hashTable = new VectorMapJoinFastStringHashMap(isOuterJoin, newThreshold, this.loadFactor, writeBufferSize);
                        break;
                    }
                    case HASH_MULTISET: {
                        hashTable = new VectorMapJoinFastStringHashMultiSet(isOuterJoin, newThreshold, this.loadFactor, writeBufferSize);
                        break;
                    }
                    case HASH_SET: {
                        hashTable = new VectorMapJoinFastStringHashSet(isOuterJoin, newThreshold, this.loadFactor, writeBufferSize);
                    }
                }
                break;
            }
            case MULTI_KEY: {
                switch (hashTableKind) {
                    case HASH_MAP: {
                        hashTable = new VectorMapJoinFastMultiKeyHashMap(isOuterJoin, newThreshold, this.loadFactor, writeBufferSize);
                        break block0;
                    }
                    case HASH_MULTISET: {
                        hashTable = new VectorMapJoinFastMultiKeyHashMultiSet(isOuterJoin, newThreshold, this.loadFactor, writeBufferSize);
                        break block0;
                    }
                    case HASH_SET: {
                        hashTable = new VectorMapJoinFastMultiKeyHashSet(isOuterJoin, newThreshold, this.loadFactor, writeBufferSize);
                    }
                }
            }
        }
        return hashTable;
    }

    @Override
    public MapJoinKey putRow(Writable currentKey, Writable currentValue) throws SerDeException, HiveException, IOException {
        this.vectorMapJoinFastHashTable.putRow((BytesWritable)currentKey, (BytesWritable)currentValue);
        return null;
    }

    @Override
    public void seal() {
    }

    @Override
    public MapJoinTableContainer.ReusableGetAdaptor createGetter(MapJoinKey keyTypeFromLoader) {
        throw new RuntimeException("Not applicable");
    }

    @Override
    public void clear() {
    }

    @Override
    public MapJoinKey getAnyKey() {
        throw new RuntimeException("Not applicable");
    }

    @Override
    public void dumpMetrics() {
    }

    @Override
    public boolean hasSpill() {
        return false;
    }

    @Override
    public int size() {
        return this.vectorMapJoinFastHashTable.size();
    }

    @Override
    public void setSerde(MapJoinObjectSerDeContext keyCtx, MapJoinObjectSerDeContext valCtx) throws SerDeException {
    }
}

