/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainSQRewriteTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExplainSQRewriteWork;

public class ExplainSQRewriteSemanticAnalyzer
extends BaseSemanticAnalyzer {
    List<FieldSchema> fieldList;

    public ExplainSQRewriteSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.ctx.setExplain(true);
        ASTNode input = (ASTNode)ast.getChild(0);
        SemanticAnalyzer sem = (SemanticAnalyzer)SemanticAnalyzerFactory.get(this.queryState, input);
        sem.analyze(input, this.ctx);
        sem.validate();
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        ExplainSQRewriteWork work = new ExplainSQRewriteWork(this.ctx.getResFile().toString(), sem.getQB(), input, this.ctx);
        ExplainSQRewriteTask explTask = (ExplainSQRewriteTask)TaskFactory.get(work, this.conf, new Task[0]);
        this.fieldList = explTask.getResultSchema();
        this.rootTasks.add(explTask);
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.fieldList;
    }
}

