/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.ConvertTreeReaderFactory;

public class SchemaEvolution {
    private final TypeDescription[] readerFileTypes;
    private final boolean[] included;
    private final TypeDescription fileSchema;
    private final TypeDescription readerSchema;
    private boolean hasConversion;
    private final boolean[] ppdSafeConversion;
    public static final List<String> acidEventFieldNames = new ArrayList<String>();

    public SchemaEvolution(TypeDescription fileSchema, boolean[] includedCols) {
        this(fileSchema, null, includedCols);
    }

    public SchemaEvolution(TypeDescription fileSchema, TypeDescription readerSchema, boolean[] includeCols) {
        this.included = includeCols == null ? null : Arrays.copyOf(includeCols, includeCols.length);
        this.hasConversion = false;
        this.fileSchema = fileSchema;
        if (readerSchema != null) {
            this.readerSchema = SchemaEvolution.checkAcidSchema(fileSchema) ? SchemaEvolution.createEventSchema(readerSchema) : readerSchema;
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            this.buildConversionFileTypesArray(fileSchema, this.readerSchema);
        } else {
            this.readerSchema = fileSchema;
            this.readerFileTypes = new TypeDescription[this.readerSchema.getMaximumId() + 1];
            this.buildSameSchemaFileTypesArray();
        }
        this.ppdSafeConversion = this.populatePpdSafeConversion();
    }

    public TypeDescription getReaderSchema() {
        return this.readerSchema;
    }

    public boolean hasConversion() {
        return this.hasConversion;
    }

    public TypeDescription getFileType(TypeDescription readerType) {
        return this.getFileType(readerType.getId());
    }

    public TypeDescription getFileType(int id) {
        return this.readerFileTypes[id];
    }

    public boolean isPPDSafeConversion(int colId) {
        if (this.hasConversion()) {
            if (colId < 0 || colId >= this.ppdSafeConversion.length) {
                return false;
            }
            return this.ppdSafeConversion[colId];
        }
        return true;
    }

    private boolean[] populatePpdSafeConversion() {
        boolean safePpd;
        if (this.fileSchema == null || this.readerSchema == null || this.readerFileTypes == null) {
            return null;
        }
        boolean[] result = new boolean[this.readerSchema.getMaximumId() + 1];
        result[this.readerSchema.getId()] = safePpd = this.validatePPDConversion(this.fileSchema, this.readerSchema);
        List<TypeDescription> children = this.readerSchema.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                TypeDescription fileType = this.getFileType(child.getId());
                result[child.getId()] = safePpd = this.validatePPDConversion(fileType, child);
            }
        }
        return result;
    }

    private boolean validatePPDConversion(TypeDescription fileType, TypeDescription readerType) {
        if (fileType == null) {
            return false;
        }
        if (fileType.getCategory().isPrimitive()) {
            if (fileType.getCategory().equals((Object)readerType.getCategory())) {
                return !fileType.getCategory().equals((Object)TypeDescription.Category.DECIMAL) || fileType.equals(readerType);
            }
            switch (fileType.getCategory()) {
                case BYTE: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.SHORT) && !readerType.getCategory().equals((Object)TypeDescription.Category.INT) && !readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case SHORT: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.INT) && !readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case INT: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.LONG)) break;
                    return true;
                }
                case STRING: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.VARCHAR)) break;
                    return true;
                }
                case VARCHAR: {
                    if (!readerType.getCategory().equals((Object)TypeDescription.Category.STRING)) break;
                    return true;
                }
            }
        }
        return false;
    }

    void buildConversionFileTypesArray(TypeDescription fileType, TypeDescription readerType) {
        boolean isOk;
        block19: {
            block18: {
                if (this.included != null && !this.included[readerType.getId()]) {
                    return;
                }
                isOk = true;
                if (fileType.getCategory() != readerType.getCategory()) break block18;
                switch (readerType.getCategory()) {
                    case BYTE: 
                    case SHORT: 
                    case INT: 
                    case STRING: 
                    case BOOLEAN: 
                    case LONG: 
                    case DOUBLE: 
                    case FLOAT: 
                    case TIMESTAMP: 
                    case BINARY: 
                    case DATE: {
                        break block19;
                    }
                    case VARCHAR: 
                    case CHAR: {
                        if (fileType.getMaxLength() != readerType.getMaxLength()) {
                            this.hasConversion = true;
                        }
                        break block19;
                    }
                    case DECIMAL: {
                        if (fileType.getPrecision() != readerType.getPrecision() || fileType.getScale() != readerType.getScale()) {
                            this.hasConversion = true;
                        }
                        break block19;
                    }
                    case UNION: 
                    case MAP: 
                    case LIST: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() == readerChildren.size()) {
                            for (int i = 0; i < fileChildren.size(); ++i) {
                                this.buildConversionFileTypesArray(fileChildren.get(i), readerChildren.get(i));
                            }
                        } else {
                            isOk = false;
                        }
                        break block19;
                    }
                    case STRUCT: {
                        List<TypeDescription> fileChildren = fileType.getChildren();
                        List<TypeDescription> readerChildren = readerType.getChildren();
                        if (fileChildren.size() != readerChildren.size()) {
                            this.hasConversion = true;
                        }
                        int jointSize = Math.min(fileChildren.size(), readerChildren.size());
                        for (int i = 0; i < jointSize; ++i) {
                            this.buildConversionFileTypesArray(fileChildren.get(i), readerChildren.get(i));
                        }
                        break block19;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown type " + readerType);
                    }
                }
            }
            isOk = ConvertTreeReaderFactory.canConvert(fileType, readerType);
            this.hasConversion = true;
        }
        if (isOk) {
            int id = readerType.getId();
            if (this.readerFileTypes[id] != null) {
                throw new RuntimeException("reader to file type entry already assigned");
            }
        } else {
            throw new IllegalArgumentException(String.format("ORC does not support type conversion from file type %s (%d) to reader type %s (%d)", fileType.toString(), fileType.getId(), readerType.toString(), readerType.getId()));
        }
        this.readerFileTypes[id] = fileType;
    }

    private void buildSameSchemaFileTypesArray() {
        this.buildSameSchemaFileTypesArrayRecurse(this.readerSchema);
    }

    void buildSameSchemaFileTypesArrayRecurse(TypeDescription readerType) {
        if (this.included != null && !this.included[readerType.getId()]) {
            return;
        }
        int id = readerType.getId();
        if (this.readerFileTypes[id] != null) {
            throw new RuntimeException("reader to file type entry already assigned");
        }
        this.readerFileTypes[id] = readerType;
        List<TypeDescription> children = readerType.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                this.buildSameSchemaFileTypesArrayRecurse(child);
            }
        }
    }

    private static boolean checkAcidSchema(TypeDescription type) {
        List<String> rootFields;
        return type.getCategory().equals((Object)TypeDescription.Category.STRUCT) && acidEventFieldNames.equals(rootFields = type.getFieldNames());
    }

    public static TypeDescription createEventSchema(TypeDescription typeDescr) {
        TypeDescription result = TypeDescription.createStruct().addField("operation", TypeDescription.createInt()).addField("originalTransaction", TypeDescription.createLong()).addField("bucket", TypeDescription.createInt()).addField("rowId", TypeDescription.createLong()).addField("currentTransaction", TypeDescription.createLong()).addField("row", typeDescr.clone());
        return result;
    }

    static {
        acidEventFieldNames.add("operation");
        acidEventFieldNames.add("originalTransaction");
        acidEventFieldNames.add("bucket");
        acidEventFieldNames.add("rowId");
        acidEventFieldNames.add("currentTransaction");
        acidEventFieldNames.add("row");
    }
}

