/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;

public class TruncateTableHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        AlterTableMessage msg = this.deserializer.getAlterTableMessage(context.dmd.getPayload());
        String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
        String actualTblName = context.isTableNameEmpty() ? msg.getTable() : context.tableName;
        TruncateTableDesc truncateTableDesc = new TruncateTableDesc(actualDbName + "." + actualTblName, null, context.eventOnlyReplicationSpec());
        Task<DDLWork> truncateTableTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.readEntitySet, (HashSet<WriteEntity>)this.writeEntitySet, truncateTableDesc), context.hiveConf);
        context.log.debug("Added truncate tbl task : {}:{}", (Object)truncateTableTask.getId(), (Object)truncateTableDesc.getTableName());
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
        return Collections.singletonList(truncateTableTask);
    }
}

