/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;

public class LlapTokenSelector
implements TokenSelector<LlapTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(LlapTokenSelector.class);

    public Token<LlapTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Looking for a token with service " + service));
        }
        for (Token<? extends TokenIdentifier> token : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Token = " + token.getKind() + "; service = " + token.getService()));
            }
            if (!LlapTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !service.equals((Object)token.getService())) continue;
            Token<? extends TokenIdentifier> result = token;
            return result;
        }
        return null;
    }
}

