/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.UUID;

public class Digester {
    private final UUID nsuid;
    private final MessageDigest md;
    private static final UUID TEMP_NS;

    private static MessageDigest createDigest() {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("SHA not supported");
        }
        return md;
    }

    private static MessageDigest digest(MessageDigest md, UUID uid) {
        if (uid != null) {
            long msb = uid.getMostSignificantBits();
            Digester.digest(md, msb);
            long lsb = uid.getLeastSignificantBits();
            Digester.digest(md, lsb);
        }
        return md;
    }

    private static void digest(MessageDigest md, InputStream input) {
        try (TagOutputStream out = new TagOutputStream(md);){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = input.read(buffer, 0, 1024)) >= 0) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        catch (IOException xio) {
            throw new IllegalStateException(xio);
        }
    }

    private static void digest(MessageDigest md, long l8) {
        md.update((byte)(l8 & 0xFFL));
        md.update((byte)(l8 >> 8));
        md.update((byte)(l8 >> 16));
        md.update((byte)(l8 >> 24));
        md.update((byte)(l8 >> 32));
        md.update((byte)(l8 >> 40));
        md.update((byte)(l8 >> 48));
        md.update((byte)(l8 >> 56));
    }

    private static void digest(MessageDigest md, Object obj) {
        if (obj == null) {
            return;
        }
        try (ObjectOutputStream out = new ObjectOutputStream(new TagOutputStream(md));){
            out.writeObject(obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static UUID computeUUID(MessageDigest md) {
        byte[] sha1Bytes = md.digest();
        sha1Bytes[6] = (byte)(sha1Bytes[6] & 0xF);
        sha1Bytes[6] = (byte)(sha1Bytes[6] | 0x50);
        sha1Bytes[8] = (byte)(sha1Bytes[8] & 0x3F);
        sha1Bytes[8] = (byte)(sha1Bytes[8] | 0x80);
        long msb = 0L;
        for (int i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(sha1Bytes[i] & 0xFF);
        }
        long lsb = 0L;
        for (int i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(sha1Bytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }

    public Digester(UUID namespace) {
        this.nsuid = namespace == null ? TEMP_NS : namespace;
        this.md = Digester.createDigest();
        Digester.digest(this.md, this.nsuid);
    }

    private Digester(UUID lnsuid, MessageDigest lmd) {
        this.nsuid = lnsuid;
        this.md = lmd;
    }

    public Digester() {
        this(null);
    }

    public Digester copy() {
        try {
            return new Digester(this.nsuid, (MessageDigest)this.md.clone());
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public UUID getUUID() {
        UUID uuid = Digester.computeUUID(this.md);
        this.md.reset();
        this.digest(this.nsuid);
        return uuid;
    }

    public Digester digest(boolean b) {
        this.md.update((byte)(b ? 1 : 0));
        return this;
    }

    public Digester digest(char c) {
        this.md.update((byte)(c & 0xFF));
        this.md.update((byte)(c >> 8));
        return this;
    }

    public Digester digest(byte[] bytes) {
        if (bytes != null) {
            this.md.update(bytes);
        }
        return this;
    }

    public Digester digest(int i4) {
        this.md.update((byte)(i4 & 0xFF));
        this.md.update((byte)(i4 >> 8));
        this.md.update((byte)(i4 >> 16));
        this.md.update((byte)(i4 >> 24));
        return this;
    }

    public Digester digest(long l8) {
        Digester.digest(this.md, l8);
        return this;
    }

    public Digester digest(double f8) {
        Digester.digest(this.md, Double.doubleToRawLongBits(f8));
        return this;
    }

    public Digester digest(Date date) {
        if (date != null) {
            Digester.digest(this.md, date.getTime());
        }
        return this;
    }

    public Digester digest(String str) {
        if (str != null) {
            int sz = str.length();
            for (int i = 0; i < sz; ++i) {
                this.digest(str.charAt(i));
            }
        }
        return this;
    }

    public Digester digest(UUID uid) {
        Digester.digest(this.md, uid);
        return this;
    }

    public Digester digest(URI uri) {
        Digester.digest(this.md, uri.toString());
        return this;
    }

    public Digester digest(Digestible digestible) {
        if (digestible != null) {
            digestible.digest(this);
        }
        return this;
    }

    public Digester digest(InputStream input) {
        if (input != null) {
            Digester.digest(this.md, input);
        }
        return this;
    }

    public Digester digest(Object obj) {
        if (obj instanceof Digestible) {
            return this.digest((Digestible)obj);
        }
        if (obj instanceof UUID) {
            return this.digest((UUID)obj);
        }
        if (obj instanceof URI) {
            return this.digest((URI)obj);
        }
        if (obj instanceof String) {
            return this.digest((String)obj);
        }
        if (obj instanceof Date) {
            return this.digest((Date)obj);
        }
        if (obj instanceof Integer) {
            return this.digest((Integer)obj);
        }
        if (obj instanceof Long) {
            return this.digest((Long)obj);
        }
        if (obj instanceof Double) {
            return this.digest((Double)obj);
        }
        if (obj instanceof Boolean) {
            return this.digest((Boolean)obj);
        }
        if (obj instanceof Character) {
            return this.digest(((Character)obj).charValue());
        }
        if (obj instanceof Short) {
            return this.digest(((Short)obj).intValue());
        }
        if (obj instanceof Float) {
            return this.digest(((Float)obj).doubleValue());
        }
        if (obj != null && obj.getClass().isArray()) {
            int sz = Array.getLength(obj);
            for (int i = 0; i < sz; ++i) {
                this.digest(Array.get(obj, i));
            }
            return this;
        }
        Digester.digest(this.md, obj);
        return this;
    }

    static {
        MessageDigest md = Digester.createDigest();
        Digester.digest(md, System.currentTimeMillis());
        TEMP_NS = Digester.computeUUID(md);
    }

    public static interface Digestible {
        public boolean digest(Digester var1);
    }

    private static class TagOutputStream
    extends OutputStream {
        private final MessageDigest md;

        TagOutputStream(MessageDigest md) {
            this.md = md;
        }

        @Override
        public void write(int b) throws IOException {
            this.md.update((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.md.update(b, off, len);
        }
    }
}

