/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.http.conn.ssl.CertificatesToPlayWith;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SubjectName;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.PublicSuffixListParser;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultHostnameVerifier {
    private DefaultHostnameVerifier impl;
    private PublicSuffixMatcher publicSuffixMatcher;
    private DefaultHostnameVerifier implWithPublicSuffixCheck;
    private static final String PUBLIC_SUFFIX_MATCHER_SOURCE_FILE = "suffixlistmatcher.txt";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @Before
    public void setup() throws IOException {
        this.impl = new DefaultHostnameVerifier();
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(PUBLIC_SUFFIX_MATCHER_SOURCE_FILE);
        Assert.assertNotNull((Object)in);
        List lists = new PublicSuffixListParser().parseByType((Reader)new InputStreamReader(in, UTF_8));
        this.publicSuffixMatcher = new PublicSuffixMatcher((Collection)lists);
        this.implWithPublicSuffixCheck = new DefaultHostnameVerifier(this.publicSuffixMatcher);
    }

    @Test
    public void testVerify() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.impl.verify("bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_NO_CNS_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_THREE_CNS_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "a.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.exceptionPlease(this.impl, "a.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.impl, "a.\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.impl.verify("www.foo.com", x509);
        this.impl.verify("\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_CO_JP);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.co.jp", x509);
        this.impl.verify("foo.co.jp", x509);
        this.impl.verify("\u82b1\u5b50.co.jp", x509);
        this.exceptionPlease(this.implWithPublicSuffixCheck, "foo.co.jp", x509);
        this.exceptionPlease(this.implWithPublicSuffixCheck, "\u82b1\u5b50.co.jp", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_WILD_FOO_BAR_HANAKO);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.exceptionPlease(this.impl, "foo.com", x509);
        this.exceptionPlease(this.impl, "www.foo.com", x509);
        this.exceptionPlease(this.impl, "\u82b1\u5b50.foo.com", x509);
        this.exceptionPlease(this.impl, "a.b.foo.com", x509);
        this.exceptionPlease(this.impl, "bar.com", x509);
        this.impl.verify("www.bar.com", x509);
        this.impl.verify("\u82b1\u5b50.bar.com", x509);
        this.exceptionPlease(this.impl, "a.b.bar.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_VALUE_AVA);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("repository.infonotary.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.S_GOOGLE_COM);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.google.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.S_GOOGLE_COM);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("*.Google.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.IP_1_1_1_1);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("1.1.1.1", x509);
        this.exceptionPlease(this.impl, "1.1.1.2", x509);
        this.exceptionPlease(this.impl, "dummy-value.com", x509);
        in = new ByteArrayInputStream(CertificatesToPlayWith.EMAIL_ALT_SUBJECT_NAME);
        x509 = (X509Certificate)cf.generateCertificate(in);
        this.impl.verify("www.company.com", x509);
    }

    @Test
    public void testSubjectAlt() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(CertificatesToPlayWith.X509_MULTIPLE_SUBJECT_ALT);
        X509Certificate x509 = (X509Certificate)cf.generateCertificate(in);
        Assert.assertEquals((Object)"CN=localhost, OU=Unknown, O=Unknown, L=Unknown, ST=Unknown, C=CH", (Object)x509.getSubjectDN().getName());
        this.impl.verify("localhost.localdomain", x509);
        this.impl.verify("127.0.0.1", x509);
        try {
            this.impl.verify("localhost", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException ex) {
            // empty catch block
        }
        try {
            this.impl.verify("local.host", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException ex) {
            // empty catch block
        }
        try {
            this.impl.verify("127.0.0.2", x509);
            Assert.fail((String)"SSLException should have been thrown");
        }
        catch (SSLException ex) {
            // empty catch block
        }
    }

    public void exceptionPlease(DefaultHostnameVerifier hv, String host, X509Certificate x509) {
        try {
            hv.verify(host, x509);
            Assert.fail((String)("HostnameVerifier shouldn't allow [" + host + "]"));
        }
        catch (SSLException e) {
            // empty catch block
        }
    }

    @Test
    public void testDomainRootMatching() {
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", null));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", (String)"a.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"aa.b.c", (String)"a.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.b.c", (String)"aa.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchDomainRoot((String)"a.a.b.c", (String)"a.b.c"));
    }

    @Test
    public void testIdentityMatching() {
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.b.c", (String)"*.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.b.c", (String)"*.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"*.a.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"*.a.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.com", (String)"*.gov.com", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"s.a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"s.a.gov.uk", (String)"a*.gov.uk", (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.b.*"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.b.*"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"*.*.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"*.*.c"));
    }

    @Test
    public void testHTTPCLIENT_1097() {
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.b.c", (String)"a*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.b.c", (String)"a*.b.c"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"a.a.b.c", (String)"a*.b.c"));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"a.a.b.c", (String)"a*.b.c"));
    }

    @Test
    public void testHTTPCLIENT_1255() {
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)"mail.a.b.c.com", (String)"m*.a.b.c.com"));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)"mail.a.b.c.com", (String)"m*.a.b.c.com"));
    }

    @Test
    public void testHTTPCLIENT_1997_ANY() {
        String domain = "dev.b.cloud.a";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        domain = "dev.b.cloud.com";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        domain = "dev.b.cloud.lan";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain)));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher));
    }

    @Test
    public void testHTTPCLIENT_1997_ICANN() {
        String domain = "dev.b.cloud.a";
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        domain = "dev.b.cloud.com";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        domain = "dev.b.cloud.lan";
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.ICANN));
    }

    @Test
    public void testHTTPCLIENT_1997_PRIVATE() {
        String domain = "dev.b.cloud.a";
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        domain = "dev.b.cloud.com";
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        Assert.assertFalse((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        domain = "dev.b.cloud.lan";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.PRIVATE));
    }

    @Test
    public void testHTTPCLIENT_1997_UNKNOWN() {
        String domain = "dev.b.cloud.a";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        domain = "dev.b.cloud.com";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        domain = "dev.b.cloud.lan";
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentity((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
        Assert.assertTrue((boolean)DefaultHostnameVerifier.matchIdentityStrict((String)("service.apps." + domain), (String)("*.apps." + domain), (PublicSuffixMatcher)this.publicSuffixMatcher, (DomainType)DomainType.UNKNOWN));
    }

    @Test
    public void testHTTPCLIENT_1316() throws Exception {
        String host1 = "2001:0db8:aaaa:bbbb:cccc:0:0:0001";
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Arrays.asList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001")));
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Arrays.asList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::1")));
        try {
            DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001", Arrays.asList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::10")));
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException expected) {
            // empty catch block
        }
        String host2 = "2001:0db8:aaaa:bbbb:cccc::1";
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Arrays.asList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc:0:0:0001")));
        DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Arrays.asList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::1")));
        try {
            DefaultHostnameVerifier.matchIPv6Address((String)"2001:0db8:aaaa:bbbb:cccc::1", Arrays.asList(SubjectName.IP((String)"2001:0db8:aaaa:bbbb:cccc::10")));
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    @Test
    public void testExtractCN() throws Exception {
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah, ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah, cn=yada, cn=booh"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"c = pampa ,  cn  =    blah    , ou = blah , o = blah"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah\", ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah  blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah  blah\", ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah, blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=\"blah, blah\", ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah, blah", (Object)DefaultHostnameVerifier.extractCN((String)"cn=blah\\, blah, ou=blah, o=blah"));
        Assert.assertEquals((Object)"blah", (Object)DefaultHostnameVerifier.extractCN((String)"c = cn=uuh, cn=blah, ou=blah, o=blah"));
        try {
            DefaultHostnameVerifier.extractCN((String)"blah,blah");
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException expected) {
            // empty catch block
        }
        try {
            DefaultHostnameVerifier.extractCN((String)"cn,o=blah");
            Assert.fail((String)"SSLException expected");
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchDNSName() throws Exception {
        DefaultHostnameVerifier.matchDNSName((String)"host.domain.com", Collections.singletonList(SubjectName.DNS((String)"*.domain.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"host.xx", Collections.singletonList(SubjectName.DNS((String)"*.xx")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"host.appspot.com", Collections.singletonList(SubjectName.DNS((String)"*.appspot.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"demo-s3-bucket.s3.eu-central-1.amazonaws.com", Collections.singletonList(SubjectName.DNS((String)"*.s3.eu-central-1.amazonaws.com")), (PublicSuffixMatcher)this.publicSuffixMatcher);
        DefaultHostnameVerifier.matchDNSName((String)"hostname-workspace-1.local", Collections.singletonList(SubjectName.DNS((String)"hostname-workspace-1.local")), (PublicSuffixMatcher)this.publicSuffixMatcher);
    }
}

