/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.http.conn.util.DomainType;
import org.apache.http.conn.util.PublicSuffixListParser;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPublicSuffixMatcher {
    private static final String SOURCE_FILE = "suffixlistmatcher.txt";
    private PublicSuffixMatcher matcher;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @Before
    public void setUp() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(SOURCE_FILE);
        Assert.assertNotNull((Object)in);
        List lists = new PublicSuffixListParser().parseByType((Reader)new InputStreamReader(in, UTF_8));
        this.matcher = new PublicSuffixMatcher((Collection)lists);
    }

    @Test
    public void testGetDomainRootAnyType() {
        Assert.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("example.XX"));
        Assert.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.example.XX"));
        Assert.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX"));
        Assert.assertEquals((Object)"appspot.com", (Object)this.matcher.getDomainRoot("example.appspot.com"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("jp"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("ac.jp"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("any.tokyo.jp"));
        Assert.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp"));
        Assert.assertEquals((Object)"blah.blah.tokyo.jp", (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp"));
        Assert.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.blah.ac.jp"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("garbage"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("garbage.garbage"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage"));
        Assert.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage"));
    }

    @Test
    public void testGetDomainRootOnlyPRIVATE() {
        Assert.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("example.XX", DomainType.PRIVATE));
        Assert.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.example.XX", DomainType.PRIVATE));
        Assert.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX", DomainType.PRIVATE));
        Assert.assertEquals((Object)"appspot.com", (Object)this.matcher.getDomainRoot("example.appspot.com"));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("jp", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("ac.jp", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("any.tokyo.jp", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("metro.tokyo.jp", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("blah.blah.ac.jp", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("garbage", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("garbage.garbage", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("*.garbage.garbage", DomainType.PRIVATE));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage", DomainType.PRIVATE));
    }

    @Test
    public void testGetDomainRootOnlyICANN() {
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("example.XX", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("www.example.XX", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("xx", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("jp", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("ac.jp", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("any.tokyo.jp", DomainType.ICANN));
        Assert.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp", DomainType.ICANN));
        Assert.assertEquals((Object)"blah.blah.tokyo.jp", (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp", DomainType.ICANN));
        Assert.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.blah.ac.jp", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("garbage", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("garbage.garbage", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("*.garbage.garbage", DomainType.ICANN));
        Assert.assertEquals(null, (Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage", DomainType.ICANN));
    }

    @Test
    public void testMatch() {
        Assert.assertTrue((boolean)this.matcher.matches(".jp"));
        Assert.assertTrue((boolean)this.matcher.matches(".ac.jp"));
        Assert.assertTrue((boolean)this.matcher.matches(".any.tokyo.jp"));
        Assert.assertFalse((boolean)this.matcher.matches(".metro.tokyo.jp"));
        Assert.assertFalse((boolean)this.matcher.matches(".xx"));
        Assert.assertFalse((boolean)this.matcher.matches(".appspot.com"));
    }

    @Test
    public void testMatchUnicode() {
        Assert.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assert.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
        Assert.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assert.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
    }
}

