/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.HttpContentProducer;
import org.apache.http.util.Args;

@NotThreadSafe
public abstract class AbstractImmutableHttpEntity
implements HttpEntity,
HttpContentProducer {
    static final int OUTPUT_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull(outstream, "Output stream");
        InputStream instream = this.getContent();
        if (instream != null) {
            try {
                int l;
                byte[] tmp = new byte[4096];
                while ((l = instream.read(tmp)) != -1) {
                    outstream.write(tmp, 0, l);
                }
            }
            finally {
                instream.close();
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("Content-Type: ");
        sb.append(this.getContentType());
        sb.append(',');
        sb.append("Content-Encoding: ");
        sb.append(this.getContentEncoding());
        sb.append(',');
        long len = this.getContentLength();
        if (len >= 0L) {
            sb.append("Content-Length: ");
            sb.append(len);
            sb.append(',');
        }
        sb.append("Chunked: ");
        sb.append(this.isChunked());
        sb.append(']');
        return sb.toString();
    }
}

