/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderIterator;
import org.apache.http.message.BasicTokenIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpRequest request, HttpResponse response, HttpContext context) {
        Header[] connHeaders;
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        if (request != null && (connHeaders = request.getHeaders("Connection")).length != 0) {
            BasicTokenIterator ti = new BasicTokenIterator(new BasicHeaderIterator(connHeaders, null));
            while (ti.hasNext()) {
                String token = (String)ti.next();
                if (!"close".equalsIgnoreCase(token)) continue;
                return false;
            }
        }
        ProtocolVersion ver = response.getStatusLine().getProtocolVersion();
        Header teh = response.getFirstHeader("Transfer-Encoding");
        if (teh != null ? !"chunked".equalsIgnoreCase(teh.getValue()) : this.canResponseHaveBody(response) && response.containsHeaders("Content-Length") != 1) {
            return false;
        }
        Header[] connHeaders2 = response.getHeaders("Connection");
        if (connHeaders2.length == 0) {
            connHeaders2 = response.getHeaders("Proxy-Connection");
        }
        if (connHeaders2.length != 0) {
            if (ver.greaterEquals(HttpVersion.HTTP_1_1)) {
                BasicTokenIterator it = new BasicTokenIterator(new BasicHeaderIterator(connHeaders2, null));
                while (it.hasNext()) {
                    String token = (String)it.next();
                    if (!"close".equalsIgnoreCase(token)) continue;
                    return false;
                }
                return true;
            }
            BasicTokenIterator it = new BasicTokenIterator(new BasicHeaderIterator(connHeaders2, null));
            while (it.hasNext()) {
                String token = (String)it.next();
                if (!"keep-alive".equalsIgnoreCase(token)) continue;
                return true;
            }
            return false;
        }
        return ver.greaterEquals(HttpVersion.HTTP_1_1);
    }

    private boolean canResponseHaveBody(HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }
}

