/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.DefaultHttpRequestFactory;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.message.LineParser;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpRequestParser
extends AbstractMessageParser<HttpRequest> {
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParser(LineParser lineParser, HttpRequestFactory requestFactory, MessageConstraints constraints) {
        super(lineParser, constraints);
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParser(MessageConstraints constraints) {
        this(null, null, constraints);
    }

    public DefaultHttpRequestParser() {
        this(MessageConstraints.DEFAULT);
    }

    @Override
    protected IOException createConnectionClosedException() {
        return new ConnectionClosedException("Client closed connection");
    }

    @Override
    protected HttpRequest createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        RequestLine requestLine = this.getLineParser().parseRequestLine(buffer);
        ProtocolVersion version = requestLine.getProtocolVersion();
        if (version.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException("Unsupported version: " + version);
        }
        return this.requestFactory.newHttpRequest(requestLine);
    }
}

