/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.protocol;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.annotation.Immutable;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class RequestValidateHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        ProtocolVersion version = request.getProtocolVersion();
        if (version.greaterEquals(HttpVersion.HTTP_1_1)) {
            int n = request.containsHeaders("Host");
            if (n == 0) {
                throw new ProtocolException("Host header is absent");
            }
            if (n > 1) {
                throw new ProtocolException("Multiple Host headers found");
            }
        }
    }
}

